/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.datasources;

import java.util.Deque;
import java.util.LinkedList;
import org.mazarineblue.datasources.AbstractSourceWrapper;
import org.mazarineblue.datasources.DataSource;

public class ScopedSource<Container extends DataSource>
extends AbstractSourceWrapper<Container> {
    private final Deque<Container> stack = new LinkedList<Container>();

    public ScopedSource() {
    }

    public ScopedSource(Container source) {
        super(source);
    }

    public void push(Container source) {
        this.stack.push(this.getSource());
        this.setSource(source);
    }

    public boolean remove(Container source) {
        if (this.getSource().equals(source)) {
            this.setSource(this.pop());
            return true;
        }
        if (this.stack.size() == 0) {
            throw new IllegalStateException("There are no stacked sources to pop");
        }
        return this.stack.remove(source);
    }

    public final Container pop() {
        if (this.stack.size() == 0) {
            throw new IllegalStateException("There are no stacked sources to pop");
        }
        Object tmp = this.getSource();
        this.setSource((DataSource)this.stack.pop());
        return tmp;
    }
}

