/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.datasources;

import java.util.HashMap;
import java.util.Map;
import org.mazarineblue.datasources.MatrixSource;
import org.mazarineblue.datasources.exceptions.IllegalSourceStateException;
import org.mazarineblue.datasources.exceptions.MatrixConfigurationException;

public class ObjectMatrixSource
extends MatrixSource {
    private final Object[][] matrix;
    private int row = 0;

    public ObjectMatrixSource(String sourceIdentifier, Object[][] matrix, boolean withHeaders) throws MatrixConfigurationException {
        super(sourceIdentifier, ObjectMatrixSource.initHeaders(matrix, withHeaders));
        this.matrix = ObjectMatrixSource.initMatrix(matrix, withHeaders);
        this.row = withHeaders ? 1 : 0;
    }

    private static Map<String, Integer> initHeaders(Object[][] matrix, boolean withHeaders) throws MatrixConfigurationException {
        if (!withHeaders) {
            return null;
        }
        if (matrix.length < 1) {
            throw new MatrixConfigurationException("Matrix must have at least 1 row");
        }
        HashMap<String, Integer> header = new HashMap<String, Integer>();
        for (int column = 0; column < matrix[0].length; ++column) {
            if (!(matrix[0][column] instanceof String)) {
                throw new MatrixConfigurationException("Matrix[0][" + column + "] must be a string");
            }
            header.put((String)matrix[0][column], column);
        }
        return header;
    }

    private static Object[][] initMatrix(Object[][] matrix, boolean withHeaders) throws MatrixConfigurationException {
        int offset;
        int m;
        int n = matrix.length;
        int n2 = m = matrix.length == 0 ? 0 : matrix[0].length;
        if (withHeaders) {
            --n;
        }
        if (n < 0) {
            n = 0;
        }
        for (int row = 1; row < matrix.length; ++row) {
            if (matrix[row].length >= m) continue;
            throw new MatrixConfigurationException("Matrix[" + row + "] must have " + m + " columns");
        }
        Object[][] output = new Object[n][m];
        for (int row = offset = withHeaders ? 1 : 0; row < matrix.length; ++row) {
            output[row - offset] = new Object[m];
            for (int column = 0; column < m; ++column) {
                output[row - offset][column] = matrix[row][column];
            }
        }
        return output;
    }

    @Override
    public boolean hasNext() {
        return this.row < this.matrix.length;
    }

    @Override
    public String next() {
        ++this.row;
        return this.getSourceIdentifier() + ":" + this.row;
    }

    @Override
    public String reset() {
        this.row = 0;
        return this.getSourceIdentifier() + ":" + this.row;
    }

    @Override
    public String getLineIdentifier() throws IllegalSourceStateException {
        return this.getSourceIdentifier() + ":" + this.row;
    }

    @Override
    public Object getData(int index) throws IllegalSourceStateException {
        return this.matrix[this.row][index];
    }

    @Override
    public boolean setData(int index, Object value) {
        this.matrix[this.row][index] = value;
        return true;
    }
}

