/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.datasources;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.mazarineblue.datasources.ArraySource;
import org.mazarineblue.datasources.DataSource;
import org.mazarineblue.datasources.exceptions.DataValidationException;
import org.mazarineblue.datasources.exceptions.IllegalSourceStateException;

public class ObjectArraySource
extends ArraySource {
    private final Map<String, Object> map;

    public ObjectArraySource(String sourceName) {
        this(sourceName, true);
    }

    public ObjectArraySource(String sourceName, DataSource source) throws IllegalSourceStateException, DataValidationException {
        this(sourceName, false);
        String mark = source.reset();
        this.fillArray1(source);
        source.reset();
        this.fillArray2(source);
        source.reset(mark);
    }

    private void fillArray1(DataSource source) throws IllegalSourceStateException, DataValidationException {
        String[] columns = source.getColumns();
        while (source.hasNext()) {
            source.next();
            String firstColumn = source.getData(0, String.class);
            for (String column : columns) {
                Object obj = source.getData(column);
                this.put(firstColumn + '.' + column, obj);
            }
        }
    }

    private void fillArray2(DataSource source) throws IllegalSourceStateException, DataValidationException {
        String[] columns = source.getColumns();
        while (source.hasNext()) {
            source.next();
            String firstColumn = source.getData(0, String.class);
            for (String column : columns) {
                String key = column + '.' + firstColumn;
                Object obj = source.getData(column);
                if (this.containsKey(key)) continue;
                this.put(key, obj);
            }
        }
    }

    public ObjectArraySource(String sourceName, boolean initialize) {
        super(sourceName);
        this.map = new HashMap<String, Object>();
        if (initialize) {
            this.next();
        }
    }

    public ObjectArraySource(String sourceName, Map<String, Object> map) {
        this(sourceName, map, false);
    }

    public ObjectArraySource(String sourceName, Map<String, Object> map, boolean initialize) {
        super(sourceName);
        this.map = map;
        if (initialize) {
            this.next();
        }
    }

    public Map<String, Object> fetchMap() {
        HashMap<String, Object> copy = new HashMap<String, Object>();
        copy.putAll(this.map);
        return copy;
    }

    public void readPlainText(InputStream input) throws IOException {
        InputStreamReader reader = new InputStreamReader(input);
        BufferedReader convertor = new BufferedReader(reader);
        String str = convertor.readLine();
        while (str != null) {
            String[] arr = str.split(":", 2);
            this.processPlainText(arr[0], arr[1]);
            str = convertor.readLine();
        }
    }

    private Object processPlainText(String columnKey, Object value) {
        return this.map.put(columnKey, value);
    }

    public final boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public final Object put(String columnKey, Object value) {
        return this.map.put(columnKey, value);
    }

    public void putAll(Map<? extends String, ? extends Object> m) {
        this.map.putAll(m);
    }

    public Object putIfAbsent(String key, Object value) {
        return this.map.putIfAbsent(key, value);
    }

    @Override
    public Object getData(String column) throws IllegalSourceStateException {
        this.validateState();
        return this.map.get(column);
    }

    @Override
    public Object getData(int index) {
        return null;
    }

    @Override
    public boolean setData(String column, Object value) {
        this.map.put(column, value);
        return true;
    }

    @Override
    public boolean setData(int index, Object value) {
        return false;
    }

    @Override
    public String[] getColumns() {
        return this.map.keySet().toArray(new String[0]);
    }
}

