/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.datasources;

import java.util.Map;
import java.util.Set;
import org.mazarineblue.datasources.AbstractSource;
import org.mazarineblue.datasources.exceptions.IllegalSourceStateException;

public abstract class MatrixSource
extends AbstractSource {
    private final Map<String, Integer> headers;

    public MatrixSource(String sourceIdentifier) {
        super(sourceIdentifier);
        this.headers = null;
    }

    public MatrixSource(String sourceIdentifier, Map<String, Integer> headers) {
        super(sourceIdentifier);
        this.headers = headers;
    }

    public boolean hasHeaders() {
        return this.headers != null;
    }

    @Override
    public Object getData(String column) throws IllegalSourceStateException {
        if (this.headers == null) {
            throw new IllegalSourceStateException("This source doesn't have a header");
        }
        Integer index = this.headers.get(column);
        if (index == null) {
            return null;
        }
        return this.getData(index);
    }

    @Override
    public boolean setData(String column, Object value) throws Exception {
        if (this.headers == null) {
            throw new IllegalSourceStateException("This source doesn't have a header");
        }
        Integer index = this.headers.get(column);
        if (index == null) {
            return false;
        }
        return this.setData(index, value);
    }

    @Override
    public String[] getColumns() {
        Set<String> keys = this.headers.keySet();
        return keys.toArray(new String[0]);
    }
}

