/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.datasources;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.mazarineblue.datasources.MatrixSource;
import org.mazarineblue.datasources.exceptions.DataValidationException;
import org.mazarineblue.datasources.exceptions.IllegalSourceStateException;

public class ExcelSource
extends MatrixSource {
    private final Sheet sheet;
    private final int lastRow;
    private int firstRow = -1;
    private Row currentRow = null;
    private Integer index;

    private static Map<String, Integer> getHeaders(Sheet sheet) throws DataValidationException {
        int i;
        int firstRow = sheet.getFirstRowNum();
        Row header = sheet.getRow(firstRow);
        short n = header.getLastCellNum();
        try {
            HashMap<String, Integer> headers = new HashMap<String, Integer>();
            for (i = header.getFirstCellNum(); i < n; ++i) {
                Cell cell = header.getCell(i);
                if (cell == null) continue;
                String columnName = cell.getStringCellValue();
                headers.put(columnName, i);
            }
            return headers;
        }
        catch (Exception ex) {
            DataValidationException dex = new DataValidationException("Header cell at index " + i + " must contains a string", ex);
            throw dex;
        }
    }

    public ExcelSource(String sourceIdentifier, Sheet sheet, boolean hasHeader) throws DataValidationException {
        super(sourceIdentifier, hasHeader ? ExcelSource.getHeaders(sheet) : null);
        this.sheet = sheet;
        this.lastRow = sheet.getLastRowNum();
    }

    public ExcelSource(String sourceIdentifier, Sheet sheet) {
        super(sourceIdentifier);
        this.sheet = sheet;
        this.lastRow = sheet.getLastRowNum();
    }

    @Override
    public boolean hasNext() {
        if (this.firstRow < 0) {
            int index = this.sheet.getFirstRowNum();
            if (this.hasHeaders()) {
                return ++index <= this.lastRow;
            }
            Row row = this.getRow(index);
            return row != null;
        }
        int index = this.getNextContentRow();
        return index <= this.lastRow;
    }

    @Override
    public String next() {
        try {
            if (this.needsInitilization()) {
                this.firstRow = this.getFirstContentRow();
                this.index = this.firstRow;
                this.currentRow = this.getRow(this.firstRow);
                return this.getLineIdentifier();
            }
            if (this.index >= this.lastRow) {
                return null;
            }
            this.index = this.index + 1;
            this.currentRow = this.getRow(this.index);
            return this.getLineIdentifier();
        }
        catch (IllegalSourceStateException ex) {
            Logger logger = Logger.getLogger(ExcelSource.class.getName());
            logger.log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private boolean needsInitilization() {
        return this.firstRow < 0;
    }

    private int getFirstContentRow() {
        int index = this.sheet.getFirstRowNum();
        if (this.hasHeaders()) {
            ++index;
        }
        return index;
    }

    private int getNextContentRow() {
        return this.index + 1;
    }

    private Row getRow(int index) {
        return index > this.lastRow ? null : this.sheet.getRow(index);
    }

    @Override
    public String reset() {
        this.firstRow = -1;
        this.currentRow = null;
        this.index = null;
        return this.lineIdentifier();
    }

    @Override
    public String getLineIdentifier() throws IllegalSourceStateException {
        if (this.firstRow < 0) {
            throw new IllegalSourceStateException("The method next was never called");
        }
        return this.lineIdentifier();
    }

    private String lineIdentifier() {
        if (this.index == null || this.index > this.lastRow || this.lastRow == 0) {
            return null;
        }
        return this.sheet.getSheetName() + ":" + this.index;
    }

    @Override
    public Object getData(int index) throws IllegalSourceStateException {
        if (this.firstRow < 0) {
            throw new IllegalSourceStateException("The method next was never called");
        }
        if (this.currentRow == null) {
            return index == 0 ? "" : null;
        }
        Cell cell = this.currentRow.getCell(index);
        return ExcelSource.getData(cell);
    }

    private static Object getData(Cell cell) {
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case 0: {
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getDateCellValue();
                }
                return cell.getNumericCellValue();
            }
            case 1: {
                return cell.getStringCellValue();
            }
            case 2: {
                return cell.getCellFormula();
            }
            case 3: {
                return "";
            }
            case 4: {
                return cell.getBooleanCellValue();
            }
            case 5: {
                return cell.getErrorCellValue();
            }
        }
        return cell.getStringCellValue();
    }

    @Override
    public boolean setData(String column, Object value) throws Exception {
        return false;
    }

    @Override
    public boolean setData(int index, Object value) {
        return false;
    }
}

