/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.datasources;

import org.mazarineblue.datasources.exceptions.DataValidationException;
import org.mazarineblue.datasources.exceptions.IllegalSourceStateException;
import org.mazarineblue.parser.VariableSource;

public interface DataSource
extends VariableSource {
    public boolean hasNext();

    public String next();

    public String reset();

    default public String reset(String mark) {
        String current = this.reset();
        if (mark == null) {
            return current;
        }
        while (!mark.equals(current)) {
            current = this.next();
        }
        return current;
    }

    public String getSourceIdentifier();

    public String getLineIdentifier() throws IllegalSourceStateException;

    default public <T> T getData(String column, Class<T> objectType) throws IllegalSourceStateException, DataValidationException {
        Object obj = this.getData(column);
        if (obj == null) {
            return null;
        }
        if (!obj.getClass().equals(objectType)) {
            throw new DataValidationException("Data is of wrong type at column " + column);
        }
        return (T)obj;
    }

    public Object getData(String var1) throws IllegalSourceStateException;

    default public <T> T getData(int index, Class<T> objectType) throws IllegalSourceStateException, DataValidationException {
        Object obj = this.getData(index);
        if (obj == null) {
            return null;
        }
        if (!obj.getClass().equals(objectType)) {
            throw new DataValidationException("Data is of wrong type at index " + index);
        }
        return (T)obj;
    }

    public Object getData(int var1) throws IllegalSourceStateException;

    public boolean setData(String var1, Object var2) throws Exception;

    public boolean setData(int var1, Object var2);

    public String[] getColumns();
}

