/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.datasources;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mazarineblue.datasources.ArraySource;
import org.mazarineblue.datasources.ObjectArraySource;
import org.mazarineblue.datasources.exceptions.BlackboardException;
import org.mazarineblue.datasources.exceptions.IllegalSourceStateException;
import org.mazarineblue.datasources.exceptions.ScopeNotFoundException;
import org.mazarineblue.datasources.exceptions.VariableAlreadyDeclared;

public class BlackboardSource
extends ArraySource {
    public static final String LOCAL = "Local";
    public static final String SHEET = "Sheet";
    public static final String GLOBAL = "Global";
    private final Deque<ObjectArraySource> stack = new ArrayDeque<ObjectArraySource>();

    public BlackboardSource(String identifier) {
        super(identifier, true);
    }

    public String toString() {
        String msg = null;
        for (String column : this.getColumns()) {
            try {
                msg = msg == null ? "BlackboardSource{" : msg + ", ";
                msg = msg + column + "='" + this.getData(column) + "'";
            }
            catch (IllegalSourceStateException ex) {
                msg = msg + column + "=exception";
            }
        }
        if (msg == null) {
            msg = "BlackboardSource{";
        }
        return msg + '}';
    }

    public void setup() {
        this.setup(null);
    }

    public void setup(Map<String, Object> presetVariables) {
        if (!this.stack.isEmpty()) {
            throw new IllegalStateException("This blackboard is already used");
        }
        ObjectArraySource source = new ObjectArraySource(GLOBAL, true);
        if (presetVariables != null) {
            for (Map.Entry<String, Object> entry : presetVariables.entrySet()) {
                source.put(entry.getKey(), entry.getValue());
            }
        }
        this.stack.add(source);
    }

    public void teardown() {
        this.stack.pop();
        if (!this.stack.isEmpty()) {
            throw new IllegalStateException("This blackboard stack must be empty");
        }
    }

    public void pushSource(String scope) {
        ObjectArraySource source = new ObjectArraySource(scope, true);
        this.stack.add(source);
    }

    public void pushSource(ObjectArraySource source) {
        this.stack.add(source);
    }

    public ObjectArraySource popSource() {
        return this.stack.pop();
    }

    public ObjectArraySource popSource(ObjectArraySource source) throws BlackboardException {
        return this.popSource(source.getSourceIdentifier());
    }

    public ObjectArraySource popSource(String scope) throws BlackboardException {
        Iterator<ObjectArraySource> it = this.stack.iterator();
        while (it.hasNext()) {
            ObjectArraySource source = it.next();
            if (!scope.equals(source.getSourceIdentifier())) continue;
            it.remove();
            return source;
        }
        throw new ScopeNotFoundException(scope);
    }

    public void declareVariable(String name) throws BlackboardException {
        ObjectArraySource source = this.stack.getFirst();
        this.declareVariable(source, name);
    }

    public void declareVariable(String scope, String name) throws BlackboardException {
        ObjectArraySource source = this.findByScope(scope);
        this.declareVariable(source, name);
    }

    private ObjectArraySource findByScope(String scope) throws BlackboardException {
        for (ObjectArraySource source : this.stack) {
            if (!scope.equals(source.getSourceIdentifier())) continue;
            return source;
        }
        throw new ScopeNotFoundException(scope);
    }

    private void declareVariable(ObjectArraySource source, String name) throws BlackboardException {
        if (source.containsKey(name)) {
            throw new VariableAlreadyDeclared(name);
        }
        source.put(name, null);
    }

    @Override
    public final Object getData(String column) throws IllegalSourceStateException {
        for (ObjectArraySource source : this.stack) {
            if (!source.containsKey(column)) continue;
            return source.getData(column);
        }
        return null;
    }

    @Override
    public Object getData(int index) throws IllegalSourceStateException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean setData(String column, Object value) {
        ObjectArraySource source = this.findByName(column);
        source.setData(column, value);
        return true;
    }

    private ObjectArraySource findByName(String name) {
        for (ObjectArraySource source : this.stack) {
            if (!source.containsKey(name)) continue;
            return source;
        }
        return this.stack.getFirst();
    }

    @Override
    public boolean setData(int index, Object value) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public final String[] getColumns() {
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<String> list = new ArrayList<String>();
        for (ObjectArraySource source : this.stack) {
            for (String column : source.getColumns()) {
                if (map.containsKey(column)) continue;
                map.put(column, column);
                list.add(column);
            }
        }
        return list.toArray(new String[list.size()]);
    }
}

