/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.datasources;

import org.mazarineblue.datasources.AbstractSource;
import org.mazarineblue.datasources.exceptions.IllegalSourceStateException;

public abstract class ArraySource
extends AbstractSource {
    private boolean initialized = false;

    public ArraySource(String sourceName) {
        super(sourceName);
    }

    public ArraySource(String sourceName, boolean initialize) {
        super(sourceName);
        this.initialized = initialize;
    }

    protected void validateState() throws IllegalSourceStateException {
        if (!this.initialized) {
            throw new IllegalSourceStateException("Next was never called");
        }
    }

    @Override
    public boolean hasNext() {
        return !this.initialized;
    }

    @Override
    public String next() {
        this.initialized = true;
        return null;
    }

    @Override
    public String reset() {
        this.initialized = false;
        return "";
    }

    @Override
    public String getLineIdentifier() throws IllegalSourceStateException {
        this.validateState();
        return "";
    }
}

