/*
 * Copyright (c) 2012-2014 Alex de Kruijff
 * Copyright (c) 2014-2015 Specialisterren
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package org.mazarineblue.datasources;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.mazarineblue.datasources.exceptions.IllegalSourceStateException;

/**
 *
 * @author Alex de Kruijff {@literal <alex.de.kruijff@MazarineBlue.org>}
 */
public class ResourceSource
        extends ArraySource {

    private final ResourceBundle bundle;

    /**
     * Gets a resource bundle as data source.
     *
     * @param sourceName the name of the source
     * @param baseName the base name of the resource bundle.
     * @exception java.lang.NullPointerException if <code>baseName</code> is
     * <code>null</code>
     * @exception MissingResourceException if no resource bundle for the
     * specified base name can be found
     */
    public ResourceSource(String sourceName, String baseName) {
        super(sourceName);
        bundle = ResourceBundle.getBundle(baseName);
    }

    public ResourceSource(String sourceName, ResourceBundle bundle) {
        super(sourceName);
        this.bundle = bundle;
    }

    @Override
    public Object getData(String column) {
        return bundle.getString(column);
    }

    @Override
    public Object getData(int index)
            throws IllegalSourceStateException {
        return null;
    }

    @Override
    public boolean setData(String column, Object value)
            throws Exception {
        return false;
    }

    @Override
    public boolean setData(int index, Object value) {
        return false;
    }

    @Override
    public String[] getColumns() {
        return null;
    }
}
