/*
 * Copyright (c) 2012-2014 Alex de Kruijff
 * Copyright (c) 2014-2015 Specialisterren
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package org.mazarineblue.datasources;

import org.mazarineblue.datasources.exceptions.IllegalSourceStateException;

/**
 *
 * @author Alex de Kruijff {@literal <alex.de.kruijff@MazarineBlue.org>}
 */
public class NullDataSource
        extends ArraySource {

    public NullDataSource() {
        this("No DataSource");
    }

    public NullDataSource(String sourceName) {
        super(sourceName);
    }

    @Override
    public Object getData(String column)
            throws IllegalSourceStateException {
        return null;
    }

    @Override
    public Object getData(int index)
            throws IllegalSourceStateException {
        return null;
    }

    @Override
    public boolean setData(String column, Object value)
            throws Exception {
        return true;
    }

    @Override
    public boolean setData(int index, Object value) {
        return true;
    }

    @Override
    public String[] getColumns() {
        return new String[0];
    }
}
