/*
 * Copyright (c) 2012-2014 Alex de Kruijff
 * Copyright (c) 2014-2015 Specialisterren
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package org.mazarineblue.datasources;

import java.util.Map;
import java.util.Set;
import org.mazarineblue.datasources.exceptions.IllegalSourceStateException;

/**
 *
 * @author Alex de Kruijff {@literal <alex.de.kruijff@MazarineBlue.org>}
 */
public abstract class MatrixSource
        extends AbstractSource {

    private final Map<String, Integer> headers;

    public MatrixSource(String sourceIdentifier) {
        super(sourceIdentifier);
        this.headers = null;
    }

    public MatrixSource(String sourceIdentifier, Map<String, Integer> headers) {
        super(sourceIdentifier);
        this.headers = headers;
    }

    public boolean hasHeaders() {
        return headers != null;
    }

    @Override
    public Object getData(String column)
            throws IllegalSourceStateException {
        if (headers == null)
            throw new IllegalSourceStateException(
                    "This source doesn't have a header");
        Integer index = headers.get(column);
        if (index == null)
            return null;
        return getData(index);
    }

    @Override
    public boolean setData(String column, Object value)
            throws Exception {
        if (headers == null)
            throw new IllegalSourceStateException(
                    "This source doesn't have a header");
        Integer index = headers.get(column);
        if (index == null)
            return false;
        return setData(index, value);
    }

    @Override
    public String[] getColumns() {
        Set<String> keys = headers.keySet();
        return keys.toArray(new String[0]);
    }
}
