/*
 * Copyright (c) 2012-2014 Alex de Kruijff
 * Copyright (c) 2014-2015 Specialisterren
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package org.mazarineblue.datasources;

import org.mazarineblue.datasources.exceptions.IllegalSourceStateException;

/**
 *
 * @author Alex de Kruijff {@literal <alex.de.kruijff@MazarineBlue.org>}
 */
public abstract class ArraySource
        extends AbstractSource {

    private boolean initialized = false;

    public ArraySource(String sourceName) {
        super(sourceName);
    }

    public ArraySource(String sourceName, boolean initialize) {
        super(sourceName);
        initialized = initialize;
    }

    protected void validateState()
            throws IllegalSourceStateException {
        if (initialized == false)
            throw new IllegalSourceStateException("Next was never called");
    }

    @Override
    public boolean hasNext() {
        return initialized == false;
    }

    @Override
    public String next() {
        initialized = true;
        return null;
    }

    @Override
    public String reset() {
        initialized = false;
        return "";
    }

    @Override
    public String getLineIdentifier()
            throws IllegalSourceStateException {
        validateState();
        return "";
    }
}
