/*
 * Copyright (c) 2012-2014 Alex de Kruijff
 * Copyright (c) 2014-2015 Specialisterren
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package org.mazarineblue.datasources;

import org.mazarineblue.datasources.exceptions.IllegalSourceStateException;

/**
 *
 * @author Alex de Kruijff {@literal <alex.de.kruijff@MazarineBlue.org>}
 */
public abstract class AbstractSourceWrapper<Container extends DataSource>
        implements DataSource {

    private Container source;

    protected AbstractSourceWrapper() {
    }

    protected AbstractSourceWrapper(Container source) {
        this.source = source;
    }

    public Container getSource() {
        return source;
    }

    public boolean isSet() {
        return getSource() != null;
    }

    protected void setSource(Container source) {
        this.source = source;
    }

    @Override
    public boolean hasNext() {
        return source == null ? false : source.hasNext();
    }

    @Override
    public String next() {
        return source == null ? "" : source.next();
    }

    @Override
    public String reset() {
        return source == null ? null : source.reset();
    }

    @Override
    public String getSourceIdentifier() {
        return source == null ? null : source.getSourceIdentifier();
    }

    @Override
    public String getLineIdentifier()
            throws IllegalSourceStateException {
        return source == null ? null : source.getLineIdentifier();
    }

    @Override
    public Object getData(String column)
            throws IllegalSourceStateException {
        return source == null ? null : source.getData(column);
    }

    @Override
    public Object getData(int index)
            throws IllegalSourceStateException {
        return source == null ? null : source.getData(index);
    }

    @Override
    public boolean setData(String column, Object value)
            throws Exception {
        return source == null ? false : source.setData(column, value);
    }

    @Override
    public boolean setData(int index, Object value) {
        return source == null ? false : source.setData(index, value);
    }

    @Override
    public String[] getColumns() {
        return source == null ? new String[0] : source.getColumns();
    }
}
