/*
 * Decompiled with CFR 0.152.
 */
package org.mazarineblue.datasources.keywords;

import java.util.HashMap;
import java.util.Map;
import org.mazarineblue.datasources.DataSource;
import org.mazarineblue.datasources.SourceChain;
import org.mazarineblue.datasources.exceptions.DataSourceNotFoundException;
import org.mazarineblue.datasources.exceptions.SheetTypeUnsupportedException;
import org.mazarineblue.eventbus.Event;
import org.mazarineblue.eventbus.EventHandler;
import org.mazarineblue.eventbus.Subscriber;
import org.mazarineblue.events.GetDataSourceEvent;
import org.mazarineblue.keyworddriven.Keyword;
import org.mazarineblue.keyworddriven.Parameters;
import org.mazarineblue.keyworddriven.librarymanager.Library;

public class DataSourcesLibrary
extends Library {
    private final Map<String, DataSource> sources = new HashMap<String, DataSource>(4);
    private String activeName;
    private DataSource activeSource;
    private Subscriber<Event> subscriber;

    public DataSourcesLibrary() {
        super("org.mazarineblue.datasources");
    }

    protected void setup() {
    }

    protected void teardown() {
    }

    @EventHandler
    public void eventHandler(GetDataSourceEvent event) {
        String name = event.getName();
        DataSource source = name == null ? this.activeSource : this.sources.get(name);
        event.set((Object)source);
        event.setConsumed();
    }

    @Keyword(value="Select source")
    @Parameters(min=1, max=1)
    public void selectSource(String name) {
        if (!this.sources.containsKey(name)) {
            throw new DataSourceNotFoundException("Source '" + name + "' not found.");
        }
        this.activeName = name;
        this.activeSource = this.sources.get(name);
        if (this.activeSource == null) {
            throw new DataSourceNotFoundException(name);
        }
        this.executor().setSource(this.activeSource);
    }

    @Keyword(value="Next source row")
    @Parameters(min=0, max=0)
    public void nextSourceRow() {
        this.activeSource.next();
    }

    @Keyword(value="Data sheet")
    @Parameters(min=3, max=3)
    public void dataSheet(String name, String type, String sheetName) {
        DataSource source;
        if (this.sources.containsKey(name)) {
            this.log().warning("Alreay contains a sheet with the name: " + name);
        }
        switch (type) {
            case "array": {
                source = this.sheetFactory().getArraySource(name, sheetName);
                break;
            }
            case "matrix": {
                source = this.sheetFactory().getMatrixSource(name, sheetName);
                break;
            }
            default: {
                throw new SheetTypeUnsupportedException(type);
            }
        }
        if (source == null) {
            throw new DataSourceNotFoundException(name);
        }
        this.sources.put(name, source);
    }

    @Keyword(value="Chain sources")
    @Parameters(min=2)
    public void chainSources(String name, String ... param) {
        SourceChain head;
        SourceChain foot = head = new SourceChain();
        for (int i = 0; i < param.length; ++i) {
            if (!this.sources.containsKey(param[i])) {
                throw new DataSourceNotFoundException(param[i]);
            }
            DataSource source = this.sources.get(param[i]);
            foot = foot.link(source);
        }
        this.sources.put(name, (DataSource)head);
    }
}

