/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.orderloader.system;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.orderloader.FailedOrderInfo;
import org.marketcetera.orderloader.Messages;
import org.marketcetera.orderloader.MockOrderProcessor;
import org.marketcetera.orderloader.OrderParserTest;
import org.marketcetera.orderloader.OrderParsingException;
import org.marketcetera.orderloader.OrderProcessor;
import org.marketcetera.orderloader.RowProcessor;
import org.marketcetera.orderloader.system.SystemProcessor;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.OptionType;
import org.marketcetera.trade.Order;
import org.marketcetera.trade.OrderCapacity;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.OrderSingle;
import org.marketcetera.trade.OrderType;
import org.marketcetera.trade.PositionEffect;
import org.marketcetera.trade.SecurityType;
import org.marketcetera.trade.Side;
import org.marketcetera.trade.TimeInForce;
import org.marketcetera.trade.TypesTestBase;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.I18NBoundMessage2P;
import org.marketcetera.util.log.I18NMessage;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id$")
public class SystemProcessorTest {
    private final MockOrderProcessor mProcessor = new MockOrderProcessor();

    @Test
    public void constructor() throws Exception {
        new ExpectedFailure<NullPointerException>(){

            protected void run() throws Exception {
                new SystemProcessor(null, new BrokerID("what"));
            }
        };
        new SystemProcessor((OrderProcessor)this.mProcessor, null);
        OrderParserTest.assertProcessor(this.create(null), 0, 0);
    }

    @Test
    public void missingRequiredHeaders() throws Exception {
        new ExpectedFailure<OrderParsingException>((I18NMessage)Messages.MISSING_REQUIRED_FIELD, new Object[]{"OrderType"}){

            protected void run() throws Exception {
                SystemProcessorTest.this.create(null).initialize(new String[]{"Quantity", "Side", "Symbol"});
            }
        };
        new ExpectedFailure<OrderParsingException>((I18NMessage)Messages.MISSING_REQUIRED_FIELD, new Object[]{"Quantity"}){

            protected void run() throws Exception {
                SystemProcessorTest.this.create(null).initialize(new String[]{"OrderType", "Side", "Symbol"});
            }
        };
        new ExpectedFailure<OrderParsingException>((I18NMessage)Messages.MISSING_REQUIRED_FIELD, new Object[]{"Side"}){

            protected void run() throws Exception {
                SystemProcessorTest.this.create(null).initialize(new String[]{"OrderType", "Quantity", "Symbol"});
            }
        };
        new ExpectedFailure<OrderParsingException>((I18NMessage)Messages.MISSING_REQUIRED_FIELD, new Object[]{"Symbol"}){

            protected void run() throws Exception {
                SystemProcessorTest.this.create(null).initialize(new String[]{"OrderType", "Quantity", "Side"});
            }
        };
        this.create(null).initialize(new String[]{"OrderType", "Quantity", "Side", "Symbol"});
    }

    @Test
    public void duplicateHeaders() throws Exception {
        new ExpectedFailure<OrderParsingException>((I18NMessage)Messages.DUPLICATE_HEADER, new Object[]{"OrderType", 0, 4}){

            protected void run() throws Exception {
                SystemProcessorTest.this.create(null).initialize(new String[]{"OrderType", "Quantity", "Side", "Symbol", "OrderType"});
            }
        };
        new ExpectedFailure<OrderParsingException>((I18NMessage)Messages.DUPLICATE_HEADER, new Object[]{"9001", 1, 5}){

            protected void run() throws Exception {
                SystemProcessorTest.this.create(null).initialize(new String[]{"OrderType", "9001", "Quantity", "Side", "Symbol", "9001"});
            }
        };
        new ExpectedFailure<OrderParsingException>((I18NMessage)Messages.DUPLICATE_HEADER, new Object[]{"009001", 1, 5}){

            protected void run() throws Exception {
                SystemProcessorTest.this.create(null).initialize(new String[]{"OrderType", "9001", "Quantity", "Side", "Symbol", "009001"});
            }
        };
    }

    @Test
    public void unknownHeader() throws Exception {
        new ExpectedFailure<OrderParsingException>((I18NMessage)Messages.INVALID_CUSTOM_HEADER, new Object[]{"What", 1}){

            protected void run() throws Exception {
                SystemProcessorTest.this.create(null).initialize(new String[]{"OrderType", "What", "Quantity", "Side", "Symbol"});
            }
        };
    }

    @Test
    public void minimalFields() throws Exception {
        RowProcessor processor = this.create(null);
        processor.initialize(new String[]{"Side", "Symbol", "OrderType", "Quantity"});
        processor.processOrder(0, new String[]{Side.Buy.toString(), "ubm", OrderType.Market.toString(), "34.34"});
        processor.processOrder(1, new String[]{Side.Sell.toString(), "nubm", OrderType.Limit.toString(), "12.23"});
        OrderParserTest.assertProcessor(processor, 2, 0);
        List<Order> list = this.mProcessor.getOrders();
        Assert.assertEquals((long)2L, (long)list.size());
        TypesTestBase.assertOrderSingle((OrderSingle)((OrderSingle)list.get(0)), (OrderID)TypesTestBase.NOT_NULL, (Side)Side.Buy, (BigDecimal)new BigDecimal("34.34"), null, null, (OrderType)OrderType.Market, (Instrument)new Equity("ubm"), (SecurityType)SecurityType.CommonStock, null, null, null, null, null, null);
        TypesTestBase.assertOrderSingle((OrderSingle)((OrderSingle)list.get(1)), (OrderID)TypesTestBase.NOT_NULL, (Side)Side.Sell, (BigDecimal)new BigDecimal("12.23"), null, null, (OrderType)OrderType.Limit, (Instrument)new Equity("nubm"), (SecurityType)SecurityType.CommonStock, null, null, null, null, null, null);
    }

    @Test
    public void customFields() throws Exception {
        RowProcessor processor = this.create(null);
        processor.initialize(new String[]{"Side", "Symbol", "OrderType", "Quantity", "4001", "5001"});
        processor.processOrder(0, new String[]{Side.SellShort.toString(), "zoog", OrderType.Market.toString(), "1", "yes", "no"});
        processor.processOrder(1, new String[]{Side.SellShort.toString(), "zoo", OrderType.Market.toString(), "10", "", "no"});
        processor.processOrder(2, new String[]{Side.Sell.toString(), "moog", OrderType.Limit.toString(), "10", "moo", null});
        OrderParserTest.assertProcessor(processor, 3, 0);
        List<Order> list = this.mProcessor.getOrders();
        Assert.assertEquals((long)3L, (long)list.size());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("4001", "yes");
        map.put("5001", "no");
        TypesTestBase.assertOrderSingle((OrderSingle)((OrderSingle)list.get(0)), (OrderID)TypesTestBase.NOT_NULL, (Side)Side.SellShort, (BigDecimal)BigDecimal.ONE, null, null, (OrderType)OrderType.Market, (Instrument)new Equity("zoog"), (SecurityType)SecurityType.CommonStock, null, null, null, null, null, map);
        map.clear();
        map.put("4001", "");
        map.put("5001", "no");
        TypesTestBase.assertOrderSingle((OrderSingle)((OrderSingle)list.get(1)), (OrderID)TypesTestBase.NOT_NULL, (Side)Side.SellShort, (BigDecimal)BigDecimal.TEN, null, null, (OrderType)OrderType.Market, (Instrument)new Equity("zoo"), (SecurityType)SecurityType.CommonStock, null, null, null, null, null, map);
        map.clear();
        map.put("4001", "moo");
        map.put("5001", null);
        TypesTestBase.assertOrderSingle((OrderSingle)((OrderSingle)list.get(2)), (OrderID)TypesTestBase.NOT_NULL, (Side)Side.Sell, (BigDecimal)BigDecimal.TEN, null, null, (OrderType)OrderType.Limit, (Instrument)new Equity("moog"), (SecurityType)SecurityType.CommonStock, null, null, null, null, null, map);
    }

    @Test
    public void allFields() throws Exception {
        BrokerID brokerID = new BrokerID("broke");
        RowProcessor processor = this.create(brokerID);
        processor.initialize(new String[]{"Account", "OrderCapacity", "OrderType", "PositionEffect", "666", "Price", "Quantity", "SecurityType", "Side", "Symbol", "TimeInForce", "Expiry", "StrikePrice", "OptionType", "2112"});
        processor.processOrder(1, new String[]{"mine", "", OrderType.Market.toString(), "", "beast", "", "3.33", SecurityType.CommonStock.toString(), Side.SellShortExempt.toString(), "vsft", TimeInForce.Day.toString(), null, null, null, "steel"});
        Object[] failRow1 = new String[]{"mine", "", OrderType.Market.toString(), "", "beast", "nice", "3.33", SecurityType.CommonStock.toString(), Side.SellShortExempt.toString(), "vsft", TimeInForce.Day.toString(), null, null, null, "steel"};
        processor.processOrder(2, (String[])failRow1);
        processor.processOrder(3, new String[]{"yours", OrderCapacity.Individual.toString(), OrderType.Limit.toString(), PositionEffect.Close.toString(), "number", "22.2", "9.99", SecurityType.Option.toString(), Side.Buy.toString(), "soft", TimeInForce.FillOrKill.toString(), "20101010", "12.34", "Call", "of"});
        Object[] failRow2 = new String[]{"yours", OrderCapacity.Unknown.toString(), OrderType.Limit.toString(), PositionEffect.Close.toString(), "number", "22.2", "9.99", SecurityType.Option.toString(), Side.Buy.toString(), "soft", TimeInForce.Day.toString(), "20101010", "12.34", "Call", "of"};
        processor.processOrder(4, (String[])failRow2);
        Object[] failRow3 = new String[]{"yours", OrderCapacity.Agency.toString(), OrderType.Limit.toString(), PositionEffect.Close.toString(), "number", "22.2", "9.99", SecurityType.Option.toString(), Side.Buy.toString(), "soft", TimeInForce.Day.toString(), "20101010", "12.34", "Puff", "of"};
        processor.processOrder(5, (String[])failRow3);
        Object[] failRow4 = new String[]{"yours", OrderCapacity.Agency.toString(), OrderType.Limit.toString(), PositionEffect.Close.toString(), "number", "22.2", "9.99", SecurityType.Option.toString(), Side.Buy.toString(), "soft", TimeInForce.Day.toString(), "20101010", "nostrike", "Call", "of"};
        processor.processOrder(6, (String[])failRow4);
        OrderParserTest.assertProcessor(processor, 2, 4);
        List<Order> list = this.mProcessor.getOrders();
        Assert.assertEquals((long)2L, (long)list.size());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("666", "beast");
        map.put("2112", "steel");
        TypesTestBase.assertOrderSingle((OrderSingle)((OrderSingle)list.get(0)), (OrderID)TypesTestBase.NOT_NULL, (Side)Side.SellShortExempt, (BigDecimal)new BigDecimal("3.33"), null, (TimeInForce)TimeInForce.Day, (OrderType)OrderType.Market, (Instrument)new Equity("vsft"), (SecurityType)SecurityType.CommonStock, (String)"mine", null, null, null, (BrokerID)brokerID, map);
        map.clear();
        map.put("666", "number");
        map.put("2112", "of");
        TypesTestBase.assertOrderSingle((OrderSingle)((OrderSingle)list.get(1)), (OrderID)TypesTestBase.NOT_NULL, (Side)Side.Buy, (BigDecimal)new BigDecimal("9.99"), (BigDecimal)new BigDecimal("22.2"), (TimeInForce)TimeInForce.FillOrKill, (OrderType)OrderType.Limit, (Instrument)new Option("soft", "20101010", new BigDecimal("12.34"), OptionType.Call), (SecurityType)SecurityType.Option, (String)"yours", null, (OrderCapacity)OrderCapacity.Individual, (PositionEffect)PositionEffect.Close, (BrokerID)brokerID, map);
        List failed = processor.getFailedOrders();
        Assert.assertEquals((long)4L, (long)failed.size());
        FailedOrderInfo info = (FailedOrderInfo)failed.get(0);
        Assert.assertEquals((long)2L, (long)info.getIndex());
        Assert.assertArrayEquals((Object[])failRow1, (Object[])info.getRow());
        Assert.assertEquals((Object)new I18NBoundMessage1P(Messages.INVALID_PRICE_VALUE, (Serializable)((Object)"nice")), (Object)((OrderParsingException)info.getException()).getI18NBoundMessage());
        info = (FailedOrderInfo)failed.get(1);
        Assert.assertEquals((long)4L, (long)info.getIndex());
        Assert.assertArrayEquals((Object[])failRow2, (Object[])info.getRow());
        EnumSet<OrderCapacity> validValues = EnumSet.allOf(OrderCapacity.class);
        validValues.remove(OrderCapacity.Unknown);
        Assert.assertEquals((Object)new I18NBoundMessage2P(Messages.INVALID_ORDER_CAPACITY, (Serializable)((Object)OrderCapacity.Unknown.toString()), (Serializable)((Object)((Object)validValues).toString())), (Object)((OrderParsingException)info.getException()).getI18NBoundMessage());
        info = (FailedOrderInfo)failed.get(2);
        Assert.assertEquals((long)5L, (long)info.getIndex());
        Assert.assertArrayEquals((Object[])failRow3, (Object[])info.getRow());
        EnumSet<OptionType> validOpTypes = EnumSet.allOf(OptionType.class);
        validOpTypes.remove(OptionType.Unknown);
        Assert.assertEquals((Object)new I18NBoundMessage2P(Messages.INVALID_OPTION_TYPE, (Serializable)((Object)"Puff"), (Serializable)((Object)((Object)validOpTypes).toString())), (Object)((OrderParsingException)info.getException()).getI18NBoundMessage());
        info = (FailedOrderInfo)failed.get(3);
        Assert.assertEquals((long)6L, (long)info.getIndex());
        Assert.assertArrayEquals((Object[])failRow4, (Object[])info.getRow());
        Assert.assertEquals((Object)new I18NBoundMessage1P(Messages.INVALID_STRIKE_PRICE_VALUE, (Serializable)((Object)"nostrike")), (Object)((OrderParsingException)info.getException()).getI18NBoundMessage());
    }

    private RowProcessor create(BrokerID inBrokerID) throws Exception {
        this.mProcessor.getOrders().clear();
        return new SystemProcessor((OrderProcessor)this.mProcessor, inBrokerID);
    }
}

