/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.orderloader.system;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.marketcetera.orderloader.Messages;
import org.marketcetera.orderloader.OrderParsingException;
import org.marketcetera.orderloader.OrderProcessor;
import org.marketcetera.orderloader.RowProcessor;
import org.marketcetera.orderloader.system.AccountProcessor;
import org.marketcetera.orderloader.system.CustomFieldProcessor;
import org.marketcetera.orderloader.system.FieldProcessor;
import org.marketcetera.orderloader.system.InstrumentProcessor;
import org.marketcetera.orderloader.system.OrderCapacityProcessor;
import org.marketcetera.orderloader.system.OrderTypeProcessor;
import org.marketcetera.orderloader.system.PositionEffectProcessor;
import org.marketcetera.orderloader.system.PriceProcessor;
import org.marketcetera.orderloader.system.QuantityProcessor;
import org.marketcetera.orderloader.system.SideProcessor;
import org.marketcetera.orderloader.system.TimeInForceProcessor;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.Factory;
import org.marketcetera.trade.Order;
import org.marketcetera.trade.OrderSingle;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.I18NBoundMessage3P;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: SystemProcessor.java 16154 2012-07-14 16:34:05Z colin $")
public class SystemProcessor
extends RowProcessor {
    public static final String FIELD_ACCOUNT = "Account";
    public static final String FIELD_ORDER_CAPACITY = "OrderCapacity";
    public static final String FIELD_ORDER_TYPE = "OrderType";
    public static final String FIELD_POSITION_EFFECT = "PositionEffect";
    public static final String FIELD_PRICE = "Price";
    public static final String FIELD_QUANTITY = "Quantity";
    public static final String FIELD_SIDE = "Side";
    public static final String FIELD_TIME_IN_FORCE = "TimeInForce";
    private final List<FieldProcessor> mProcessors = new LinkedList<FieldProcessor>();

    public SystemProcessor(OrderProcessor inProcessor, BrokerID inBrokerID) {
        super(inProcessor, inBrokerID);
    }

    @Override
    protected void setHeaders(String[] inHeaders) throws OrderParsingException {
        InstrumentProcessor instrumentProcessor = new InstrumentProcessor();
        CustomFieldProcessor customProcessor = new CustomFieldProcessor();
        HashMap<String, Integer> duplicateDetector = new HashMap<String, Integer>();
        for (int i = 0; i < inHeaders.length; ++i) {
            String header = inHeaders[i];
            Integer oldIndex = duplicateDetector.put(header, i);
            if (oldIndex != null) {
                throw new OrderParsingException((I18NBoundMessage)new I18NBoundMessage3P(Messages.DUPLICATE_HEADER, (Serializable)((Object)header), (Serializable)oldIndex, (Serializable)Integer.valueOf(i)));
            }
            if (FIELD_ACCOUNT.equals(header)) {
                this.mProcessors.add(new AccountProcessor(i));
                continue;
            }
            if (FIELD_ORDER_CAPACITY.equals(header)) {
                this.mProcessors.add(new OrderCapacityProcessor(i));
                continue;
            }
            if (FIELD_ORDER_TYPE.equals(header)) {
                this.mProcessors.add(new OrderTypeProcessor(i));
                continue;
            }
            if (FIELD_POSITION_EFFECT.equals(header)) {
                this.mProcessors.add(new PositionEffectProcessor(i));
                continue;
            }
            if (FIELD_PRICE.equals(header)) {
                this.mProcessors.add(new PriceProcessor(i));
                continue;
            }
            if (FIELD_QUANTITY.equals(header)) {
                this.mProcessors.add(new QuantityProcessor(i));
                continue;
            }
            if (FIELD_SIDE.equals(header)) {
                this.mProcessors.add(new SideProcessor(i));
                continue;
            }
            if (FIELD_TIME_IN_FORCE.equals(header)) {
                this.mProcessors.add(new TimeInForceProcessor(i));
                continue;
            }
            if (instrumentProcessor.canProcess(header, i)) continue;
            customProcessor.addField(i, header);
        }
        this.mProcessors.add(instrumentProcessor);
        if (!customProcessor.isEmpty()) {
            this.mProcessors.add(customProcessor);
        }
        this.requiredFieldPresent(duplicateDetector, FIELD_ORDER_TYPE);
        this.requiredFieldPresent(duplicateDetector, FIELD_QUANTITY);
        this.requiredFieldPresent(duplicateDetector, FIELD_SIDE);
        this.requiredFieldPresent(duplicateDetector, "Symbol");
    }

    @Override
    protected Order parseOrder(String[] inRow) throws OrderParsingException {
        OrderSingle order = Factory.getInstance().createOrderSingle();
        order.setBrokerID(this.geBrokerID());
        for (FieldProcessor p : this.mProcessors) {
            p.apply(inRow, order);
        }
        return order;
    }

    private void requiredFieldPresent(Map<String, Integer> inHeaders, String inField) throws OrderParsingException {
        if (!inHeaders.containsKey(inField)) {
            throw new OrderParsingException((I18NBoundMessage)new I18NBoundMessage1P(Messages.MISSING_REQUIRED_FIELD, (Serializable)((Object)inField)));
        }
    }
}

