/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.orderloader.system;

import org.marketcetera.core.instruments.DynamicInstrumentHandler;
import org.marketcetera.orderloader.OrderParsingException;
import org.marketcetera.orderloader.system.Row;
import org.marketcetera.orderloader.system.SecurityTypeProcessor;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.SecurityType;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: InstrumentFromRow.java 16154 2012-07-14 16:34:05Z colin $")
public abstract class InstrumentFromRow
extends DynamicInstrumentHandler<Row> {
    public static final String FIELD_SYMBOL = "Symbol";
    public static final String FIELD_SECURITY_TYPE = "SecurityType";
    private SecurityTypeProcessor mSecurityProcessor = null;
    private int mSymbolIdx;

    protected abstract boolean canProcess(String var1, int var2);

    protected final String getSymbol(String[] inRow) {
        return inRow[this.mSymbolIdx];
    }

    protected final SecurityType getSecurityType(String[] inRow) throws OrderParsingException {
        return this.mSecurityProcessor != null ? (SecurityType)this.mSecurityProcessor.getEnumValue(inRow) : null;
    }

    final boolean processHeader(String inHeader, int inIndex) {
        boolean isHandled = false;
        if (FIELD_SYMBOL.equals(inHeader)) {
            this.setSymbolIdx(inIndex);
            isHandled = true;
        } else if (FIELD_SECURITY_TYPE.equals(inHeader)) {
            this.setSecurityTypeProcessor(inIndex);
            isHandled = true;
        } else if (this.canProcess(inHeader, inIndex)) {
            isHandled = true;
        }
        return isHandled;
    }

    protected abstract Instrument extract(Row var1) throws OrderParsingException;

    private void setSymbolIdx(int inSymbolIdx) {
        this.mSymbolIdx = inSymbolIdx;
    }

    private void setSecurityTypeProcessor(int inSecurityTypeIdx) {
        this.mSecurityProcessor = new SecurityTypeProcessor(inSecurityTypeIdx);
    }
}

