/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.orderloader;

import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.marketcetera.client.ClientParameters;
import org.marketcetera.core.ApplicationContainer;
import org.marketcetera.core.ApplicationVersion;
import org.marketcetera.orderloader.FailedOrderInfo;
import org.marketcetera.orderloader.Messages;
import org.marketcetera.orderloader.OrderLoader;
import org.marketcetera.orderloader.OrderProcessor;
import org.marketcetera.orderloader.ServerOrderProcessor;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;
import org.springframework.context.Lifecycle;

@ClassVersion(value="$Id: OrderLoaderMain.java 16841 2014-02-20 19:59:04Z colin $")
public class OrderLoaderMain
implements Lifecycle {
    private final Options options = OrderLoaderMain.options();
    private PrintStream mMsgStream = System.err;
    private String mMode;
    private BrokerID mBrokerID;
    private String mFilename;
    private static final String OPT_MODE = "m";
    private static final String OPT_BROKER = "b";
    private static final String OPT_USERNAME = "u";
    private static final String OPT_PASSWORD = "p";
    private final AtomicBoolean running = new AtomicBoolean(false);
    private String clientUsername;
    private char[] clientPassword;
    private String clientURL;
    private String clientWsHost;
    private String clientIdPrefix;
    private String clientWsPort;

    public boolean isRunning() {
        return this.running.get();
    }

    public void start() {
        this.run(this.getArgs());
        this.running.set(true);
        this.exit();
    }

    public void stop() {
        this.running.set(false);
    }

    public String getClientUsername() {
        return this.clientUsername;
    }

    public void setClientUsername(String inClientUsername) {
        this.clientUsername = inClientUsername;
    }

    public void setClientPassword(char[] inClientPassword) {
        this.clientPassword = inClientPassword;
    }

    public String getClientURL() {
        return this.clientURL;
    }

    public void setClientURL(String inClientURL) {
        this.clientURL = inClientURL;
    }

    public String getClientWsHost() {
        return this.clientWsHost;
    }

    public void setClientWsHost(String inClientWsHost) {
        this.clientWsHost = inClientWsHost;
    }

    public String getClientIdPrefix() {
        return this.clientIdPrefix;
    }

    public void setClientIdPrefix(String inClientIdPrefix) {
        this.clientIdPrefix = inClientIdPrefix;
    }

    public String getClientWsPort() {
        return this.clientWsPort;
    }

    public void setClientWsPort(String inClientWsPort) {
        this.clientWsPort = inClientWsPort;
    }

    protected void setMsgStream(PrintStream inMsgStream) {
        this.mMsgStream = inMsgStream;
    }

    protected void exit() {
        ApplicationContainer.stopInstanceWaiting();
    }

    protected String[] getArgs() {
        return ApplicationContainer.getInstanceArguments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doProcessing() throws Exception {
        ClientParameters parameters = new ClientParameters(this.clientUsername, this.clientPassword, this.clientURL, this.clientWsHost, Integer.parseInt(this.clientWsPort), this.clientIdPrefix);
        OrderProcessor processor = this.createProcessor(parameters);
        try {
            this.displaySummary(new OrderLoader(this.mMode, this.mBrokerID, processor, new File(this.mFilename)));
        }
        finally {
            processor.done();
        }
    }

    protected OrderProcessor createProcessor(ClientParameters inParameters) throws Exception {
        return new ServerOrderProcessor(inParameters);
    }

    protected void displaySummary(OrderLoader inLoader) {
        this.printMessage(Messages.LINE_SUMMARY.getText((Object)inLoader.getNumLines(), (Object)inLoader.getNumBlankLines(), (Object)inLoader.getNumComments()));
        this.printMessage(Messages.ORDER_SUMMARY.getText((Object)inLoader.getNumSuccess(), (Object)inLoader.getNumFailed()));
        List<FailedOrderInfo> list = inLoader.getFailedOrders();
        if (!list.isEmpty()) {
            this.printMessage(Messages.FAILED_ORDERS.getText());
            for (FailedOrderInfo info : list) {
                this.printMessage(Messages.FAILED_ORDER.getText((Object)info.getIndex(), (Object)Arrays.toString(info.getRow()), (Object)this.getExceptionMsg(info.getException())));
            }
        }
    }

    protected void printMessage(String inMessage) {
        this.mMsgStream.println(inMessage);
    }

    protected void printError(Exception inException) {
        this.printMessage(this.getExceptionMsg(inException));
        SLF4JLoggerProxy.debug((Object)this, (Throwable)inException);
    }

    protected String getExceptionMsg(Exception inException) {
        if (inException instanceof I18NException) {
            return ((I18NException)inException).getLocalizedDetail();
        }
        return inException.getLocalizedMessage();
    }

    private void run(String[] inArgs) {
        this.printMessage(Messages.LOG_APP_COPYRIGHT.getText());
        this.printMessage(Messages.LOG_APP_VERSION_BUILD.getText((Object)ApplicationVersion.getVersion(), (Object)ApplicationVersion.getBuildNumber()));
        try {
            this.execute(new GnuParser().parse(OrderLoaderMain.options(), inArgs));
        }
        catch (Exception e) {
            this.printError(e);
            this.usage();
        }
    }

    private void execute(CommandLine inLine) throws Exception {
        if (inLine.hasOption(OPT_USERNAME)) {
            this.clientUsername = inLine.getOptionValue(OPT_USERNAME);
        }
        if (inLine.hasOption(OPT_PASSWORD)) {
            this.clientPassword = inLine.getOptionValue(OPT_PASSWORD).toCharArray();
        }
        if (inLine.hasOption(OPT_MODE)) {
            this.mMode = inLine.getOptionValue(OPT_MODE);
        }
        if (inLine.hasOption(OPT_BROKER)) {
            this.mBrokerID = new BrokerID(inLine.getOptionValue(OPT_BROKER));
        }
        if (inLine.getArgList().isEmpty()) {
            throw new IllegalArgumentException(Messages.ERROR_MISSING_FILE.getText());
        }
        this.mFilename = String.valueOf(inLine.getArgList().remove(0));
        if (!inLine.getArgList().isEmpty()) {
            throw new IllegalArgumentException(Messages.ERROR_TOO_MANY_ARGUMENTS.getText());
        }
        this.doProcessing();
    }

    private static Options options() {
        Options opts = new Options();
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)Messages.ARG_MODE_VALUE.getText());
        OptionBuilder.withDescription((String)Messages.ARG_MODE_DESCRIPTION.getText());
        OptionBuilder.isRequired((boolean)false);
        opts.addOption(OptionBuilder.create((String)OPT_MODE));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)Messages.ARG_BROKER_VALUE.getText());
        OptionBuilder.withDescription((String)Messages.ARG_BROKER_DESCRIPTION.getText());
        OptionBuilder.isRequired((boolean)false);
        opts.addOption(OptionBuilder.create((String)OPT_BROKER));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)Messages.ARG_USERNAME_VALUE.getText());
        OptionBuilder.withDescription((String)Messages.ARG_USERNAME_DESCRIPTION.getText());
        OptionBuilder.isRequired((boolean)false);
        opts.addOption(OptionBuilder.create((String)OPT_USERNAME));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)Messages.ARG_PASSWORD_VALUE.getText());
        OptionBuilder.withDescription((String)Messages.ARG_PASSWORD_DESCRIPTION.getText());
        OptionBuilder.isRequired((boolean)false);
        opts.addOption(OptionBuilder.create((String)OPT_PASSWORD));
        return opts;
    }

    private void usage() {
        HelpFormatter formatter = new HelpFormatter();
        PrintWriter pw = new PrintWriter(this.mMsgStream);
        pw.append(Messages.ERROR_USAGE.getText());
        pw.println();
        formatter.printOptions(pw, 74, this.options, 1, 3);
        pw.println();
        pw.flush();
        this.exit();
    }
}

