/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.orderloader.system;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.orderloader.Messages;
import org.marketcetera.orderloader.OrderParsingException;
import org.marketcetera.orderloader.system.AccountProcessor;
import org.marketcetera.orderloader.system.CustomFieldProcessor;
import org.marketcetera.orderloader.system.FieldProcessor;
import org.marketcetera.orderloader.system.InstrumentProcessor;
import org.marketcetera.orderloader.system.OrderCapacityProcessor;
import org.marketcetera.orderloader.system.OrderTypeProcessor;
import org.marketcetera.orderloader.system.PositionEffectProcessor;
import org.marketcetera.orderloader.system.PriceProcessor;
import org.marketcetera.orderloader.system.QuantityProcessor;
import org.marketcetera.orderloader.system.SideProcessor;
import org.marketcetera.orderloader.system.TimeInForceProcessor;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.Factory;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.OptionType;
import org.marketcetera.trade.OrderCapacity;
import org.marketcetera.trade.OrderSingle;
import org.marketcetera.trade.OrderType;
import org.marketcetera.trade.PositionEffect;
import org.marketcetera.trade.SecurityType;
import org.marketcetera.trade.Side;
import org.marketcetera.trade.TimeInForce;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.I18NBoundMessage2P;
import org.marketcetera.util.log.I18NMessage;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: FieldProcessorTest.java 16994 2015-03-09 21:18:25Z colin $")
public class FieldProcessorTest {
    @Test
    public void account() throws Exception {
        AccountProcessor proc = new AccountProcessor(1);
        Assert.assertEquals((Object)"dfd", (Object)FieldProcessorTest.apply((FieldProcessor)proc, "acc", "dfd", "").getAccount());
        proc = new AccountProcessor(0);
        Assert.assertEquals((Object)"acc", (Object)FieldProcessorTest.apply((FieldProcessor)proc, "acc", "dfd", "").getAccount());
        Assert.assertEquals((Object)"", (Object)FieldProcessorTest.apply((FieldProcessor)proc, "", "dfd", "").getAccount());
        Assert.assertEquals(null, (Object)FieldProcessorTest.apply((FieldProcessor)proc, null, "dfd", "").getAccount());
    }

    @Test
    public void custom() throws Exception {
        CustomFieldProcessor custom = new CustomFieldProcessor();
        Assert.assertTrue((boolean)custom.isEmpty());
        custom.addField(0, "3001");
        custom.addField(3, "3009");
        Assert.assertFalse((boolean)custom.isEmpty());
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("3001", "one");
        fields.put("3009", "four");
        Assert.assertEquals(fields, (Object)FieldProcessorTest.apply((FieldProcessor)custom, "one", "two", "three", "four", "five").getCustomFields());
        fields.clear();
        fields.put("3001", "");
        fields.put("3009", null);
        Assert.assertEquals(fields, (Object)FieldProcessorTest.apply((FieldProcessor)custom, "", "two", "three", null, "five").getCustomFields());
    }

    @Test
    public void orderCapacity() throws Exception {
        final OrderCapacityProcessor proc = new OrderCapacityProcessor(2);
        Assert.assertEquals(null, (Object)FieldProcessorTest.apply((FieldProcessor)proc, "blue", "green", "", "red").getOrderCapacity());
        Assert.assertEquals((Object)OrderCapacity.Principal, (Object)FieldProcessorTest.apply((FieldProcessor)proc, "blue", "green", OrderCapacity.Principal.toString(), "red").getOrderCapacity());
        EnumSet<OrderCapacity> validValues = EnumSet.allOf(OrderCapacity.class);
        validValues.remove(OrderCapacity.Unknown);
        new ExpectedFailure<OrderParsingException>((I18NMessage)Messages.INVALID_ORDER_CAPACITY, new Object[]{"blues", ((Object)validValues).toString()}){

            protected void run() throws Exception {
                FieldProcessorTest.apply((FieldProcessor)proc, new String[]{"red", "greed", "blues", "clues"});
            }
        };
        new ExpectedFailure<OrderParsingException>((I18NMessage)Messages.INVALID_ORDER_CAPACITY, new Object[]{OrderCapacity.Unknown.toString(), ((Object)validValues).toString()}){

            protected void run() throws Exception {
                FieldProcessorTest.apply((FieldProcessor)proc, new String[]{"red", "greed", OrderCapacity.Unknown.toString(), "clues"});
            }
        };
    }

    @Test
    public void orderType() throws Exception {
        final OrderTypeProcessor proc = new OrderTypeProcessor(2);
        Assert.assertEquals(null, (Object)FieldProcessorTest.apply((FieldProcessor)proc, "blue", "green", "", "red").getOrderType());
        Assert.assertEquals((Object)OrderType.Limit, (Object)FieldProcessorTest.apply((FieldProcessor)proc, "blue", "green", OrderType.Limit.toString(), "red").getOrderType());
        EnumSet<OrderType> validValues = EnumSet.allOf(OrderType.class);
        validValues.remove(OrderType.Unknown);
        new ExpectedFailure<OrderParsingException>((I18NMessage)Messages.INVALID_ORDER_TYPE, new Object[]{"blues", ((Object)validValues).toString()}){

            protected void run() throws Exception {
                FieldProcessorTest.apply((FieldProcessor)proc, new String[]{"red", "greed", "blues", "clues"});
            }
        };
        new ExpectedFailure<OrderParsingException>((I18NMessage)Messages.INVALID_ORDER_TYPE, new Object[]{OrderType.Unknown.toString(), ((Object)validValues).toString()}){

            protected void run() throws Exception {
                FieldProcessorTest.apply((FieldProcessor)proc, new String[]{"red", "greed", OrderType.Unknown.toString(), "clues"});
            }
        };
    }

    @Test
    public void positionEffect() throws Exception {
        final PositionEffectProcessor proc = new PositionEffectProcessor(2);
        Assert.assertEquals(null, (Object)FieldProcessorTest.apply((FieldProcessor)proc, "blue", "green", "", "red").getPositionEffect());
        Assert.assertEquals((Object)PositionEffect.Close, (Object)FieldProcessorTest.apply((FieldProcessor)proc, "blue", "green", PositionEffect.Close.toString(), "red").getPositionEffect());
        EnumSet<PositionEffect> validValues = EnumSet.allOf(PositionEffect.class);
        validValues.remove(PositionEffect.Unknown);
        new ExpectedFailure<OrderParsingException>((I18NMessage)Messages.INVALID_POSITION_EFFECT, new Object[]{"blues", ((Object)validValues).toString()}){

            protected void run() throws Exception {
                FieldProcessorTest.apply((FieldProcessor)proc, new String[]{"red", "greed", "blues", "clues"});
            }
        };
        new ExpectedFailure<OrderParsingException>((I18NMessage)Messages.INVALID_POSITION_EFFECT, new Object[]{PositionEffect.Unknown.toString(), ((Object)validValues).toString()}){

            protected void run() throws Exception {
                FieldProcessorTest.apply((FieldProcessor)proc, new String[]{"red", "greed", PositionEffect.Unknown.toString(), "clues"});
            }
        };
    }

    @Test
    public void price() throws Exception {
        final PriceProcessor proc = new PriceProcessor(1);
        Assert.assertEquals(null, (Object)FieldProcessorTest.apply((FieldProcessor)proc, "go", "", "step").getPrice());
        Assert.assertEquals(null, (Object)FieldProcessorTest.apply((FieldProcessor)proc, "go", null, "step").getPrice());
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)FieldProcessorTest.apply((FieldProcessor)proc, "go", "1", "step").getPrice());
        Assert.assertEquals((Object)new BigDecimal("10.345"), (Object)FieldProcessorTest.apply((FieldProcessor)proc, "go", "10.345", "yards").getPrice());
        new ExpectedFailure<OrderParsingException>((I18NMessage)Messages.INVALID_PRICE_VALUE, new Object[]{"to"}){

            protected void run() throws Exception {
                FieldProcessorTest.apply((FieldProcessor)proc, new String[]{"go", "to", "hell"});
            }
        };
        new ExpectedFailure<OrderParsingException>((I18NMessage)Messages.INVALID_PRICE_VALUE, new Object[]{" "}){

            protected void run() throws Exception {
                FieldProcessorTest.apply((FieldProcessor)proc, new String[]{"go", " ", "west"});
            }
        };
    }

    @Test
    public void quantity() throws Exception {
        final QuantityProcessor proc = new QuantityProcessor(1);
        Assert.assertEquals(null, (Object)FieldProcessorTest.apply((FieldProcessor)proc, "go", "", "step").getQuantity());
        Assert.assertEquals(null, (Object)FieldProcessorTest.apply((FieldProcessor)proc, "go", null, "step").getQuantity());
        Assert.assertEquals((Object)BigDecimal.ONE, (Object)FieldProcessorTest.apply((FieldProcessor)proc, "go", "1", "step").getQuantity());
        Assert.assertEquals((Object)new BigDecimal("10.345"), (Object)FieldProcessorTest.apply((FieldProcessor)proc, "go", "10.345", "yards").getQuantity());
        new ExpectedFailure<OrderParsingException>((I18NMessage)Messages.INVALID_QUANTITY_VALUE, new Object[]{"to"}){

            protected void run() throws Exception {
                FieldProcessorTest.apply((FieldProcessor)proc, new String[]{"go", "to", "hell"});
            }
        };
        new ExpectedFailure<OrderParsingException>((I18NMessage)Messages.INVALID_QUANTITY_VALUE, new Object[]{" "}){

            protected void run() throws Exception {
                FieldProcessorTest.apply((FieldProcessor)proc, new String[]{"go", " ", "west"});
            }
        };
    }

    @Test
    public void side() throws Exception {
        final SideProcessor proc = new SideProcessor(2);
        Assert.assertEquals(null, (Object)FieldProcessorTest.apply((FieldProcessor)proc, "blue", "green", "", "red").getSide());
        Assert.assertEquals((Object)Side.Buy, (Object)FieldProcessorTest.apply((FieldProcessor)proc, "blue", "green", Side.Buy.toString(), "red").getSide());
        EnumSet<Side> validValues = EnumSet.allOf(Side.class);
        validValues.remove(Side.Unknown);
        new ExpectedFailure<OrderParsingException>((I18NMessage)Messages.INVALID_SIDE, new Object[]{"blues", ((Object)validValues).toString()}){

            protected void run() throws Exception {
                FieldProcessorTest.apply((FieldProcessor)proc, new String[]{"red", "greed", "blues", "clues"});
            }
        };
        new ExpectedFailure<OrderParsingException>((I18NMessage)Messages.INVALID_SIDE, new Object[]{Side.Unknown.toString(), ((Object)validValues).toString()}){

            protected void run() throws Exception {
                FieldProcessorTest.apply((FieldProcessor)proc, new String[]{"red", "greed", Side.Unknown.toString(), "clues"});
            }
        };
    }

    @Test
    public void equityNoSecurityType() throws Exception {
        InstrumentProcessor proc = new InstrumentProcessor();
        Assert.assertTrue((boolean)proc.canProcess("Symbol", 1));
        Assert.assertEquals(null, (Object)FieldProcessorTest.apply((FieldProcessor)proc, "java", null, "mava").getInstrument());
        Assert.assertEquals(null, (Object)FieldProcessorTest.apply((FieldProcessor)proc, "java", "", "mava").getInstrument());
        Assert.assertEquals(null, (Object)FieldProcessorTest.apply((FieldProcessor)proc, "java", "  ", "mava").getInstrument());
        Assert.assertEquals((Object)new Equity("kava"), (Object)FieldProcessorTest.apply((FieldProcessor)proc, "java", "kava", "mava").getInstrument());
    }

    @Test
    public void equityWithSecurityType() throws Exception {
        InstrumentProcessor proc = new InstrumentProcessor();
        Assert.assertTrue((boolean)proc.canProcess("Symbol", 0));
        Assert.assertTrue((boolean)proc.canProcess("SecurityType", 1));
        Assert.assertEquals(null, (Object)FieldProcessorTest.apply((FieldProcessor)proc, null, null, "mava").getInstrument());
        Assert.assertEquals(null, (Object)FieldProcessorTest.apply((FieldProcessor)proc, "", null, "mava").getInstrument());
        Assert.assertEquals(null, (Object)FieldProcessorTest.apply((FieldProcessor)proc, null, SecurityType.CommonStock.toString(), "mava").getInstrument());
        Assert.assertEquals(null, (Object)FieldProcessorTest.apply((FieldProcessor)proc, "", SecurityType.CommonStock.toString(), "mava").getInstrument());
        Assert.assertEquals((Object)new Equity("java"), (Object)FieldProcessorTest.apply((FieldProcessor)proc, "java", null, "mava").getInstrument());
        Assert.assertEquals((Object)new Equity("java"), (Object)FieldProcessorTest.apply((FieldProcessor)proc, "java", "", "mava").getInstrument());
        Assert.assertEquals((Object)new Equity("java"), (Object)FieldProcessorTest.apply((FieldProcessor)proc, " java ", "", "mava").getInstrument());
        Assert.assertEquals((Object)new Equity("java"), (Object)FieldProcessorTest.apply((FieldProcessor)proc, "java", SecurityType.CommonStock.toString(), "mava").getInstrument());
        EnumSet<SecurityType> validValues = EnumSet.allOf(SecurityType.class);
        validValues.remove(SecurityType.Unknown);
        for (String invalidSecType : Arrays.asList("InvalidSecurityType", SecurityType.Unknown.toString())) {
            FieldProcessorTest.verifyParseFailure((FieldProcessor)proc, (I18NBoundMessage)new I18NBoundMessage2P(Messages.INVALID_SECURITY_TYPE, (Serializable)((Object)invalidSecType), (Serializable)((Object)((Object)validValues).toString())), "java", invalidSecType, "whatever");
        }
    }

    @Test
    public void optionInstrument() throws Exception {
        InstrumentProcessor proc = new InstrumentProcessor();
        Assert.assertTrue((boolean)proc.canProcess("Symbol", 0));
        Assert.assertTrue((boolean)proc.canProcess("SecurityType", 1));
        Assert.assertTrue((boolean)proc.canProcess("Expiry", 2));
        Assert.assertTrue((boolean)proc.canProcess("OptionType", 3));
        Assert.assertTrue((boolean)proc.canProcess("StrikePrice", 4));
        Assert.assertFalse((boolean)proc.canProcess("Account", 4));
        String symbol = "java";
        Assert.assertEquals((Object)new Equity("java"), (Object)FieldProcessorTest.apply((FieldProcessor)proc, "java", "", "kava", "lava", "mava").getInstrument());
        Assert.assertEquals((Object)new Equity("java"), (Object)FieldProcessorTest.apply((FieldProcessor)proc, "java", SecurityType.CommonStock.toString(), "kava", "lava", "mava").getInstrument());
        String expiry = "20101010";
        BigDecimal strikePrice = BigDecimal.TEN;
        OptionType type = OptionType.Call;
        Assert.assertEquals((Object)new Option("java", "20101010", strikePrice, type), (Object)FieldProcessorTest.apply((FieldProcessor)proc, "java", SecurityType.Option.toString(), "20101010", type.toString(), strikePrice.toPlainString()).getInstrument());
        Assert.assertEquals((Object)new Equity("java"), (Object)FieldProcessorTest.apply((FieldProcessor)proc, "java", SecurityType.CommonStock.toString(), "20101010", type.toString(), strikePrice.toPlainString()).getInstrument());
        FieldProcessorTest.verifyOptionMissingFieldFailure(proc, "Symbol", null, SecurityType.Option.toString(), "20101010", type.toString(), strikePrice.toPlainString());
        FieldProcessorTest.verifyOptionMissingFieldFailure(proc, "Symbol", "", SecurityType.Option.toString(), "20101010", type.toString(), strikePrice.toPlainString());
        FieldProcessorTest.verifyOptionMissingFieldFailure(proc, "Symbol", "  ", SecurityType.Option.toString(), "20101010", type.toString(), strikePrice.toPlainString());
        FieldProcessorTest.verifyOptionMissingFieldFailure(proc, "Expiry", "java", SecurityType.Option.toString(), null, type.toString(), strikePrice.toPlainString());
        FieldProcessorTest.verifyOptionMissingFieldFailure(proc, "Expiry", "java", SecurityType.Option.toString(), "", type.toString(), strikePrice.toPlainString());
        FieldProcessorTest.verifyOptionMissingFieldFailure(proc, "Expiry", "java", SecurityType.Option.toString(), "  ", type.toString(), strikePrice.toPlainString());
        FieldProcessorTest.verifyOptionMissingFieldFailure(proc, "OptionType", "java", SecurityType.Option.toString(), "20101010", null, strikePrice.toPlainString());
        FieldProcessorTest.verifyOptionMissingFieldFailure(proc, "OptionType", "java", SecurityType.Option.toString(), "20101010", "", strikePrice.toPlainString());
        FieldProcessorTest.verifyOptionMissingFieldFailure(proc, "StrikePrice", "java", SecurityType.Option.toString(), "20101010", type.toString(), null);
        FieldProcessorTest.verifyOptionMissingFieldFailure(proc, "StrikePrice", "java", SecurityType.Option.toString(), "20101010", type.toString(), "");
        EnumSet<OptionType> validValues = EnumSet.allOf(OptionType.class);
        validValues.remove(OptionType.Unknown);
        for (String opType : Arrays.asList("invalid", OptionType.Unknown.toString())) {
            FieldProcessorTest.verifyParseFailure((FieldProcessor)proc, (I18NBoundMessage)new I18NBoundMessage2P(Messages.INVALID_OPTION_TYPE, (Serializable)((Object)opType), (Serializable)((Object)validValues.toString())), "java", SecurityType.Option.toString(), "20101010", opType, strikePrice.toPlainString());
        }
        String invalidStrike = "not big D";
        FieldProcessorTest.verifyParseFailure((FieldProcessor)proc, (I18NBoundMessage)new I18NBoundMessage1P(Messages.INVALID_STRIKE_PRICE_VALUE, (Serializable)((Object)invalidStrike)), "java", SecurityType.Option.toString(), "20101010", type.toString(), invalidStrike);
        proc = new InstrumentProcessor();
        Assert.assertTrue((boolean)proc.canProcess("Symbol", 0));
        Assert.assertTrue((boolean)proc.canProcess("SecurityType", 1));
        FieldProcessorTest.verifyOptionMissingFieldFailure(proc, "Expiry", "java", SecurityType.Option.toString(), "20101010", type.toString(), strikePrice.toPlainString());
        Assert.assertTrue((boolean)proc.canProcess("Expiry", 2));
        FieldProcessorTest.verifyOptionMissingFieldFailure(proc, "OptionType", "java", SecurityType.Option.toString(), "20101010", type.toString(), strikePrice.toPlainString());
        Assert.assertTrue((boolean)proc.canProcess("OptionType", 3));
        FieldProcessorTest.verifyOptionMissingFieldFailure(proc, "StrikePrice", "java", SecurityType.Option.toString(), "20101010", type.toString(), strikePrice.toPlainString());
    }

    @Test
    public void timeInForce() throws Exception {
        final TimeInForceProcessor proc = new TimeInForceProcessor(2);
        Assert.assertEquals(null, (Object)FieldProcessorTest.apply((FieldProcessor)proc, "blue", "green", "", "red").getTimeInForce());
        Assert.assertEquals((Object)TimeInForce.FillOrKill, (Object)FieldProcessorTest.apply((FieldProcessor)proc, "blue", "green", TimeInForce.FillOrKill.toString(), "red").getTimeInForce());
        EnumSet<TimeInForce> validValues = EnumSet.allOf(TimeInForce.class);
        validValues.remove(TimeInForce.Unknown);
        new ExpectedFailure<OrderParsingException>((I18NMessage)Messages.INVALID_TIME_IN_FORCE, new Object[]{"blues", ((Object)validValues).toString()}){

            protected void run() throws Exception {
                FieldProcessorTest.apply((FieldProcessor)proc, new String[]{"red", "greed", "blues", "clues"});
            }
        };
        new ExpectedFailure<OrderParsingException>((I18NMessage)Messages.INVALID_TIME_IN_FORCE, new Object[]{TimeInForce.Unknown.toString(), ((Object)validValues).toString()}){

            protected void run() throws Exception {
                FieldProcessorTest.apply((FieldProcessor)proc, new String[]{"red", "greed", TimeInForce.Unknown.toString(), "clues"});
            }
        };
    }

    private static void verifyOptionMissingFieldFailure(InstrumentProcessor inProc, String inFieldName, String ... inRow) throws Exception {
        FieldProcessorTest.verifyParseFailure((FieldProcessor)inProc, (I18NBoundMessage)new I18NBoundMessage1P(Messages.MISSING_OPTION_FIELD, (Serializable)((Object)inFieldName)), inRow);
    }

    private static void verifyParseFailure(final FieldProcessor inProc, I18NBoundMessage inMessage, final String ... inRow) throws Exception {
        new ExpectedFailure<OrderParsingException>(inMessage){

            protected void run() throws Exception {
                FieldProcessorTest.apply(inProc, inRow);
            }
        };
    }

    private static OrderSingle apply(FieldProcessor inProcessor, String ... inRow) throws OrderParsingException {
        OrderSingle inOrder = FieldProcessorTest.createOrder();
        inProcessor.apply(inRow, inOrder);
        return inOrder;
    }

    private static OrderSingle createOrder() {
        return Factory.getInstance().createOrderSingle();
    }
}

