/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.orderloader.system;

import java.io.Serializable;
import java.math.BigDecimal;
import org.marketcetera.orderloader.Messages;
import org.marketcetera.orderloader.OrderParsingException;
import org.marketcetera.orderloader.system.BigDecimalProcessor;
import org.marketcetera.orderloader.system.InstrumentFromRow;
import org.marketcetera.orderloader.system.OptionTypeProcessor;
import org.marketcetera.orderloader.system.Row;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.Option;
import org.marketcetera.trade.OptionType;
import org.marketcetera.trade.OrderSingle;
import org.marketcetera.trade.SecurityType;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: OptionFromRow.java 16154 2012-07-14 16:34:05Z colin $")
public class OptionFromRow
extends InstrumentFromRow {
    public static final String FIELD_EXPIRY = "Expiry";
    public static final String FIELD_STRIKE_PRICE = "StrikePrice";
    public static final String FIELD_OPTION_TYPE = "OptionType";
    private OptionTypeProcessor mOpTypeProcessor = null;
    private BigDecimalProcessor mStrikeProcessor = null;
    private int mExpiryIndex = -1;

    @Override
    protected boolean canProcess(String inHeader, int inIndex) {
        boolean isHandled = false;
        if (FIELD_EXPIRY.equals(inHeader)) {
            this.mExpiryIndex = inIndex;
            isHandled = true;
        } else if (FIELD_OPTION_TYPE.equals(inHeader)) {
            this.mOpTypeProcessor = new OptionTypeProcessor(inIndex);
            isHandled = true;
        } else if (FIELD_STRIKE_PRICE.equals(inHeader)) {
            this.mStrikeProcessor = new BigDecimalProcessor(Messages.INVALID_STRIKE_PRICE_VALUE, inIndex){

                @Override
                public void apply(String[] inRow, OrderSingle inOrder) throws OrderParsingException {
                }
            };
            isHandled = true;
        }
        return isHandled;
    }

    protected boolean isHandled(Row inValue) {
        SecurityType secType = null;
        try {
            secType = this.getSecurityType(inValue.getRow());
        }
        catch (OrderParsingException orderParsingException) {
            // empty catch block
        }
        return secType != null && SecurityType.Option.equals((Object)secType);
    }

    @Override
    protected Instrument extract(Row inRow) throws OrderParsingException {
        String[] row = inRow.getRow();
        String symbol = this.getSymbol(row);
        OptionFromRow.checkEmptyField("Symbol", symbol == null || symbol.trim().isEmpty());
        String expiry = this.mExpiryIndex >= 0 ? row[this.mExpiryIndex] : null;
        OptionFromRow.checkEmptyField(FIELD_EXPIRY, expiry == null || expiry.trim().isEmpty());
        OptionType opType = this.mOpTypeProcessor == null ? null : (OptionType)this.mOpTypeProcessor.getEnumValue(row);
        OptionFromRow.checkEmptyField(FIELD_OPTION_TYPE, opType == null);
        BigDecimal strikePrice = this.mStrikeProcessor == null ? null : this.mStrikeProcessor.getDecimalValue(row);
        OptionFromRow.checkEmptyField(FIELD_STRIKE_PRICE, strikePrice == null);
        return new Option(symbol, expiry, strikePrice, opType);
    }

    private static void checkEmptyField(String inFieldHeader, boolean inCheckFailed) throws OrderParsingException {
        if (inCheckFailed) {
            throw new OrderParsingException((I18NBoundMessage)new I18NBoundMessage1P(Messages.MISSING_OPTION_FIELD, (Serializable)((Object)inFieldHeader)));
        }
    }
}

