/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.orderloader.system;

import org.marketcetera.core.instruments.DynamicInstrumentFunctionSelector;
import org.marketcetera.orderloader.OrderParsingException;
import org.marketcetera.orderloader.system.FieldProcessor;
import org.marketcetera.orderloader.system.InstrumentFromRow;
import org.marketcetera.orderloader.system.Row;
import org.marketcetera.trade.OrderSingle;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: InstrumentProcessor.java 16154 2012-07-14 16:34:05Z colin $")
final class InstrumentProcessor
implements FieldProcessor {
    private final DynamicInstrumentFunctionSelector<Row, InstrumentFromRow> mSelector = new DynamicInstrumentFunctionSelector(InstrumentFromRow.class);

    InstrumentProcessor() {
    }

    @Override
    public void apply(String[] inRow, OrderSingle inOrder) throws OrderParsingException {
        Row value = new Row(inRow);
        inOrder.setInstrument(((InstrumentFromRow)this.mSelector.forValue((Object)value)).extract(value));
    }

    boolean canProcess(String inHeader, int inIndex) {
        boolean isHandled = false;
        for (InstrumentFromRow handler : this.mSelector.getHandlers()) {
            if (!handler.processHeader(inHeader, inIndex)) continue;
            isHandled = true;
        }
        return isHandled;
    }
}

