/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.orderloader.fix;

import java.io.Serializable;
import java.math.BigDecimal;
import org.marketcetera.orderloader.Messages;
import org.marketcetera.orderloader.OrderParsingException;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.misc.ClassVersion;
import quickfix.Field;

@ClassVersion(value="$Id: CustomField.java 16154 2012-07-14 16:34:05Z colin $")
public class CustomField<T>
extends Field<T> {
    private static final long serialVersionUID = 7712839170687733751L;

    public CustomField(int i, T inObject) {
        super(i, inObject);
    }

    public Object parseMessageValue(String inValue) {
        try {
            return Integer.valueOf(inValue);
        }
        catch (NumberFormatException ex) {
            try {
                return new BigDecimal(inValue);
            }
            catch (NumberFormatException ex2) {
                return inValue;
            }
        }
    }

    public String toString() {
        return String.format("%d", this.getTag());
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.getTag();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        CustomField other = (CustomField)((Object)obj);
        return this.getTag() == other.getTag();
    }

    public static CustomField<?> getCustomField(String inName) throws OrderParsingException {
        try {
            int fieldKey = Integer.parseInt(inName);
            return new CustomField<Object>(fieldKey, null);
        }
        catch (NumberFormatException nex) {
            throw new OrderParsingException((I18NBoundMessage)new I18NBoundMessage1P(Messages.ERROR_PARSING_NUMBER_FORMAT, (Serializable)((Object)inName)));
        }
    }
}

