/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.orderloader;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVStrategy;
import org.marketcetera.orderloader.Messages;
import org.marketcetera.orderloader.OrderParsingException;
import org.marketcetera.orderloader.RowProcessor;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.unicode.DecodingStrategy;
import org.marketcetera.util.unicode.UnicodeInputStreamReader;

@ClassVersion(value="$Id: OrderParser.java 16154 2012-07-14 16:34:05Z colin $")
public class OrderParser {
    public static final String COMMENT_MARKER = "#";
    private int mNumLines = 0;
    private int mNumBlankLines = 0;
    private int mNumComments = 0;
    private final RowProcessor mProcessor;

    public OrderParser(RowProcessor inProcessor) {
        if (inProcessor == null) {
            throw new NullPointerException();
        }
        this.mProcessor = inProcessor;
    }

    public int getNumLines() {
        return this.mNumLines;
    }

    public int getNumBlankLines() {
        return this.mNumBlankLines;
    }

    public int getNumComments() {
        return this.mNumComments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseOrders(InputStream inStream) throws IOException, OrderParsingException {
        UnicodeInputStreamReader reader = null;
        try {
            reader = new UnicodeInputStreamReader(inStream, DecodingStrategy.SIG_REQ);
            String[][] rows = new CSVParser((Reader)reader, CSVStrategy.EXCEL_STRATEGY).getAllValues();
            boolean isProcessorInit = false;
            if (rows != null) {
                for (String[] row : rows) {
                    ++this.mNumLines;
                    if (row.length == 0 || row.length == 1 && row[0].trim().isEmpty()) {
                        ++this.mNumBlankLines;
                        continue;
                    }
                    if (row[0].startsWith(COMMENT_MARKER)) {
                        ++this.mNumComments;
                        continue;
                    }
                    if (isProcessorInit) {
                        this.getProcessor().processOrder(this.mNumLines, row);
                        continue;
                    }
                    this.getProcessor().initialize(row);
                    isProcessorInit = true;
                }
            }
            if (this.getProcessor().getTotal() < 1) {
                throw new OrderParsingException((I18NBoundMessage)Messages.ERROR_NO_ORDERS);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    RowProcessor getProcessor() {
        return this.mProcessor;
    }
}

