/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.orderloader;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.marketcetera.client.ClientParameters;
import org.marketcetera.core.LoggerConfiguration;
import org.marketcetera.orderloader.Messages;
import org.marketcetera.orderloader.MockOrderProcessor;
import org.marketcetera.orderloader.OrderLoader;
import org.marketcetera.orderloader.OrderLoaderMain;
import org.marketcetera.orderloader.OrderLoaderTest;
import org.marketcetera.orderloader.OrderParserTest;
import org.marketcetera.orderloader.OrderProcessor;
import org.marketcetera.util.file.CopyCharsUtils;

public class MainTest {
    private static final String TEST_FAILURE = "TEST FAILURE";
    public ByteArrayOutputStream mOutput;

    @BeforeClass
    public static void setupLogger() throws Exception {
        LoggerConfiguration.logSetup();
    }

    @Test
    public void inputFileMissing() throws Exception {
        MockMain main = this.run(new String[0]);
        main.assertUsage();
        String output = this.mOutput.toString();
        Assert.assertTrue((String)output, (boolean)output.contains(Messages.ERROR_MISSING_FILE.getText()));
    }

    @Test
    public void tooManyArgs() throws Exception {
        MockMain main = this.run("file", "extra");
        main.assertUsage();
        String output = this.mOutput.toString();
        Assert.assertTrue((String)output, (boolean)output.contains(Messages.ERROR_TOO_MANY_ARGUMENTS.getText()));
    }

    @Test
    public void incorrectModeSyntax() throws Exception {
        MockMain main = this.run("-m");
        main.assertUsage();
        String output = this.mOutput.toString();
        Assert.assertTrue((String)output, (boolean)output.contains("option: m"));
    }

    @Test
    public void incorrectBrokerSyntax() throws Exception {
        MockMain main = this.run("-b");
        main.assertUsage();
        String output = this.mOutput.toString();
        Assert.assertTrue((String)output, (boolean)output.contains("option: b"));
    }

    @Test
    public void incorrectUsernameSyntax() throws Exception {
        MockMain main = this.run("-u");
        main.assertUsage();
        String output = this.mOutput.toString();
        Assert.assertTrue((String)output, (boolean)output.contains("option: u"));
    }

    @Test
    public void incorrectPasswordSyntax() throws Exception {
        MockMain main = this.run("-p");
        main.assertUsage();
        String output = this.mOutput.toString();
        Assert.assertTrue((String)output, (boolean)output.contains("option: p"));
    }

    @Test
    public void systemOrder() throws Exception {
        File tmpFile = File.createTempFile("orders", ".csv");
        tmpFile.deleteOnExit();
        CopyCharsUtils.copy((char[])OrderParserTest.arrayToLines(OrderLoaderTest.SYSTEM_ORDER_EXAMPLE).toCharArray(), (String)tmpFile.getAbsolutePath());
        MockMain main = this.run(tmpFile.getAbsolutePath());
        ClientParameters parameters = main.getClientParameters();
        Assert.assertEquals((Object)"127.0.0.1", (Object)parameters.getHostname());
        Assert.assertNull((Object)parameters.getIDPrefix());
        Assert.assertArrayEquals((char[])"admin".toCharArray(), (char[])parameters.getPassword());
        Assert.assertEquals((long)9000L, (long)parameters.getPort());
        Assert.assertEquals((Object)"tcp://localhost:61616", (Object)parameters.getURL());
        Assert.assertEquals((Object)"admin", (Object)parameters.getUsername());
        Assert.assertTrue((boolean)main.getOrderProcessor().isDoneInvoked());
        String output = this.mOutput.toString();
        Assert.assertTrue((String)output, (boolean)output.contains(Messages.LINE_SUMMARY.getText((Object)28, (Object)6, (Object)6)));
        Assert.assertTrue((String)output, (boolean)output.contains(Messages.ORDER_SUMMARY.getText((Object)5, (Object)10)));
        Assert.assertTrue((String)output, (boolean)output.contains(Messages.LOG_APP_COPYRIGHT.getText()));
        tmpFile.delete();
    }

    @Test
    public void invalidHeader() throws Exception {
        File tmpFile = File.createTempFile("orders", ".csv");
        tmpFile.deleteOnExit();
        CopyCharsUtils.copy((char[])OrderParserTest.arrayToLines("Side,Symbol,Price,OrderType,What?").toCharArray(), (String)tmpFile.getAbsolutePath());
        this.run(tmpFile.getAbsolutePath());
        String output = this.mOutput.toString();
        Assert.assertTrue((String)output, (boolean)output.contains(Messages.INVALID_CUSTOM_HEADER.getText((Object)"What?", (Object)4)));
    }

    @Test
    public void failConnectServer() throws Exception {
        MockMain main = this.create("don'tmatter");
        main.setFailCreateProcessor(true);
        main.start();
        String output = this.mOutput.toString();
        Assert.assertTrue((String)output, (boolean)output.contains(TEST_FAILURE));
    }

    private MockMain run(String ... inArgs) {
        MockMain main = this.create(inArgs);
        main.start();
        return main;
    }

    private MockMain create(String ... inArgs) {
        MockMain main = new MockMain(inArgs);
        main.setClientWsHost("127.0.0.1");
        main.setClientWsPort("9000");
        main.setClientURL("tcp://localhost:61616");
        main.setClientUsername("admin");
        main.setClientPassword("admin".toCharArray());
        this.mOutput = new ByteArrayOutputStream();
        main.setMsgStream(new PrintStream(this.mOutput));
        return main;
    }

    public class MockMain
    extends OrderLoaderMain {
        private boolean mFailCreateProcessor = false;
        private ClientParameters mClientParameters;
        public MockOrderProcessor mOrderProcessor;
        private OrderLoader loader;
        private String[] args;

        public MockMain(String ... inArgs) {
            this.args = inArgs;
        }

        protected String[] getArgs() {
            return this.args;
        }

        protected OrderProcessor createProcessor(ClientParameters inParameters) throws Exception {
            if (this.mFailCreateProcessor) {
                throw new IllegalArgumentException(MainTest.TEST_FAILURE);
            }
            this.mClientParameters = inParameters;
            this.mOrderProcessor = new MockOrderProcessor();
            return this.mOrderProcessor;
        }

        public ClientParameters getClientParameters() {
            return this.mClientParameters;
        }

        protected void displaySummary(OrderLoader inLoader) {
            super.displaySummary(inLoader);
            this.loader = inLoader;
        }

        public void setFailCreateProcessor(boolean inFailCreateProcessor) {
            this.mFailCreateProcessor = inFailCreateProcessor;
        }

        public MockOrderProcessor getOrderProcessor() {
            return this.mOrderProcessor;
        }

        public OrderLoader getLoader() {
            return this.loader;
        }

        public void setLoader(OrderLoader inLoader) {
            this.loader = inLoader;
        }

        public void assertNoErrors() {
            Assert.assertNotNull((Object)this.loader);
            Assert.assertTrue((boolean)this.loader.getFailedOrders().isEmpty());
            Assert.assertEquals((long)0L, (long)this.loader.getNumFailed());
        }

        public void assertErrors() {
            Assert.assertNotNull((Object)this.loader);
            Assert.assertFalse((boolean)this.loader.getFailedOrders().isEmpty());
            Assert.assertTrue((this.loader.getNumFailed() > 0 ? 1 : 0) != 0);
        }

        public void assertUsage() {
            String output = new String(MainTest.this.mOutput.toByteArray());
            Assert.assertTrue((String)output, (boolean)output.contains("Usage"));
            Assert.assertNull((Object)this.loader);
            Assert.assertTrue((String)output, (boolean)output.contains(Messages.LOG_APP_COPYRIGHT.getText()));
        }
    }
}

