/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.orderloader.system;

import java.io.Serializable;
import java.util.EnumSet;
import java.util.Set;
import org.marketcetera.orderloader.OrderParsingException;
import org.marketcetera.orderloader.system.IndexedProcessor;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage2P;
import org.marketcetera.util.log.I18NMessage2P;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: EnumProcessor.java 16154 2012-07-14 16:34:05Z colin $")
abstract class EnumProcessor<T extends Enum<T>>
extends IndexedProcessor {
    private final Set<T> mValidValues;
    private final I18NMessage2P mErrorMessage;
    private final Class<T> mClass;

    protected EnumProcessor(Class<T> inClass, T inDisallowedValue, I18NMessage2P inErrorMessage, int inIndex) {
        super(inIndex);
        this.mClass = inClass;
        this.mErrorMessage = inErrorMessage;
        this.mValidValues = EnumSet.allOf(inClass);
        this.mValidValues.remove(inDisallowedValue);
    }

    protected T getEnumValue(String[] inRow) throws OrderParsingException {
        String value = this.getValue(inRow);
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            T t = Enum.valueOf(this.mClass, this.getValue(inRow));
            if (!this.mValidValues.contains(t)) {
                throw new OrderParsingException((I18NBoundMessage)new I18NBoundMessage2P(this.mErrorMessage, (Serializable)((Object)value), (Serializable)((Object)this.mValidValues.toString())));
            }
            return t;
        }
        catch (IllegalArgumentException e) {
            throw new OrderParsingException(e, (I18NBoundMessage)new I18NBoundMessage2P(this.mErrorMessage, (Serializable)((Object)value), (Serializable)((Object)this.mValidValues.toString())));
        }
    }
}

