/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.orderloader.fix;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.marketcetera.core.ExpectedTestFailure;
import org.marketcetera.core.LoggerConfiguration;
import org.marketcetera.orderloader.FailedOrderInfo;
import org.marketcetera.orderloader.Messages;
import org.marketcetera.orderloader.MockOrderProcessor;
import org.marketcetera.orderloader.OrderParser;
import org.marketcetera.orderloader.OrderParsingException;
import org.marketcetera.orderloader.OrderProcessor;
import org.marketcetera.orderloader.RowProcessor;
import org.marketcetera.orderloader.fix.CustomField;
import org.marketcetera.orderloader.fix.FIXProcessor;
import org.marketcetera.quickfix.FIXVersion;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.FIXOrder;
import org.marketcetera.trade.Order;
import org.marketcetera.util.unicode.SignatureCharset;
import quickfix.Field;
import quickfix.Message;
import quickfix.field.Account;
import quickfix.field.OrderQty;
import quickfix.field.Price;
import quickfix.field.Side;
import quickfix.field.Symbol;
import quickfix.field.TimeInForce;

public class FIXProcessorTest {
    private final MockOrderProcessor mProcessor = new MockOrderProcessor();
    public static final String ORDER_EXAMPLE = "Symbol,Side,OrderQty,Price,TimeInForce,Account\nIBM,B,100,12.1,DAY,123-ASDF-234\nIBM,SS,100,12.22,DAY,123-ASDF-234\nEFA,SSE,100,MKT,DAY,9182379812\nEFA,SSE,100,MKT,FILL_OR_KILL,9182379812\n---,SSE,100,MKT,DAY,9182379812\nEFA,---,100,MKT,DAY,9182379812\nEFA,SSE,---,MKT,DAY,9182379812\n\nEFA,SSE,100,---,DAY,9182379812\nEFA,SSE,100,MKT,---,9182379812\nEFA,SSE,100,MKT,---,---\nEFA,SSE,100,MKT,DAY,---\nEFA,SSE,100.1,MKT,DAY,9182379812\nIBM,SS,100,-12.22,DAY,123-ASDF-234\nIBM,SS,-100,12.22,DAY,123-ASDF-234\n//do nothing\n\nIBM,SS,100,12.22,DAY,123-ASDF-234\nIBM,S,100,12.22,DAY,123-ASDF-234\n";
    private static final BrokerID BROKER_ID = new BrokerID("Yes");

    @BeforeClass
    public static void setupLogger() {
        LoggerConfiguration.logSetup();
    }

    @Test
    public void getSide() {
        Assert.assertEquals((long)55L, (long)FIXProcessor.getSide(null));
        Assert.assertEquals((long)55L, (long)FIXProcessor.getSide((String)""));
        Assert.assertEquals((long)55L, (long)FIXProcessor.getSide((String)"asdf"));
        Assert.assertEquals((long)49L, (long)FIXProcessor.getSide((String)"b"));
        Assert.assertEquals((long)49L, (long)FIXProcessor.getSide((String)"B"));
        Assert.assertEquals((long)50L, (long)FIXProcessor.getSide((String)"S"));
        Assert.assertEquals((long)50L, (long)FIXProcessor.getSide((String)"s"));
        Assert.assertEquals((long)53L, (long)FIXProcessor.getSide((String)"SS"));
        Assert.assertEquals((long)53L, (long)FIXProcessor.getSide((String)"ss"));
        Assert.assertEquals((long)54L, (long)FIXProcessor.getSide((String)"SSE"));
        Assert.assertEquals((long)54L, (long)FIXProcessor.getSide((String)"sse"));
    }

    @Test
    public void addDefaults() throws Exception {
        Message msg = new Message();
        FIXProcessor.addDefaults((Message)msg);
        Assert.assertEquals((String)"msgType", (Object)"D", (Object)msg.getHeader().getString(35));
        Assert.assertEquals((String)"orderType", (long)50L, (long)msg.getChar(40));
        Assert.assertEquals((String)"handlInst", (long)49L, (long)msg.getChar(21));
    }

    @Test
    public void basicFieldParsing() throws Exception {
        Message msg = new Message();
        FIXProcessor proc = this.create();
        Assert.assertEquals((Object)"7", (Object)proc.parseMessageValue((Field)new Side(), "side", "z", msg));
        Assert.assertEquals((Object)"1", (Object)proc.parseMessageValue((Field)new Side(), "side", "B", msg));
        Assert.assertEquals((Object)"2", (Object)proc.parseMessageValue((Field)new Side(), "side", "S", msg));
    }

    @Test
    public void priceParsing() throws Exception {
        final Message msg = new Message();
        final FIXProcessor proc = this.create();
        Assert.assertEquals(null, (Object)proc.parseMessageValue((Field)new Price(), "Price", "MKT", msg));
        Assert.assertEquals((long)49L, (long)msg.getChar(40));
        Assert.assertEquals((Object)"42", (Object)proc.parseMessageValue((Field)new Price(), "Price", "42", msg));
        Assert.assertEquals((Object)"42.42", (Object)proc.parseMessageValue((Field)new Price(), "Price", "42.42", msg));
        new ExpectedTestFailure(OrderParsingException.class, Messages.PARSING_PRICE_POSITIVE.getText((Object)"-42")){

            protected void execute() throws Throwable {
                proc.parseMessageValue((Field)new Price(), "price", "-42", msg);
            }
        }.run();
        new ExpectedTestFailure(OrderParsingException.class, Messages.PARSING_PRICE_VALID_NUM.getText((Object)"toli")){

            protected void execute() throws Throwable {
                proc.parseMessageValue((Field)new Price(), "price", "toli", msg);
            }
        }.run();
    }

    @Test
    public void quantityParsing() throws Exception {
        final FIXProcessor proc = this.create();
        final Message msg = new Message();
        Assert.assertEquals((Object)"42", (Object)proc.parseMessageValue((Field)new OrderQty(), "OrderQty", "42", msg));
        new ExpectedTestFailure(OrderParsingException.class, Messages.PARSING_QTY_POS_INT.getText((Object)"-42")){

            protected void execute() throws Throwable {
                proc.parseMessageValue((Field)new OrderQty(), "OrderQty", "-42", msg);
            }
        }.run();
        new ExpectedTestFailure(OrderParsingException.class, Messages.PARSING_QTY_INT.getText((Object)"toli")){

            protected void execute() throws Throwable {
                proc.parseMessageValue((Field)new OrderQty(), "OrderQty", "toli", msg);
            }
        }.run();
        new ExpectedTestFailure(OrderParsingException.class, Messages.PARSING_QTY_INT.getText((Object)"42.2")){

            protected void execute() throws Throwable {
                proc.parseMessageValue((Field)new OrderQty(), "OrderQty", "42.2", msg);
            }
        }.run();
    }

    @Test
    public void getQuickfixFieldFromName() throws Exception {
        final FIXProcessor proc = this.create();
        Assert.assertEquals((Object)new Side(), (Object)proc.getQuickFixFieldFromName("Side"));
        Assert.assertEquals((Object)new OrderQty(), (Object)proc.getQuickFixFieldFromName("OrderQty"));
        Assert.assertEquals((Object)new CustomField(1234, null), (Object)proc.getQuickFixFieldFromName("1234"));
        new ExpectedTestFailure(OrderParsingException.class, "ToliField"){

            protected void execute() throws Throwable {
                proc.getQuickFixFieldFromName("ToliField");
            }
        }.run();
    }

    @Test
    public void getFieldOrder() throws Exception {
        this.doVerifyFieldOrder(new Field[]{new Symbol(), new Side(), new OrderQty(), new Price(), new TimeInForce(), new Account()}, new String[]{"Symbol", "Side", "OrderQty", "Price", "TimeInForce", "Account"});
        this.doVerifyFieldOrder(new Field[]{new OrderQty(), new Price(), new TimeInForce(), new Symbol(), new Side(), new Account()}, new String[]{"OrderQty", "Price", "TimeInForce", "Symbol", "Side", "Account"});
        this.doVerifyFieldOrder(new Field[]{new OrderQty(), new Price(), new TimeInForce(), new Symbol(), new Side(), new CustomField(1234, null)}, new String[]{"OrderQty", "Price", "TimeInForce", "Symbol", "Side", "1234"});
        this.doVerifyFieldOrder(new Field[]{new OrderQty(), new CustomField(1234, null), new Symbol(), new Side()}, new String[]{"OrderQty", "1234", "Symbol", "Side"});
        new ExpectedTestFailure(OrderParsingException.class, "ToliField"){

            protected void execute() throws Throwable {
                FIXProcessorTest.this.doVerifyFieldOrder(new Field[]{new Symbol(), new Side(), new OrderQty(), new Price(), new TimeInForce(), new Account()}, new String[]{"Symbol", "Side", "ToliField", "Price", "TimeInForce", "Account"});
            }
        }.run();
    }

    private void doVerifyFieldOrder(Field<?>[] inFields, String[] inHeaders) throws Exception {
        FIXProcessor proc = this.create();
        proc.initialize(inHeaders);
        Assert.assertEquals(new Vector(Arrays.asList(inFields)), (Object)proc.getHeaderFields());
        Assert.assertArrayEquals((Object[])inHeaders, (Object[])proc.getHeaderNames());
    }

    @Test
    public void endToEndNativeEncoding() throws Exception {
        this.verifyOrderExampleProcessing(new ByteArrayInputStream(ORDER_EXAMPLE.getBytes()));
    }

    @Test
    public void endToEndUTF8Encoding() throws Exception {
        this.verifyOrderExampleProcessing(new ByteArrayInputStream(SignatureCharset.UTF8_UTF8.encode(ORDER_EXAMPLE)));
    }

    @Test
    public void endToEndUTF32Encoding() throws Exception {
        this.verifyOrderExampleProcessing(new ByteArrayInputStream(SignatureCharset.UTF32BE_UTF32BE.encode(ORDER_EXAMPLE)));
    }

    private void verifyOrderExampleProcessing(InputStream inStream) throws Exception {
        this.verifyOrderParsing(inStream, 2, 0, 9, 8);
    }

    @Test
    public void commentedLines() throws Exception {
        String order = "#Opening comment\nSymbol,Side,OrderQty,Price,TimeInForce,Account\n#IBM,B,100,12.1,DAY,123-ASDF-234\nIBM,SS,100,12.22,DAY,123-ASDF-234\nEFA,SSE,100,MKT,DAY,9182379812\n#EFA,SSE,100,MKT,FILL_OR_KILL,9182379812\n";
        this.verifyOrderParsing(new ByteArrayInputStream(order.getBytes()), 0, 3, 2, 0);
    }

    @Test
    public void wrongNumberOfFields() throws Exception {
        String order = "Symbol,Side,OrderQty,Price,TimeInForce,Account\nIBM,B,100,12.1,DAY,123-ASDF-234\nIBM,SS,100,123-ASDF-234\n";
        this.verifyOrderParsing(new ByteArrayInputStream(order.getBytes()), 0, 0, 1, 1);
    }

    @Test
    public void endToEndCustom() throws Exception {
        String order = "Symbol,Side,OrderQty,Price,58,Account\nIBM,B,100,12.1,DAY,123-ASDF-234\nIBM,S,100,12.22,12,123-ASDF-234\nIBM,S,100,12.22,12.45,123-ASDF-234\n";
        this.verifyOrderParsing(new ByteArrayInputStream(order.getBytes()), 0, 0, 3, 0);
    }

    @Test
    public void validMessage() throws Exception {
        FIXProcessor processor = this.create();
        String[] headerNames = new String[]{"Symbol", "Side", "OrderQty", "Price", "TimeInForce", "Account"};
        processor.initialize(headerNames);
        Message message = this.parseOrder((RowProcessor)processor, true, "IBM", "SS", "100", "12.22", "DAY", "123-ASDF-234");
        Assert.assertEquals((Object)"IBM", (Object)message.getString(55));
        Assert.assertEquals((long)53L, (long)message.getChar(54));
        Assert.assertEquals((Object)"100", (Object)message.getString(38));
        Assert.assertEquals((Object)"12.22", (Object)message.getString(44));
        Assert.assertEquals((long)48L, (long)message.getChar(59));
        Assert.assertEquals((Object)"123-ASDF-234", (Object)message.getString(1));
    }

    private Message parseOrder(RowProcessor processor, boolean inVerify, String ... inRow) {
        processor.processOrder(1, inRow);
        if (inVerify) {
            Assert.assertEquals((long)1L, (long)processor.getNumSuccess());
            Assert.assertEquals((long)0L, (long)processor.getNumFailed());
            Assert.assertEquals((long)0L, (long)processor.getFailedOrders().size());
            return this.verifySingleOrder();
        }
        return null;
    }

    private Message verifySingleOrder() {
        List<Order> orders = this.mProcessor.getOrders();
        Assert.assertEquals((long)1L, (long)orders.size());
        FIXOrder order = (FIXOrder)orders.get(0);
        Assert.assertEquals((Object)BROKER_ID, (Object)order.getBrokerID());
        Assert.assertNull((Object)order.getSecurityType());
        return order.getMessage();
    }

    @Test
    public void nonAscii() throws Exception {
        String[] headerNames = new String[]{"Symbol", "Side", "OrderQty", "Price", "HandlInst", "Account"};
        FIXProcessor processor = this.create();
        processor.initialize(headerNames);
        String symbol = "some string";
        Message message = this.parseOrder((RowProcessor)processor, true, symbol, "SS", "100", "12.22", "3", "123-ASDF-234");
        Assert.assertEquals((Object)symbol, (Object)message.getString(55));
        Assert.assertEquals((long)53L, (long)message.getChar(54));
        Assert.assertEquals((Object)"100", (Object)message.getString(38));
        Assert.assertEquals((Object)"12.22", (Object)message.getString(44));
        Assert.assertEquals((Object)"3", (Object)message.getString(21));
        Assert.assertEquals((Object)"123-ASDF-234", (Object)message.getString(1));
        symbol = "some other string";
        processor = this.create();
        processor.initialize(headerNames);
        message = this.parseOrder((RowProcessor)processor, true, symbol, "SS", "100", "12.22", "3", "123-ASDF-234");
        Assert.assertEquals((Object)symbol, (Object)message.getString(55));
        Assert.assertEquals((long)53L, (long)message.getChar(54));
        Assert.assertEquals((Object)"100", (Object)message.getString(38));
        Assert.assertEquals((Object)"12.22", (Object)message.getString(44));
        Assert.assertEquals((Object)"3", (Object)message.getString(21));
        Assert.assertEquals((Object)"123-ASDF-234", (Object)message.getString(1));
    }

    @Test
    public void handlInstField() throws Exception {
        FIXProcessor processor = this.create();
        String[] headerNames = new String[]{"Symbol", "Side", "OrderQty", "Price", "HandlInst", "Account"};
        processor.initialize(headerNames);
        Message message = this.parseOrder((RowProcessor)processor, true, "IBM", "SS", "100", "12.22", "3", "123-ASDF-234");
        Assert.assertFalse((String)"default handlInst is same as what we set so this test is pointless", (boolean)FIXVersion.FIX42.getMessageFactory().newBasicOrder().getString(21).equals("3"));
        Assert.assertEquals((Object)"IBM", (Object)message.getString(55));
        Assert.assertEquals((long)53L, (long)message.getChar(54));
        Assert.assertEquals((Object)"100", (Object)message.getString(38));
        Assert.assertEquals((Object)"12.22", (Object)message.getString(44));
        Assert.assertEquals((Object)"3", (Object)message.getString(21));
        Assert.assertEquals((Object)"123-ASDF-234", (Object)message.getString(1));
    }

    @Test
    public void withCustomField() throws Exception {
        String[] headerNames = new String[]{"Symbol", "Side", "OrderQty", "Price", "9999", "Account"};
        FIXProcessor processor = this.create();
        processor.initialize(headerNames);
        this.parseOrder((RowProcessor)processor, false, "IBM", "SS", "100", "12.22", "customValue", "123-ASDF-234");
        Assert.assertTrue((boolean)this.mProcessor.getOrders().isEmpty());
        Assert.assertEquals((long)1L, (long)processor.getNumFailed());
        Assert.assertEquals((long)1L, (long)processor.getFailedOrders().size());
        processor = this.create();
        processor.initialize(headerNames);
        Message message = this.parseOrder((RowProcessor)processor, true, "IBM", "SS", "100", "12.22", "123", "123-ASDF-234");
        Assert.assertEquals((Object)"IBM", (Object)message.getString(55));
        Assert.assertEquals((long)53L, (long)message.getChar(54));
        Assert.assertEquals((Object)"100", (Object)message.getString(38));
        Assert.assertEquals((Object)"12.22", (Object)message.getString(44));
        Assert.assertEquals((Object)"123", (Object)message.getString(9999));
        Assert.assertEquals((Object)"123-ASDF-234", (Object)message.getString(1));
        processor = this.create();
        processor.initialize(headerNames);
        message = this.parseOrder((RowProcessor)processor, true, "IBM", "SS", "100", "12.22", "12345", "123-ASDF-234");
        Assert.assertEquals((Object)"IBM", (Object)message.getString(55));
        Assert.assertEquals((long)53L, (long)message.getChar(54));
        Assert.assertEquals((Object)"100", (Object)message.getString(38));
        Assert.assertEquals((Object)"12.22", (Object)message.getString(44));
        Assert.assertEquals((Object)"12345", (Object)message.getString(9999));
        Assert.assertEquals((Object)"123-ASDF-234", (Object)message.getString(1));
    }

    @Test
    public void withMixedCustomFields() throws Exception {
        FIXProcessor processor = this.create();
        String[] headerNames = new String[]{"Symbol", "Side", "OrderQty", "Price", "9999", "SenderSubID", "SignatureLength", "Signature"};
        processor.initialize(headerNames);
        Message message = this.parseOrder((RowProcessor)processor, true, "IBM", "SS", "100", "12.22", "1234", "sub1", "sig".length() + "", "sig");
        Assert.assertEquals((Object)"IBM", (Object)message.getString(55));
        Assert.assertEquals((long)53L, (long)message.getChar(54));
        Assert.assertEquals((Object)"100", (Object)message.getString(38));
        Assert.assertEquals((Object)"12.22", (Object)message.getString(44));
        Assert.assertEquals((Object)"1234", (Object)message.getString(9999));
        Assert.assertEquals((Object)"sub1", (Object)message.getHeader().getString(50));
        Assert.assertEquals((long)3L, (long)message.getTrailer().getInt(93));
        Assert.assertEquals((Object)"sig", (Object)message.getTrailer().getString(89));
    }

    @Test
    public void fieldNotInDictionary() throws Exception {
        FIXProcessor processor = this.create();
        String[] headerNames = new String[]{"Symbol", "Side", "OrderQty", "Price", "7654"};
        processor.initialize(headerNames);
        this.parseOrder((RowProcessor)processor, false, "IBM", "SS", "100", "12.22", "1234");
        Assert.assertEquals((long)1L, (long)processor.getNumFailed());
        List infoList = processor.getFailedOrders();
        Assert.assertEquals((long)1L, (long)infoList.size());
        FailedOrderInfo info = (FailedOrderInfo)infoList.get(0);
        Assert.assertTrue((String)info.getException().toString(), (boolean)info.getException().getLocalizedMessage().endsWith(Messages.PARSING_FIELD_NOT_IN_DICT.getText((Object)"7654", (Object)"1234")));
    }

    @Test
    public void marketPrice() throws Exception {
        FIXProcessor processor = this.create();
        String[] headerNames = new String[]{"Symbol", "Side", "OrderQty", "Price", "TimeInForce"};
        processor.initialize(headerNames);
        Message message = this.parseOrder((RowProcessor)processor, true, "IBM", "SS", "100", FIXProcessor.MKT_PRICE, "DAY");
        Assert.assertEquals((Object)"IBM", (Object)message.getString(55));
        Assert.assertEquals((long)53L, (long)message.getChar(54));
        Assert.assertEquals((Object)"100", (Object)message.getString(38));
        Assert.assertEquals((long)49L, (long)message.getChar(40));
        Assert.assertFalse((boolean)message.isSetField(44));
        Assert.assertEquals((long)48L, (long)message.getChar(59));
    }

    private void verifyOrderParsing(InputStream inStream, int inBlanks, int inComments, int inSuccess, int inFailed) throws Exception {
        FIXProcessor processor = this.create();
        OrderParser parser = new OrderParser((RowProcessor)processor);
        parser.parseOrders(inStream);
        Assert.assertEquals((long)inBlanks, (long)parser.getNumBlankLines());
        Assert.assertEquals((long)inComments, (long)parser.getNumComments());
        Assert.assertEquals((long)inSuccess, (long)processor.getNumSuccess());
        Assert.assertEquals((long)inFailed, (long)processor.getNumFailed());
        Assert.assertEquals((long)(inFailed + inSuccess), (long)processor.getTotal());
        Assert.assertEquals((long)inFailed, (long)processor.getFailedOrders().size());
    }

    private FIXProcessor create() throws Exception {
        this.mProcessor.getOrders().clear();
        return new FIXProcessor((OrderProcessor)this.mProcessor, BROKER_ID, FIXVersion.FIX42);
    }
}

