/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.orderloader.fix;

import java.math.BigDecimal;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.marketcetera.core.ClassVersion;
import org.marketcetera.core.ExpectedTestFailure;
import org.marketcetera.orderloader.OrderParsingException;
import org.marketcetera.orderloader.fix.CustomField;

@ClassVersion(value="$Id: CustomFieldTest.java 16841 2014-02-20 19:59:04Z colin $")
public class CustomFieldTest
extends TestCase {
    public CustomFieldTest(String inName) {
        super(inName);
    }

    public static Test suite() {
        return new TestSuite(CustomFieldTest.class);
    }

    public void testParseCustomFieldValue() {
        CustomField cf = new CustomField(1, null);
        CustomFieldTest.assertEquals((Object)42, (Object)cf.parseMessageValue("42"));
        CustomFieldTest.assertEquals(Integer.class, cf.parseMessageValue("42").getClass());
        CustomFieldTest.assertEquals((Object)new BigDecimal("42.24"), (Object)cf.parseMessageValue("42.24"));
        CustomFieldTest.assertEquals(BigDecimal.class, cf.parseMessageValue("42.24").getClass());
        CustomFieldTest.assertEquals((Object)"toli kuznets", (Object)cf.parseMessageValue("toli kuznets"));
    }

    public void testGetCustomField() throws Exception {
        CustomFieldTest.assertEquals((Object)new CustomField(123, null), (Object)CustomField.getCustomField((String)"123"));
        new ExpectedTestFailure(OrderParsingException.class, "not123"){

            protected void execute() throws Throwable {
                CustomField.getCustomField((String)"not123");
            }
        }.run();
    }
}

