/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.orderloader;

import java.io.File;
import java.util.EnumSet;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.marketcetera.core.LoggerConfiguration;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.orderloader.Messages;
import org.marketcetera.orderloader.MockOrderProcessor;
import org.marketcetera.orderloader.OrderLoader;
import org.marketcetera.orderloader.OrderParserTest;
import org.marketcetera.orderloader.OrderParsingException;
import org.marketcetera.orderloader.OrderProcessor;
import org.marketcetera.quickfix.FIXVersion;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.util.file.CopyCharsUtils;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NMessage;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: OrderLoaderTest.java 16841 2014-02-20 19:59:04Z colin $")
public class OrderLoaderTest {
    public static final String[] SYSTEM_ORDER_EXAMPLE = new String[]{"#Sample system order input", "", "Account,OrderCapacity,OrderType,PositionEffect,Price,Quantity,Side,Symbol,SecurityType,TimeInForce,Expiry,StrikePrice,OptionType,1001", "", "#ubm equity orders", "AC1,,Market,,,11,Buy,ubm,,Day,,,,right", "AC1,,Limit,,25.56,32.09,Sell,ubm,,FillOrKill,,,,left", "", "#metc future orders", "AC3,,Limit,,50.02,7,Buy,METC-201412,Future,Day,201412,,,", "  ", "#Option orders", "AC2,Agency,Limit,Open,90,50,SellShort,zoog,Option,AtTheClose,201010,10.00,Call,up", "AC2,Individual,Market,Close,,101,SellShortExempt,moog,Option,Day,20101010,11.50,Put,down", "  ", "#Equity Orders with errors", "AC1,,OrderType?,,,11,Buy,ubm,,Day,,,,right", "AC1,,Market,,,eleven,Buy,ubm,,Day,,,,right", "AC1,,Market,,,11,Buy,ubm,,Night,,,,right", "  ", "#Option Orders with errors", "AC2,MyCapacity,Limit,Open,90,50,SellShort,zoog,Option,AtTheClose,201010,10.00,Call,up", "AC2,Agency,Limit,Open,ninety,50,SellShort,zoog,Option,AtTheClose,201010,100.00,Put,up", "AC2,Agency,Limit,Open,90,50,BuyShort,zoog,Option,AtTheClose,20101010,10.05,Put,up", "AC2,Agency,Limit,Open,90,50,SellShort,zoog,Future,AtTheClose,20101010,23.45,Call,up", "AC2,Agency,Limit,Open,90,50,SellShort,zoog,Option,AtTheClose,201010,nostrike,Call,up", "AC2,Agency,Limit,Open,90,50,SellShort,zoog,Option,AtTheClose,201010,10.00,Pup,up", "AC2,Agency,Limit,Open,90,50,SellShort,zoog,Option,AtTheClose,,10.00,Call,up"};

    @BeforeClass
    public static void setupLogger() {
        LoggerConfiguration.logSetup();
    }

    @Test
    public void nullArguments() throws Exception {
        new ExpectedFailure<NullPointerException>(){

            protected void run() throws Exception {
                new OrderLoader("", new BrokerID("y"), null, new File("don'tmatter"));
            }
        };
        new ExpectedFailure<NullPointerException>(){

            protected void run() throws Exception {
                new OrderLoader("", new BrokerID("y"), (OrderProcessor)new MockOrderProcessor(), null);
            }
        };
    }

    @Test
    public void invalidModeValues() throws Exception {
        EnumSet<FIXVersion> supportedValues = EnumSet.allOf(FIXVersion.class);
        supportedValues.remove(FIXVersion.FIX_SYSTEM);
        new ExpectedFailure<OrderParsingException>((I18NMessage)Messages.INVALID_FIX_VERSION, new Object[]{"why", ((Object)supportedValues).toString()}){

            protected void run() throws Exception {
                new OrderLoader("why", null, (OrderProcessor)new MockOrderProcessor(), new File("don'tmatter"));
            }
        };
        new ExpectedFailure<OrderParsingException>((I18NMessage)Messages.INVALID_FIX_VERSION, new Object[]{FIXVersion.FIX_SYSTEM.toString(), ((Object)supportedValues).toString()}){

            protected void run() throws Exception {
                new OrderLoader(FIXVersion.FIX_SYSTEM.toString(), null, (OrderProcessor)new MockOrderProcessor(), new File("don'tmatter"));
            }
        };
    }

    @Test
    public void brokerIDRequiredForFIX() throws Exception {
        new ExpectedFailure<OrderParsingException>((I18NBoundMessage)Messages.BROKER_ID_REQUIRED){

            protected void run() throws Exception {
                new OrderLoader(FIXVersion.FIX42.toString(), null, (OrderProcessor)new MockOrderProcessor(), new File("don'tmatter"));
            }
        };
    }

    @Test
    public void fixParse() throws Exception {
        File tmpFile = File.createTempFile("ordloader", ".csv");
        tmpFile.deleteOnExit();
        CopyCharsUtils.copy((char[])"Symbol,Side,OrderQty,Price,TimeInForce,Account\nIBM,B,100,12.1,DAY,123-ASDF-234\nIBM,SS,100,12.22,DAY,123-ASDF-234\nEFA,SSE,100,MKT,DAY,9182379812\nEFA,SSE,100,MKT,FILL_OR_KILL,9182379812\n---,SSE,100,MKT,DAY,9182379812\nEFA,---,100,MKT,DAY,9182379812\nEFA,SSE,---,MKT,DAY,9182379812\n\nEFA,SSE,100,---,DAY,9182379812\nEFA,SSE,100,MKT,---,9182379812\nEFA,SSE,100,MKT,---,---\nEFA,SSE,100,MKT,DAY,---\nEFA,SSE,100.1,MKT,DAY,9182379812\nIBM,SS,100,-12.22,DAY,123-ASDF-234\nIBM,SS,-100,12.22,DAY,123-ASDF-234\n//do nothing\n\nIBM,SS,100,12.22,DAY,123-ASDF-234\nIBM,S,100,12.22,DAY,123-ASDF-234\n".toCharArray(), (String)tmpFile.getAbsolutePath());
        this.assertLoader(FIXVersion.FIX42.toString(), new BrokerID("yo"), tmpFile, 20, 2, 0, 9, 8);
        tmpFile.delete();
    }

    @Test
    public void sysParse() throws Exception {
        File tmpFile = File.createTempFile("ordloader", ".csv");
        tmpFile.deleteOnExit();
        CopyCharsUtils.copy((char[])OrderParserTest.arrayToLines(SYSTEM_ORDER_EXAMPLE).toCharArray(), (String)tmpFile.getAbsolutePath());
        this.assertLoader(null, null, tmpFile, 28, 6, 6, 5, 10);
        this.assertLoader("sys", null, tmpFile, 28, 6, 6, 5, 10);
        this.assertLoader("sys", new BrokerID("yes"), tmpFile, 28, 6, 6, 5, 10);
        tmpFile.delete();
    }

    private OrderLoader assertLoader(String inMode, BrokerID inBrokerID, File inFile, int inNumLines, int inBlankLines, int inNumComments, int inNumSuccess, int inNumFailed) throws Exception {
        OrderLoader loader = new OrderLoader(inMode, inBrokerID, (OrderProcessor)new MockOrderProcessor(), inFile);
        Assert.assertEquals((long)inNumLines, (long)loader.getNumLines());
        Assert.assertEquals((long)inBlankLines, (long)loader.getNumBlankLines());
        Assert.assertEquals((long)inNumComments, (long)loader.getNumComments());
        Assert.assertEquals((long)inNumSuccess, (long)loader.getNumSuccess());
        Assert.assertEquals((long)inNumFailed, (long)loader.getNumFailed());
        Assert.assertEquals((long)inNumFailed, (long)loader.getFailedOrders().size());
        return loader;
    }
}

