/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.orderloader.system;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.marketcetera.core.Pair;
import org.marketcetera.orderloader.Messages;
import org.marketcetera.orderloader.OrderParsingException;
import org.marketcetera.orderloader.system.FieldProcessor;
import org.marketcetera.trade.OrderSingle;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage2P;
import org.marketcetera.util.log.I18NBoundMessage3P;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: CustomFieldProcessor.java 16154 2012-07-14 16:34:05Z colin $")
final class CustomFieldProcessor
implements FieldProcessor {
    private final List<Pair<Integer, String>> mCustomFields = new LinkedList<Pair<Integer, String>>();
    private final Map<Integer, Integer> mHeaders = new HashMap<Integer, Integer>();

    CustomFieldProcessor() {
    }

    @Override
    public void apply(String[] inRow, OrderSingle inOrder) throws OrderParsingException {
        HashMap<Object, String> customs = new HashMap<Object, String>();
        for (Pair<Integer, String> custom : this.mCustomFields) {
            customs.put(custom.getSecondMember(), inRow[(Integer)custom.getFirstMember()]);
        }
        inOrder.setCustomFields(customs);
    }

    public void addField(int inIndex, String inHeader) throws OrderParsingException {
        try {
            int header = Integer.parseInt(inHeader);
            Integer oldIndex = this.mHeaders.put(header, inIndex);
            this.mCustomFields.add((Pair<Integer, String>)new Pair((Object)inIndex, (Object)inHeader));
            if (oldIndex != null) {
                throw new OrderParsingException((I18NBoundMessage)new I18NBoundMessage3P(Messages.DUPLICATE_HEADER, (Serializable)((Object)inHeader), (Serializable)oldIndex, (Serializable)Integer.valueOf(inIndex)));
            }
        }
        catch (NumberFormatException e) {
            throw new OrderParsingException(e, (I18NBoundMessage)new I18NBoundMessage2P(Messages.INVALID_CUSTOM_HEADER, (Serializable)((Object)inHeader), (Serializable)Integer.valueOf(inIndex)));
        }
    }

    public boolean isEmpty() {
        return this.mCustomFields.isEmpty();
    }
}

