/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.orderloader.system;

import org.marketcetera.orderloader.OrderParsingException;
import org.marketcetera.orderloader.system.InstrumentFromRow;
import org.marketcetera.orderloader.system.Row;
import org.marketcetera.trade.Currency;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.SecurityType;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id$")
public class CurrencyFromRow
extends InstrumentFromRow {
    @Override
    protected boolean canProcess(String inHeader, int inIndex) {
        return false;
    }

    @Override
    protected Instrument extract(Row inRow) throws OrderParsingException {
        this.getSecurityType(inRow.getRow());
        String symbol = this.getSymbol(inRow.getRow());
        return symbol != null && !symbol.trim().isEmpty() ? new Currency(symbol) : null;
    }

    protected boolean isHandled(Row inValue) {
        SecurityType secType = null;
        try {
            secType = this.getSecurityType(inValue.getRow());
        }
        catch (OrderParsingException orderParsingException) {
            // empty catch block
        }
        return secType == null || SecurityType.Currency.equals((Object)secType);
    }
}

