/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.orderloader.system;

import java.io.Serializable;
import java.math.BigDecimal;
import org.marketcetera.orderloader.OrderParsingException;
import org.marketcetera.orderloader.system.IndexedProcessor;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.I18NMessage1P;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id")
abstract class BigDecimalProcessor
extends IndexedProcessor {
    private final I18NMessage1P mMessage;

    public BigDecimalProcessor(I18NMessage1P inMessage, int inIndex) {
        super(inIndex);
        this.mMessage = inMessage;
    }

    protected final BigDecimal getDecimalValue(String[] inRow) throws OrderParsingException {
        String value = this.getValue(inRow);
        try {
            if (value != null && !value.isEmpty()) {
                return new BigDecimal(value);
            }
            return null;
        }
        catch (NumberFormatException e) {
            throw new OrderParsingException(e, (I18NBoundMessage)new I18NBoundMessage1P(this.mMessage, (Serializable)((Object)value)));
        }
    }
}

