/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.orderloader;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.marketcetera.client.ClientInitException;
import org.marketcetera.client.ClientManager;
import org.marketcetera.client.ClientParameters;
import org.marketcetera.client.ConnectionException;
import org.marketcetera.client.ReportListener;
import org.marketcetera.orderloader.Messages;
import org.marketcetera.orderloader.OrderParsingException;
import org.marketcetera.orderloader.OrderProcessor;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.FIXOrder;
import org.marketcetera.trade.Order;
import org.marketcetera.trade.OrderCancelReject;
import org.marketcetera.trade.OrderSingle;
import org.marketcetera.trade.Originator;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: ServerOrderProcessor.java 16154 2012-07-14 16:34:05Z colin $")
public class ServerOrderProcessor
implements OrderProcessor {
    public static final long MAXIMUM_DELIVERY_WAIT = 60000L;
    private AtomicInteger mOrdersOutstanding = new AtomicInteger();

    public ServerOrderProcessor(ClientParameters inParameter) throws ClientInitException, ConnectionException {
        ClientManager.init((ClientParameters)inParameter);
        ClientManager.getInstance().addReportListener((ReportListener)new CounterListener());
    }

    @Override
    public void processOrder(Order inOrder, int inOrderIndex) throws Exception {
        if (inOrder instanceof OrderSingle) {
            ClientManager.getInstance().sendOrder((OrderSingle)inOrder);
        } else if (inOrder instanceof FIXOrder) {
            ClientManager.getInstance().sendOrderRaw((FIXOrder)inOrder);
        } else {
            throw new OrderParsingException((I18NBoundMessage)new I18NBoundMessage1P(Messages.UNEXPECTED_ORDER_TYPE, (Serializable)inOrder));
        }
        this.mOrdersOutstanding.getAndIncrement();
    }

    @Override
    public void done() {
        if (!ClientManager.isInitialized()) {
            return;
        }
        long end = System.currentTimeMillis() + 60000L;
        int lastOrdersOutstanding = this.mOrdersOutstanding.get();
        while (lastOrdersOutstanding != 0) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                break;
            }
            long now = System.currentTimeMillis();
            int ordersOutstanding = this.mOrdersOutstanding.get();
            if (ordersOutstanding < lastOrdersOutstanding) {
                end = now + 60000L;
                lastOrdersOutstanding = ordersOutstanding;
                continue;
            }
            if (now <= end) continue;
            break;
        }
        try {
            ClientManager.getInstance().close();
        }
        catch (ClientInitException ignore) {
            // empty catch block
        }
    }

    private class CounterListener
    implements ReportListener {
        private CounterListener() {
        }

        public void receiveExecutionReport(ExecutionReport inReport) {
            if (inReport.getOriginator() == Originator.Server) {
                ServerOrderProcessor.this.mOrdersOutstanding.getAndDecrement();
            }
        }

        public void receiveCancelReject(OrderCancelReject inReport) {
            if (inReport.getOriginator() == Originator.Server) {
                ServerOrderProcessor.this.mOrdersOutstanding.getAndDecrement();
            }
        }
    }
}

