/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.orderloader;

import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.marketcetera.orderloader.FailedOrderInfo;
import org.marketcetera.orderloader.Messages;
import org.marketcetera.orderloader.OrderParsingException;
import org.marketcetera.orderloader.OrderProcessor;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.Order;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage2P;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: RowProcessor.java 16154 2012-07-14 16:34:05Z colin $")
public abstract class RowProcessor {
    private int mNumHeaders;
    private int mNumSuccess = 0;
    private int mNumFailed = 0;
    private final List<FailedOrderInfo> mFailedOrders = new LinkedList<FailedOrderInfo>();
    private final BrokerID mBrokerID;
    private final OrderProcessor mProcessor;

    public final void initialize(String ... inHeaders) throws OrderParsingException {
        this.mNumHeaders = inHeaders.length;
        this.setHeaders(inHeaders);
    }

    public final void processOrder(int inIndex, String ... inRow) {
        try {
            if (this.getNumHeaders() != inRow.length) {
                throw new OrderParsingException((I18NBoundMessage)new I18NBoundMessage2P(Messages.HEADER_ROW_MISMATCH, (Serializable)Integer.valueOf(this.getNumHeaders()), (Serializable)Integer.valueOf(inRow.length)));
            }
            Order order = this.parseOrder(inRow);
            this.getProcessor().processOrder(order, inIndex);
            ++this.mNumSuccess;
        }
        catch (Exception e) {
            ++this.mNumFailed;
            this.addFailed(inIndex, inRow, e);
        }
    }

    public final int getTotal() {
        return this.getNumFailed() + this.getNumSuccess();
    }

    public final int getNumFailed() {
        return this.mNumFailed;
    }

    public final int getNumSuccess() {
        return this.mNumSuccess;
    }

    public final List<FailedOrderInfo> getFailedOrders() {
        return this.mFailedOrders;
    }

    protected RowProcessor(OrderProcessor inProcessor, BrokerID inBrokerID) {
        if (inProcessor == null) {
            throw new NullPointerException();
        }
        this.mProcessor = inProcessor;
        this.mBrokerID = inBrokerID;
    }

    protected final BrokerID geBrokerID() {
        return this.mBrokerID;
    }

    protected abstract void setHeaders(String[] var1) throws OrderParsingException;

    protected abstract Order parseOrder(String[] var1) throws OrderParsingException;

    private void addFailed(int inIndex, String[] inRow, Exception inException) {
        this.mFailedOrders.add(new FailedOrderInfo(inIndex, inRow, inException));
        Messages.LOG_FAILED_ORDER.error((Object)this, (Throwable)inException, (Object)inIndex, (Object)Arrays.toString(inRow));
    }

    private OrderProcessor getProcessor() {
        return this.mProcessor;
    }

    private int getNumHeaders() {
        return this.mNumHeaders;
    }
}

