/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.orderloader.fix;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Vector;
import org.marketcetera.orderloader.Messages;
import org.marketcetera.orderloader.OrderParsingException;
import org.marketcetera.orderloader.OrderProcessor;
import org.marketcetera.orderloader.RowProcessor;
import org.marketcetera.orderloader.fix.CustomField;
import org.marketcetera.quickfix.FIXDataDictionary;
import org.marketcetera.quickfix.FIXFieldConverterNotAvailable;
import org.marketcetera.quickfix.FIXMessageFactory;
import org.marketcetera.quickfix.FIXVersion;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.FIXOrder;
import org.marketcetera.trade.Factory;
import org.marketcetera.trade.Order;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.I18NBoundMessage2P;
import org.marketcetera.util.misc.ClassVersion;
import quickfix.CharField;
import quickfix.Field;
import quickfix.Message;
import quickfix.StringField;
import quickfix.UtcTimeStampField;
import quickfix.field.HandlInst;
import quickfix.field.MsgType;
import quickfix.field.OrdType;
import quickfix.field.TimeInForce;
import quickfix.field.TransactTime;

@ClassVersion(value="$Id: FIXProcessor.java 16154 2012-07-14 16:34:05Z colin $")
public class FIXProcessor
extends RowProcessor {
    protected static String MKT_PRICE = "MKT";
    private String[] mHeaderNames;
    private Vector<Field<?>> mHeaderFields;
    private final FIXMessageFactory mMsgFactory;
    private final FIXDataDictionary mDictionary;

    public FIXProcessor(OrderProcessor inProcessor, BrokerID inBrokerID, FIXVersion inFIXVersion) throws OrderParsingException {
        super(inProcessor, inBrokerID);
        this.mMsgFactory = inFIXVersion.getMessageFactory();
        try {
            this.mDictionary = new FIXDataDictionary(inFIXVersion.getDataDictionaryURL());
        }
        catch (FIXFieldConverterNotAvailable e) {
            throw new OrderParsingException(e, (I18NBoundMessage)new I18NBoundMessage1P(Messages.ERROR_PROCESS_FIX_VERSION, (Serializable)((Object)inFIXVersion.toString())));
        }
        if (inBrokerID == null) {
            throw new OrderParsingException((I18NBoundMessage)Messages.BROKER_ID_REQUIRED);
        }
    }

    @Override
    public void setHeaders(String[] inHeaders) throws OrderParsingException {
        this.mHeaderNames = inHeaders;
        this.mHeaderFields = new Vector(inHeaders.length);
        for (String field : inHeaders) {
            this.mHeaderFields.add(this.getQuickFixFieldFromName(field));
        }
    }

    @Override
    protected Order parseOrder(String[] inRow) throws OrderParsingException {
        Message message = this.mMsgFactory.newBasicOrder();
        FIXProcessor.addDefaults(message);
        for (int i = 0; i < this.mHeaderFields.size(); ++i) {
            Field<?> theField = this.mHeaderFields.get(i);
            String value = this.parseMessageValue(theField, this.mHeaderNames[i], inRow[i], message);
            if (value == null) continue;
            int fieldID = theField.getField();
            if (this.mDictionary.getDictionary().isMsgField("D", fieldID)) {
                message.setField(new StringField(fieldID, value));
                continue;
            }
            if (this.mDictionary.getDictionary().isHeaderField(fieldID)) {
                message.getHeader().setField(new StringField(fieldID, value));
                continue;
            }
            if (this.mDictionary.getDictionary().isTrailerField(fieldID)) {
                message.getTrailer().setField(new StringField(fieldID, value));
                continue;
            }
            throw new OrderParsingException((I18NBoundMessage)new I18NBoundMessage2P(Messages.PARSING_FIELD_NOT_IN_DICT, (Serializable)((Object)String.valueOf(fieldID)), (Serializable)((Object)value)));
        }
        try {
            FIXOrder order = Factory.getInstance().createOrder(message, this.geBrokerID());
            this.mDictionary.getDictionary().validate(order.getMessage(), true);
            return order;
        }
        catch (Exception e) {
            throw new OrderParsingException(e, (I18NBoundMessage)new I18NBoundMessage1P(Messages.PARSED_MESSAGE_FAILED_VALIDATION, (Serializable)((Object)message.toString())));
        }
    }

    protected Field<?> getQuickFixFieldFromName(String inFieldName) throws OrderParsingException {
        Field theField = null;
        try {
            theField = (Field)Class.forName("quickfix.field." + inFieldName).newInstance();
        }
        catch (ClassNotFoundException ex) {
            return CustomField.getCustomField(inFieldName);
        }
        catch (Exception ex) {
            throw new OrderParsingException(ex, (I18NBoundMessage)new I18NBoundMessage1P(Messages.ERROR_PARSING_UNKNOWN, (Serializable)((Object)inFieldName)));
        }
        return theField;
    }

    protected String parseMessageValue(Field<?> inField, String inFieldName, String inValue, Message inMessage) throws OrderParsingException {
        if (inField instanceof CustomField) {
            return ((CustomField)inField).parseMessageValue(inValue).toString();
        }
        switch (inField.getField()) {
            case 54: {
                return FIXProcessor.getSide(inValue) + "";
            }
            case 44: {
                if (MKT_PRICE.equals(inValue)) {
                    inMessage.setField((CharField)new OrdType('1'));
                    return null;
                }
                BigDecimal price = null;
                try {
                    price = new BigDecimal(inValue);
                }
                catch (NumberFormatException ex) {
                    throw new OrderParsingException(ex, (I18NBoundMessage)new I18NBoundMessage1P(Messages.PARSING_PRICE_VALID_NUM, (Serializable)((Object)inValue)));
                }
                if (price.compareTo(BigDecimal.ZERO) <= 0) {
                    throw new OrderParsingException((I18NBoundMessage)new I18NBoundMessage1P(Messages.PARSING_PRICE_POSITIVE, (Serializable)price));
                }
                return inValue;
            }
            case 38: {
                Integer qty = null;
                try {
                    qty = Integer.parseInt(inValue);
                }
                catch (NumberFormatException ex) {
                    throw new OrderParsingException(ex, (I18NBoundMessage)new I18NBoundMessage1P(Messages.PARSING_QTY_INT, (Serializable)((Object)inValue)));
                }
                if (qty <= 0) {
                    throw new OrderParsingException((I18NBoundMessage)new I18NBoundMessage1P(Messages.PARSING_QTY_POS_INT, (Serializable)((Object)inValue)));
                }
                return inValue;
            }
            case 59: {
                try {
                    java.lang.reflect.Field theField = TimeInForce.class.getField(inValue);
                    return theField.get(null).toString();
                }
                catch (Exception ex) {
                    throw new OrderParsingException(ex, inFieldName, inValue);
                }
            }
        }
        return inValue;
    }

    protected static char getSide(String inValue) {
        if (inValue != null) {
            if ("".equals(inValue = inValue.toUpperCase())) {
                return '7';
            }
            if ("B".equals(inValue)) {
                return '1';
            }
            if ("S".equals(inValue)) {
                return '2';
            }
            if ("SS".equals(inValue)) {
                return '5';
            }
            if ("SSE".equals(inValue)) {
                return '6';
            }
        }
        return '7';
    }

    protected static void addDefaults(Message message) {
        message.getHeader().setField((StringField)new MsgType("D"));
        message.setField((CharField)new OrdType('2'));
        message.setField((CharField)new HandlInst('1'));
        message.setField((UtcTimeStampField)new TransactTime());
    }

    Vector<Field<?>> getHeaderFields() {
        return this.mHeaderFields;
    }

    String[] getHeaderNames() {
        return this.mHeaderNames;
    }
}

