/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.orderloader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.List;
import org.marketcetera.orderloader.FailedOrderInfo;
import org.marketcetera.orderloader.Messages;
import org.marketcetera.orderloader.OrderParser;
import org.marketcetera.orderloader.OrderParsingException;
import org.marketcetera.orderloader.OrderProcessor;
import org.marketcetera.orderloader.RowProcessor;
import org.marketcetera.orderloader.fix.FIXProcessor;
import org.marketcetera.orderloader.system.SystemProcessor;
import org.marketcetera.quickfix.FIXVersion;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage2P;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: OrderLoader.java 16154 2012-07-14 16:34:05Z colin $")
public class OrderLoader {
    private final RowProcessor mRowProcessor;
    private final OrderParser mParser;
    public static final String MODE_SYSTEM = "sys";

    public OrderLoader(String inMode, BrokerID inBrokerID, OrderProcessor inOrderProcessor, File inFile) throws OrderParsingException, IOException {
        if (inOrderProcessor == null) {
            throw new NullPointerException();
        }
        if (inFile == null) {
            throw new NullPointerException();
        }
        if (inMode == null || inMode.equals(MODE_SYSTEM)) {
            this.mRowProcessor = new SystemProcessor(inOrderProcessor, inBrokerID);
        } else {
            FIXVersion fixVersion;
            EnumSet<FIXVersion> supportedValues = EnumSet.allOf(FIXVersion.class);
            supportedValues.remove(FIXVersion.FIX_SYSTEM);
            try {
                fixVersion = FIXVersion.getFIXVersion((String)inMode);
            }
            catch (IllegalArgumentException e) {
                throw new OrderParsingException(e, (I18NBoundMessage)new I18NBoundMessage2P(Messages.INVALID_FIX_VERSION, (Serializable)((Object)inMode), (Serializable)((Object)((Object)supportedValues).toString())));
            }
            if (!supportedValues.contains(fixVersion)) {
                throw new OrderParsingException((I18NBoundMessage)new I18NBoundMessage2P(Messages.INVALID_FIX_VERSION, (Serializable)((Object)inMode), (Serializable)((Object)((Object)supportedValues).toString())));
            }
            this.mRowProcessor = new FIXProcessor(inOrderProcessor, inBrokerID, fixVersion);
        }
        this.mParser = new OrderParser(this.mRowProcessor);
        this.mParser.parseOrders(new FileInputStream(inFile));
    }

    public int getNumLines() {
        return this.mParser.getNumLines();
    }

    public int getNumBlankLines() {
        return this.mParser.getNumBlankLines();
    }

    public int getNumComments() {
        return this.mParser.getNumComments();
    }

    public int getNumSuccess() {
        return this.mRowProcessor.getNumSuccess();
    }

    public int getNumFailed() {
        return this.mRowProcessor.getNumFailed();
    }

    public List<FailedOrderInfo> getFailedOrders() {
        return this.mRowProcessor.getFailedOrders();
    }
}

