/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.orderloader;

import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.PropertyConfigurator;
import org.marketcetera.client.ClientParameters;
import org.marketcetera.core.ApplicationBase;
import org.marketcetera.core.ApplicationVersion;
import org.marketcetera.orderloader.FailedOrderInfo;
import org.marketcetera.orderloader.Messages;
import org.marketcetera.orderloader.OrderLoader;
import org.marketcetera.orderloader.OrderProcessor;
import org.marketcetera.orderloader.ServerOrderProcessor;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.util.auth.OptionsProvider;
import org.marketcetera.util.auth.StandardAuthentication;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.context.support.StaticApplicationContext;

@ClassVersion(value="$Id: Main.java 16154 2012-07-14 16:34:05Z colin $")
public class Main {
    private PrintStream mMsgStream = System.err;
    private StandardAuthentication mAuthentication;
    private String mMode;
    private BrokerID mBrokerID;
    private String mFileName;
    private static final String CFG_BASE_FILE_NAME = "file:" + ApplicationBase.CONF_DIR + "orderloader.xml";
    private static final String OPT_MODE = "m";
    private static final String OPT_BROKER = "b";
    private static final String USER_PROPERTY = "metc.client.user";
    private static final String PASSWORD_PROPERTY = "metc.client.password";
    static final int EXIT_CODE_FAILURE = 2;
    static final int EXIT_CODE_USAGE = 1;
    static final int EXIT_CODE_SUCCESS = 0;

    public static void main(String[] inArgs) {
        PropertyConfigurator.configureAndWatch((String)(ApplicationBase.CONF_DIR + "log4j.properties"), (long)20000L);
        Messages.LOG_APP_COPYRIGHT.info(Main.class);
        Messages.LOG_APP_VERSION_BUILD.info(Main.class, (Object)ApplicationVersion.getVersion(), (Object)ApplicationVersion.getBuildNumber());
        Main main = new Main();
        Main.run(inArgs, main);
    }

    protected void setMsgStream(PrintStream inMsgStream) {
        this.mMsgStream = inMsgStream;
    }

    protected boolean processArguments(String[] inArgs) {
        this.mAuthentication = new StandardAuthentication(CFG_BASE_FILE_NAME, "propertiesFiles", USER_PROPERTY, PASSWORD_PROPERTY, "u", "user", "p", "password", inArgs);
        this.mAuthentication.getCliContext().setOptionsProvider(new OptionsProvider(){

            public void addOptions(Options inOptions) {
                Main.this.options(inOptions);
            }
        });
        if (!this.mAuthentication.setValues()) {
            this.usage();
            return false;
        }
        ParseException parseException = this.mAuthentication.getCliContext().getParseException();
        if (parseException != null) {
            this.printError((Exception)parseException);
            this.usage();
            return false;
        }
        CommandLine cmdLine = this.mAuthentication.getCliContext().getCommandLine();
        this.mMode = cmdLine.getOptionValue(OPT_MODE);
        String broker = cmdLine.getOptionValue(OPT_BROKER);
        this.mBrokerID = broker == null ? null : new BrokerID(broker);
        inArgs = this.mAuthentication.getOtherArgs();
        if (inArgs.length < 1) {
            this.printMessage(Messages.ERROR_MISSING_FILE.getText());
            this.usage();
            return false;
        }
        if (inArgs.length > 1) {
            this.printMessage(Messages.ERROR_TOO_MANY_ARGUMENTS.getText());
            this.usage();
            return false;
        }
        this.mFileName = inArgs[0];
        return true;
    }

    protected void exit(int inCode) {
        System.exit(inCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doProcessing() throws Exception {
        StaticApplicationContext context = new StaticApplicationContext((ApplicationContext)new FileSystemXmlApplicationContext(CFG_BASE_FILE_NAME));
        String clientURL = (String)context.getBean("clientURL");
        String clientWSHost = (String)context.getBean("clientWSHost");
        Integer clientWSPort = (Integer)context.getBean("clientWSPort");
        String clientIDPrefix = (String)context.getBean("clientIDPrefix");
        ClientParameters parameters = new ClientParameters(this.mAuthentication.getUser(), this.mAuthentication.getPassword(), clientURL, clientWSHost, clientWSPort.intValue(), clientIDPrefix);
        OrderProcessor processor = this.createProcessor(parameters);
        try {
            this.displaySummary(new OrderLoader(this.mMode, this.mBrokerID, processor, new File(this.mFileName)));
        }
        finally {
            processor.done();
        }
    }

    protected OrderProcessor createProcessor(ClientParameters inParameters) throws Exception {
        return new ServerOrderProcessor(inParameters);
    }

    protected void displaySummary(OrderLoader inLoader) {
        this.printMessage(Messages.LINE_SUMMARY.getText((Object)inLoader.getNumLines(), (Object)inLoader.getNumBlankLines(), (Object)inLoader.getNumComments()));
        this.printMessage(Messages.ORDER_SUMMARY.getText((Object)inLoader.getNumSuccess(), (Object)inLoader.getNumFailed()));
        List<FailedOrderInfo> list = inLoader.getFailedOrders();
        if (!list.isEmpty()) {
            this.printMessage(Messages.FAILED_ORDERS.getText());
            for (FailedOrderInfo info : list) {
                this.printMessage(Messages.FAILED_ORDER.getText((Object)info.getIndex(), (Object)Arrays.toString(info.getRow()), (Object)this.getExceptionMsg(info.getException())));
            }
        }
    }

    protected void printMessage(String inMessage) {
        this.mMsgStream.println(inMessage);
    }

    protected void printError(Exception inException) {
        this.printMessage(this.getExceptionMsg(inException));
        SLF4JLoggerProxy.debug((Object)this, (Throwable)inException);
    }

    protected String getExceptionMsg(Exception inException) {
        if (inException instanceof I18NException) {
            return ((I18NException)inException).getLocalizedDetail();
        }
        return inException.getLocalizedMessage();
    }

    static void run(String[] inArgs, Main inMain) {
        inMain.printMessage(Messages.LOG_APP_COPYRIGHT.getText());
        inMain.printMessage(Messages.LOG_APP_VERSION_BUILD.getText((Object)ApplicationVersion.getVersion(), (Object)ApplicationVersion.getBuildNumber()));
        if (inMain.processArguments(inArgs)) {
            try {
                inMain.doProcessing();
                inMain.exit(0);
            }
            catch (Exception e) {
                inMain.printError(e);
                inMain.exit(2);
            }
        }
    }

    private void usage() {
        this.printMessage(Messages.ERROR_USAGE.getText());
        this.printMessage("");
        this.printMessage(Messages.ERROR_EXAMPLE.getText());
        this.printMessage("");
        this.printMessage(Messages.USAGE_LOADER_OPTIONS.getText());
        this.printMessage(Messages.USAGE_MODE.getText());
        this.printMessage(Messages.USAGE_BROKER_ID.getText());
        this.printMessage("");
        this.printMessage(Messages.ERROR_AUTHENTICATION.getText());
        this.mAuthentication.printUsage(this.mMsgStream);
        this.exit(1);
    }

    private void options(Options inOptions) {
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)Messages.ARG_MODE_VALUE.getText());
        OptionBuilder.withDescription((String)Messages.ARG_MODE_DESCRIPTION.getText());
        OptionBuilder.isRequired((boolean)false);
        inOptions.addOption(OptionBuilder.create((String)OPT_MODE));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)Messages.ARG_BROKER_VALUE.getText());
        OptionBuilder.withDescription((String)Messages.ARG_BROKER_DESCRIPTION.getText());
        OptionBuilder.isRequired((boolean)false);
        inOptions.addOption(OptionBuilder.create((String)OPT_BROKER));
    }
}

