/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.orderloader;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.SystemUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.marketcetera.core.LoggerConfiguration;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.orderloader.FailedOrderInfo;
import org.marketcetera.orderloader.Messages;
import org.marketcetera.orderloader.MockOrderProcessor;
import org.marketcetera.orderloader.OrderParser;
import org.marketcetera.orderloader.OrderParsingException;
import org.marketcetera.orderloader.OrderProcessor;
import org.marketcetera.orderloader.RowProcessor;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.Factory;
import org.marketcetera.trade.Order;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage2P;
import org.marketcetera.util.log.I18NMessage0P;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.unicode.SignatureCharset;

@ClassVersion(value="$Id: OrderParserTest.java 16154 2012-07-14 16:34:05Z colin $")
public class OrderParserTest {
    private static final I18NMessage0P PARSE_FAILURE = new I18NMessage0P(Messages.LOGGER, "parseFailure");
    private static final I18NMessage0P HEADER_FAILURE = new I18NMessage0P(Messages.LOGGER, "headerFailure");
    private static final String[] SAMPLE_INPUT = new String[]{"# comment followed by empty lines", "", "  ", "head1,head2,head3,head4", "", "value1,value2,value3,value4", "avalue1,avalue2,avalue3,avalue4", "# another comment", "bvalue1,bvalue2,bvalue3,bvalue4", "  ", "a1value1,a1value2,a1value3,a1value4", "b1value1,b1value2,b1value3,b1value4", "# commentary", "cvalue1,cvalue2,cvalue3,cvalue4", "# Trailing comment and empty lines", "  ", ""};

    @BeforeClass
    public static void setupLogger() {
        LoggerConfiguration.logSetup();
    }

    @Test
    public void nullRowProcessor() throws Exception {
        new ExpectedFailure<NullPointerException>(){

            protected void run() throws Exception {
                new OrderParser(null);
            }
        };
    }

    @Test
    public void nullOrderProcessor() throws Exception {
        new ExpectedFailure<NullPointerException>(){

            protected void run() throws Exception {
                new MockRowProcessor(new BrokerID("yyz"), null);
            }
        };
    }

    @Test
    public void noInput() throws Exception {
        MockOrderProcessor orderProcessor = new MockOrderProcessor();
        final MockRowProcessor rowProcessor = new MockRowProcessor(null, orderProcessor);
        new ExpectedFailure<OrderParsingException>((I18NBoundMessage)Messages.ERROR_NO_ORDERS){

            protected void run() throws Exception {
                OrderParser parser = new OrderParser((RowProcessor)rowProcessor);
                parser.parseOrders((InputStream)new ByteArrayInputStream("".getBytes()));
            }
        };
        new ExpectedFailure<OrderParsingException>((I18NBoundMessage)Messages.ERROR_NO_ORDERS){

            protected void run() throws Exception {
                OrderParser parser = new OrderParser((RowProcessor)rowProcessor);
                parser.parseOrders((InputStream)new ByteArrayInputStream(OrderParserTest.arrayToLines("", "  ", " \t").getBytes()));
            }
        };
        new ExpectedFailure<OrderParsingException>((I18NBoundMessage)Messages.ERROR_NO_ORDERS){

            protected void run() throws Exception {
                OrderParser parser = new OrderParser((RowProcessor)rowProcessor);
                parser.parseOrders((InputStream)new ByteArrayInputStream(OrderParserTest.arrayToLines("# uno", "#dos", "#tres").getBytes()));
            }
        };
        new ExpectedFailure<OrderParsingException>((I18NBoundMessage)Messages.ERROR_NO_ORDERS){

            protected void run() throws Exception {
                OrderParser parser = new OrderParser((RowProcessor)rowProcessor);
                parser.parseOrders((InputStream)new ByteArrayInputStream(OrderParserTest.arrayToLines("#", "  ", "# yes", " \t", "#blue").getBytes()));
            }
        };
    }

    @Test
    public void sampleInput() throws Exception {
        this.verifySampleInput(new ByteArrayInputStream(OrderParserTest.arrayToLines(SAMPLE_INPUT).getBytes()));
        this.verifySampleInput(new ByteArrayInputStream(SignatureCharset.UTF8_UTF8.encode(OrderParserTest.arrayToLines(SAMPLE_INPUT))));
        this.verifySampleInput(new ByteArrayInputStream(SignatureCharset.UTF32BE_UTF32BE.encode(OrderParserTest.arrayToLines(SAMPLE_INPUT))));
    }

    @Test
    public void misMatchedHeaderRow() throws Exception {
        MockOrderProcessor orderProcessor = new MockOrderProcessor();
        MockRowProcessor rowProcessor = new MockRowProcessor(null, orderProcessor);
        OrderParser parser = new OrderParser((RowProcessor)rowProcessor);
        OrderParserTest.assertParser(parser, 0, 0, 0);
        String failRow = "duck1,duck2,duck4";
        parser.parseOrders((InputStream)new ByteArrayInputStream(OrderParserTest.arrayToLines("head1,head2,head3,head4", "cow1,cow2,cow3,cow4", failRow, "deer1,deer2,deer3,deer4").getBytes()));
        OrderParserTest.assertParser(parser, 4, 0, 0);
        OrderParserTest.assertProcessor(rowProcessor, 2, 1);
        List list = rowProcessor.getFailedOrders();
        Assert.assertEquals((long)1L, (long)list.size());
        FailedOrderInfo info = (FailedOrderInfo)list.get(0);
        Assert.assertEquals((long)3L, (long)info.getIndex());
        Assert.assertArrayEquals((Object[])failRow.split(","), (Object[])info.getRow());
        Assert.assertEquals((Object)new I18NBoundMessage2P(Messages.HEADER_ROW_MISMATCH, (Serializable)Integer.valueOf(4), (Serializable)Integer.valueOf(3)), (Object)((I18NException)info.getException()).getI18NBoundMessage());
    }

    @Test
    public void orderProcessorFailure() throws Exception {
        MockOrderProcessor orderProcessor = new MockOrderProcessor();
        orderProcessor.setFail(true);
        MockRowProcessor rowProcessor = new MockRowProcessor(null, orderProcessor);
        OrderParser parser = new OrderParser((RowProcessor)rowProcessor);
        OrderParserTest.assertParser(parser, 0, 0, 0);
        String failRow = "value1,value2,value3";
        parser.parseOrders((InputStream)new ByteArrayInputStream(OrderParserTest.arrayToLines("head1,head2,header", failRow).getBytes()));
        OrderParserTest.assertParser(parser, 2, 0, 0);
        OrderParserTest.assertProcessor(rowProcessor, 0, 1);
        List list = rowProcessor.getFailedOrders();
        Assert.assertEquals((long)1L, (long)list.size());
        FailedOrderInfo info = (FailedOrderInfo)list.get(0);
        Assert.assertEquals((long)2L, (long)info.getIndex());
        Assert.assertArrayEquals((Object[])failRow.split(","), (Object[])info.getRow());
        Assert.assertTrue((String)info.getException().toString(), (boolean)(info.getException() instanceof IllegalArgumentException));
        Assert.assertEquals((Object)"OrderFailure", (Object)info.getException().getMessage());
    }

    @Test
    public void headerProcessingFailure() throws Exception {
        MockOrderProcessor orderProcessor = new MockOrderProcessor();
        MockRowProcessor rowProcessor = new MockRowProcessor(null, orderProcessor);
        rowProcessor.setHeaderFail(true);
        final OrderParser parser = new OrderParser((RowProcessor)rowProcessor);
        OrderParserTest.assertParser(parser, 0, 0, 0);
        new ExpectedFailure<OrderParsingException>((I18NBoundMessage)HEADER_FAILURE){

            protected void run() throws Exception {
                parser.parseOrders((InputStream)new ByteArrayInputStream(OrderParserTest.arrayToLines("head1,head2,header", "value1,value2,value3").getBytes()));
            }
        };
    }

    @Test
    public void rowProcessingFailure() throws Exception {
        MockOrderProcessor orderProcessor = new MockOrderProcessor();
        MockRowProcessor rowProcessor = new MockRowProcessor(null, orderProcessor);
        rowProcessor.setParseFail(Pattern.compile("^a.*"));
        OrderParser parser = new OrderParser((RowProcessor)rowProcessor);
        OrderParserTest.assertParser(parser, 0, 0, 0);
        parser.parseOrders((InputStream)new ByteArrayInputStream(OrderParserTest.arrayToLines(SAMPLE_INPUT).getBytes()));
        OrderParserTest.assertParser(parser, 17, 6, 4);
        OrderParserTest.assertProcessor(rowProcessor, 4, 2);
        List list = rowProcessor.getFailedOrders();
        Assert.assertEquals((long)2L, (long)list.size());
        FailedOrderInfo info = (FailedOrderInfo)list.get(0);
        Assert.assertEquals((long)7L, (long)info.getIndex());
        Assert.assertArrayEquals((Object[])SAMPLE_INPUT[6].split(","), (Object[])info.getRow());
        Assert.assertEquals((Object)PARSE_FAILURE, (Object)((OrderParsingException)info.getException()).getI18NBoundMessage());
        info = (FailedOrderInfo)list.get(1);
        Assert.assertEquals((long)11L, (long)info.getIndex());
        Assert.assertArrayEquals((Object[])SAMPLE_INPUT[10].split(","), (Object[])info.getRow());
        Assert.assertEquals((Object)PARSE_FAILURE, (Object)((OrderParsingException)info.getException()).getI18NBoundMessage());
    }

    private void verifySampleInput(InputStream inInputStream) throws IOException, OrderParsingException {
        MockOrderProcessor orderProcessor = new MockOrderProcessor();
        MockRowProcessor rowProcessor = new MockRowProcessor(null, orderProcessor);
        OrderParser parser = new OrderParser((RowProcessor)rowProcessor);
        OrderParserTest.assertParser(parser, 0, 0, 0);
        parser.parseOrders(inInputStream);
        OrderParserTest.assertParser(parser, 17, 6, 4);
        OrderParserTest.assertProcessor(rowProcessor, 6, 0);
        Assert.assertArrayEquals((Object[])SAMPLE_INPUT[3].split(","), (Object[])rowProcessor.getHeaders());
        List<String[]> rows = rowProcessor.getRows();
        Assert.assertEquals((long)6L, (long)rows.size());
        Assert.assertArrayEquals((Object[])SAMPLE_INPUT[5].split(","), (Object[])rows.get(0));
        Assert.assertArrayEquals((Object[])SAMPLE_INPUT[6].split(","), (Object[])rows.get(1));
        Assert.assertArrayEquals((Object[])SAMPLE_INPUT[8].split(","), (Object[])rows.get(2));
        Assert.assertArrayEquals((Object[])SAMPLE_INPUT[10].split(","), (Object[])rows.get(3));
        Assert.assertArrayEquals((Object[])SAMPLE_INPUT[11].split(","), (Object[])rows.get(4));
        Assert.assertArrayEquals((Object[])SAMPLE_INPUT[13].split(","), (Object[])rows.get(5));
        Assert.assertEquals((long)6L, (long)orderProcessor.getOrders().size());
    }

    @Test
    public void brokerID() throws Exception {
        MockOrderProcessor orderProcessor = new MockOrderProcessor();
        MockRowProcessor rowProcessor = new MockRowProcessor(null, orderProcessor);
        Assert.assertEquals(null, (Object)rowProcessor.geBrokerID());
        BrokerID brokerID = new BrokerID("SFO");
        rowProcessor = new MockRowProcessor(brokerID, orderProcessor);
        Assert.assertEquals((Object)brokerID, (Object)rowProcessor.geBrokerID());
    }

    public static void assertParser(OrderParser inParser, int inNumLines, int inNumBlankLines, int inNumComments) {
        Assert.assertEquals((long)inNumLines, (long)inParser.getNumLines());
        Assert.assertEquals((long)inNumBlankLines, (long)inParser.getNumBlankLines());
        Assert.assertEquals((long)inNumComments, (long)inParser.getNumComments());
    }

    public static void assertProcessor(RowProcessor inProcessor, int inSuccess, int inFailed) {
        Assert.assertEquals((long)inSuccess, (long)inProcessor.getNumSuccess());
        Assert.assertEquals((long)inFailed, (long)inProcessor.getNumFailed());
        Assert.assertEquals((long)inFailed, (long)inProcessor.getFailedOrders().size());
        Assert.assertEquals((long)(inFailed + inSuccess), (long)inProcessor.getTotal());
    }

    static String arrayToLines(String ... inLines) {
        StringBuilder builder = new StringBuilder();
        for (String line : inLines) {
            builder.append(line).append(SystemUtils.LINE_SEPARATOR);
        }
        return builder.toString();
    }

    private static class MockRowProcessor
    extends RowProcessor {
        private boolean mHeaderFail = false;
        private Pattern mParseFail = null;
        private List<String[]> mRows = new LinkedList<String[]>();
        private String[] mHeaders;

        protected MockRowProcessor(BrokerID inBrokerID, OrderProcessor inProcessor) {
            super(inProcessor, inBrokerID);
        }

        protected void setHeaders(String[] inHeaders) throws OrderParsingException {
            this.mHeaders = inHeaders;
            if (this.mHeaderFail) {
                throw new OrderParsingException((I18NBoundMessage)HEADER_FAILURE);
            }
        }

        protected Order parseOrder(String[] inRow) throws OrderParsingException {
            this.mRows.add(inRow);
            if (this.mParseFail != null && this.mParseFail.matcher(inRow[0]).matches()) {
                throw new OrderParsingException((I18NBoundMessage)PARSE_FAILURE);
            }
            return Factory.getInstance().createOrderSingle();
        }

        public String[] getHeaders() {
            return this.mHeaders;
        }

        public List<String[]> getRows() {
            return this.mRows;
        }

        public void setHeaderFail(boolean inHeaderFail) {
            this.mHeaderFail = inHeaderFail;
        }

        public void setParseFail(Pattern inParseFail) {
            this.mParseFail = inParseFail;
        }
    }
}

