/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.orderloader;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.marketcetera.client.ClientParameters;
import org.marketcetera.core.LoggerConfiguration;
import org.marketcetera.orderloader.Main;
import org.marketcetera.orderloader.Messages;
import org.marketcetera.orderloader.MockOrderProcessor;
import org.marketcetera.orderloader.OrderLoaderTest;
import org.marketcetera.orderloader.OrderParserTest;
import org.marketcetera.orderloader.OrderProcessor;
import org.marketcetera.util.file.CopyCharsUtils;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: MainTest.java 16154 2012-07-14 16:34:05Z colin $")
public class MainTest {
    private static final String TEST_FAILURE = "TEST FAILURE";
    public ByteArrayOutputStream mOutput;

    @BeforeClass
    public static void setupLogger() {
        LoggerConfiguration.logSetup();
    }

    @Test
    public void inputFileMissing() {
        MockMain main = this.run(new String[0]);
        Assert.assertEquals((long)1L, (long)main.getExitCode());
        String output = this.mOutput.toString();
        Assert.assertTrue((String)output, (boolean)output.contains(Messages.ERROR_MISSING_FILE.getText()));
    }

    @Test
    public void tooManyArgs() {
        MockMain main = this.run("file", "extra");
        Assert.assertEquals((long)1L, (long)main.getExitCode());
        String output = this.mOutput.toString();
        Assert.assertTrue((String)output, (boolean)output.contains(Messages.ERROR_TOO_MANY_ARGUMENTS.getText()));
    }

    @Test
    public void incorrectModeSyntax() {
        MockMain main = this.run("-m");
        Assert.assertEquals((long)1L, (long)main.getExitCode());
        String output = this.mOutput.toString();
        Assert.assertTrue((String)output, (boolean)output.contains("option:m"));
    }

    @Test
    public void incorrectBrokerSyntax() {
        MockMain main = this.run("-b");
        Assert.assertEquals((long)1L, (long)main.getExitCode());
        String output = this.mOutput.toString();
        Assert.assertTrue((String)output, (boolean)output.contains("option:b"));
    }

    @Test
    public void incorrectUsernameSyntax() {
        MockMain main = this.run("-u");
        Assert.assertEquals((long)1L, (long)main.getExitCode());
        String output = this.mOutput.toString();
        Assert.assertTrue((String)output, (boolean)output.contains("option:u"));
        Assert.assertTrue((String)output, (boolean)output.contains(Messages.LOG_APP_COPYRIGHT.getText()));
    }

    @Test
    public void incorrectPasswordSyntax() {
        MockMain main = this.run("-p");
        Assert.assertEquals((long)1L, (long)main.getExitCode());
        String output = this.mOutput.toString();
        Assert.assertTrue((String)output, (boolean)output.contains("option:p"));
    }

    @Test
    public void systemOrder() throws Exception {
        File tmpFile = File.createTempFile("orders", ".csv");
        tmpFile.deleteOnExit();
        CopyCharsUtils.copy((char[])OrderParserTest.arrayToLines(OrderLoaderTest.SYSTEM_ORDER_EXAMPLE).toCharArray(), (String)tmpFile.getAbsolutePath());
        MockMain main = this.run(tmpFile.getAbsolutePath());
        Assert.assertEquals((long)0L, (long)main.getExitCode());
        ClientParameters parameters = main.getClientParameters();
        Assert.assertEquals((Object)"127.0.0.1", (Object)parameters.getHostname());
        Assert.assertEquals((Object)"", (Object)parameters.getIDPrefix());
        Assert.assertArrayEquals((char[])"admin".toCharArray(), (char[])parameters.getPassword());
        Assert.assertEquals((long)9000L, (long)parameters.getPort());
        Assert.assertEquals((Object)"tcp://localhost:61616", (Object)parameters.getURL());
        Assert.assertEquals((Object)"admin", (Object)parameters.getUsername());
        Assert.assertTrue((boolean)main.getOrderProcessor().isDoneInvoked());
        String output = this.mOutput.toString();
        Assert.assertTrue((String)output, (boolean)output.contains(Messages.LINE_SUMMARY.getText((Object)25, (Object)5, (Object)5)));
        Assert.assertTrue((String)output, (boolean)output.contains(Messages.ORDER_SUMMARY.getText((Object)4, (Object)10)));
        Assert.assertTrue((String)output, (boolean)output.contains(Messages.LOG_APP_COPYRIGHT.getText()));
        tmpFile.delete();
    }

    @Test
    public void invalidHeader() throws Exception {
        File tmpFile = File.createTempFile("orders", ".csv");
        tmpFile.deleteOnExit();
        CopyCharsUtils.copy((char[])OrderParserTest.arrayToLines("Side,Symbol,Price,OrderType,What?").toCharArray(), (String)tmpFile.getAbsolutePath());
        MockMain main = this.run(tmpFile.getAbsolutePath());
        Assert.assertEquals((long)2L, (long)main.getExitCode());
        String output = this.mOutput.toString();
        Assert.assertTrue((String)output, (boolean)output.contains(Messages.INVALID_CUSTOM_HEADER.getText((Object)"What?", (Object)4)));
    }

    @Test
    public void failConnectServer() throws Exception {
        MockMain main = this.create();
        main.setFailCreateProcessor(true);
        Main.run((String[])new String[]{"don'tmatter"}, (Main)main);
        Assert.assertEquals((long)2L, (long)main.getExitCode());
        String output = this.mOutput.toString();
        Assert.assertTrue((String)output, (boolean)output.contains(TEST_FAILURE));
    }

    private MockMain run(String ... inArgs) {
        MockMain main = this.create();
        Main.run((String[])inArgs, (Main)main);
        return main;
    }

    private MockMain create() {
        MockMain main = new MockMain();
        this.mOutput = new ByteArrayOutputStream();
        main.setMsgStream(new PrintStream(this.mOutput));
        return main;
    }

    public static class MockMain
    extends Main {
        private int mExitCode = -1;
        private boolean mFailCreateProcessor = false;
        private ClientParameters mClientParameters;
        public MockOrderProcessor mOrderProcessor;

        protected void exit(int inCode) {
            this.mExitCode = inCode;
        }

        protected OrderProcessor createProcessor(ClientParameters inParameters) throws Exception {
            if (this.mFailCreateProcessor) {
                throw new IllegalArgumentException(MainTest.TEST_FAILURE);
            }
            this.mClientParameters = inParameters;
            this.mOrderProcessor = new MockOrderProcessor();
            return this.mOrderProcessor;
        }

        public int getExitCode() {
            return this.mExitCode;
        }

        public ClientParameters getClientParameters() {
            return this.mClientParameters;
        }

        public void setFailCreateProcessor(boolean inFailCreateProcessor) {
            this.mFailCreateProcessor = inFailCreateProcessor;
        }

        public MockOrderProcessor getOrderProcessor() {
            return this.mOrderProcessor;
        }
    }
}

