/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.marketdata.marketcetera;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.marketcetera.core.ClassVersion;
import org.marketcetera.core.CoreException;
import org.marketcetera.event.AskEvent;
import org.marketcetera.event.BidEvent;
import org.marketcetera.event.Event;
import org.marketcetera.event.EventTranslator;
import org.marketcetera.event.TradeEvent;
import org.marketcetera.event.UnsupportedEventException;
import org.marketcetera.event.impl.QuoteEventBuilder;
import org.marketcetera.event.impl.TradeEventBuilder;
import org.marketcetera.marketdata.Content;
import org.marketcetera.marketdata.DateUtils;
import org.marketcetera.marketdata.marketcetera.MarketceteraFeed;
import org.marketcetera.marketdata.marketcetera.Messages;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.Instrument;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import quickfix.FieldNotFound;
import quickfix.Group;
import quickfix.fix44.MarketDataSnapshotFullRefresh;

@ClassVersion(value="$Id: MarketceteraFeedEventTranslator.java 16154 2012-07-14 16:34:05Z colin $")
public class MarketceteraFeedEventTranslator
implements EventTranslator,
Messages {
    private static final String UNKNOWN = "?";
    private static final MarketceteraFeedEventTranslator sInstance = new MarketceteraFeedEventTranslator();

    public static MarketceteraFeedEventTranslator getInstance() {
        return sInstance;
    }

    private MarketceteraFeedEventTranslator() {
    }

    public List<Event> toEvent(Object inData, String inHandle) throws CoreException {
        if (!(inData instanceof MarketDataSnapshotFullRefresh)) {
            throw new UnsupportedEventException((I18NBoundMessage)new I18NBoundMessage1P(UNKNOWN_EVENT_TYPE, (Serializable)((Object)ObjectUtils.toString((Object)inData, null))));
        }
        MarketDataSnapshotFullRefresh refresh = (MarketDataSnapshotFullRefresh)inData;
        ArrayList<Event> events = new ArrayList<Event>();
        try {
            int entries = refresh.getInt(268);
            MarketceteraFeed.Request request = MarketceteraFeed.getRequestByHandle(inHandle);
            if (request == null) {
                return events;
            }
            Set requestedContent = request.getRequest().getContent();
            block9: for (int i = 1; i <= entries; ++i) {
                String exchange;
                MarketDataSnapshotFullRefresh.NoMDEntries group = new MarketDataSnapshotFullRefresh.NoMDEntries();
                refresh.getGroup(i, (Group)group);
                String symbol = refresh.getString(55);
                try {
                    exchange = group.getString(275);
                }
                catch (FieldNotFound e) {
                    exchange = UNKNOWN;
                }
                String price = group.getString(270);
                String size = group.getString(271);
                char type = group.getChar(269);
                switch (type) {
                    case '0': {
                        if (!requestedContent.contains(Content.TOP_OF_BOOK)) continue block9;
                        BidEvent bid = (BidEvent)QuoteEventBuilder.equityBidEvent().withMessageId(System.nanoTime()).withTimestamp(new Date()).withQuoteDate(DateUtils.dateToString((Date)new Date())).withInstrument((Instrument)new Equity(symbol)).withExchange(exchange).withPrice(new BigDecimal(price)).withSize(new BigDecimal(size)).create();
                        events.add((Event)bid);
                        continue block9;
                    }
                    case '1': {
                        if (!requestedContent.contains(Content.TOP_OF_BOOK)) continue block9;
                        AskEvent ask = (AskEvent)QuoteEventBuilder.equityAskEvent().withMessageId(System.nanoTime()).withTimestamp(new Date()).withQuoteDate(DateUtils.dateToString((Date)new Date())).withInstrument((Instrument)new Equity(symbol)).withExchange(exchange).withPrice(new BigDecimal(price)).withSize(new BigDecimal(size)).create();
                        events.add((Event)ask);
                        continue block9;
                    }
                    case '2': {
                        if (!requestedContent.contains(Content.LATEST_TICK)) continue block9;
                        TradeEvent trade = (TradeEvent)TradeEventBuilder.equityTradeEvent().withMessageId(System.nanoTime()).withTimestamp(new Date()).withTradeDate(DateUtils.dateToString((Date)new Date())).withInstrument((Instrument)new Equity(symbol)).withExchange(exchange).withPrice(new BigDecimal(price)).withSize(new BigDecimal(size)).create();
                        events.add((Event)trade);
                        continue block9;
                    }
                    default: {
                        throw new UnsupportedEventException((I18NBoundMessage)new I18NBoundMessage1P(UNKNOWN_MESSAGE_ENTRY_TYPE, (Serializable)Character.valueOf(type)));
                    }
                }
            }
        }
        catch (FieldNotFound e) {
            e.printStackTrace();
        }
        return events;
    }

    public Object fromEvent(Event inEvent) throws CoreException {
        throw new UnsupportedOperationException();
    }
}

