/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.marketdata.marketcetera;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Exchanger;
import java.util.concurrent.TimeUnit;
import org.marketcetera.core.ClassVersion;
import org.marketcetera.core.CoreException;
import org.marketcetera.core.IDFactory;
import org.marketcetera.core.InMemoryIDFactory;
import org.marketcetera.core.NoMoreIDsException;
import org.marketcetera.marketdata.AbstractMarketDataFeed;
import org.marketcetera.marketdata.AssetClass;
import org.marketcetera.marketdata.Capability;
import org.marketcetera.marketdata.FIXCorrelationFieldSubscription;
import org.marketcetera.marketdata.FeedException;
import org.marketcetera.marketdata.FeedStatus;
import org.marketcetera.marketdata.IFeedComponent;
import org.marketcetera.marketdata.MarketDataFeedTokenSpec;
import org.marketcetera.marketdata.MarketDataRequest;
import org.marketcetera.marketdata.marketcetera.MarketceteraFeedCredentials;
import org.marketcetera.marketdata.marketcetera.MarketceteraFeedEventTranslator;
import org.marketcetera.marketdata.marketcetera.MarketceteraFeedMessageTranslator;
import org.marketcetera.marketdata.marketcetera.MarketceteraFeedToken;
import org.marketcetera.marketdata.marketcetera.MarketceteraOptionSymbol;
import org.marketcetera.marketdata.marketcetera.Messages;
import org.marketcetera.quickfix.EventLogFactory;
import org.marketcetera.quickfix.FIXMessageUtil;
import org.marketcetera.quickfix.FIXVersion;
import org.marketcetera.trade.Equity;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import quickfix.Application;
import quickfix.CharField;
import quickfix.DoNotSend;
import quickfix.FieldNotFound;
import quickfix.IncorrectDataFormat;
import quickfix.IncorrectTagValue;
import quickfix.IntField;
import quickfix.LogFactory;
import quickfix.MemoryStoreFactory;
import quickfix.Message;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.RejectLogon;
import quickfix.Session;
import quickfix.SessionID;
import quickfix.SessionNotFound;
import quickfix.SessionSettings;
import quickfix.SocketInitiator;
import quickfix.StringField;
import quickfix.UnsupportedMessageType;
import quickfix.field.MarketDepth;
import quickfix.field.NoMDEntryTypes;
import quickfix.field.NoRelatedSym;
import quickfix.field.SubscriptionRequestType;

@ClassVersion(value="$Id: MarketceteraFeed.java 16893 2014-04-25 18:20:56Z colin $")
public class MarketceteraFeed
extends AbstractMarketDataFeed<MarketceteraFeedToken, MarketceteraFeedCredentials, MarketceteraFeedMessageTranslator, MarketceteraFeedEventTranslator, Request, MarketceteraFeed>
implements Application,
Messages {
    private SessionID sessionID;
    private final IDFactory idFactory;
    private boolean isRunning = false;
    private SocketInitiator socketInitiator;
    private quickfix.fix44.MessageFactory messageFactory;
    private final Map<String, Exchanger<Message>> pendingRequests = new WeakHashMap<String, Exchanger<Message>>();
    private MarketceteraFeedCredentials credentials;
    private static final Set<Capability> capabilities = Collections.unmodifiableSet(EnumSet.of(Capability.TOP_OF_BOOK, Capability.LATEST_TICK, Capability.MARKET_STAT));
    private static final Set<AssetClass> assetClasses = Collections.unmodifiableSet(EnumSet.of(AssetClass.EQUITY, AssetClass.OPTION, AssetClass.FUTURE, AssetClass.CURRENCY));
    private static final String UNKNOWN_SYMBOL = "unknown";
    private static MarketceteraFeed sInstance;
    private static final Map<String, Request> requestsByHandle;
    private static final SetMultimap<String, String> handlesBySymbol;

    public Set<Capability> getCapabilities() {
        return capabilities;
    }

    public Set<AssetClass> getSupportedAssetClasses() {
        return assetClasses;
    }

    private FIXCorrelationFieldSubscription doQuery(Message query) {
        try {
            Integer marketDepth = null;
            try {
                marketDepth = query.getInt(264);
            }
            catch (FieldNotFound fnf) {
                // empty catch block
            }
            String reqID = this.addReqID(query);
            this.sendMessage(query);
            return new FIXCorrelationFieldSubscription(reqID, query.getHeader().getString(35), marketDepth);
        }
        catch (SessionNotFound e) {
            SESSION_NOT_FOUND.error((Object)this, (Throwable)e);
        }
        catch (FieldNotFound e) {
            CANNOT_EXECUTE_QUERY.error((Object)this, (Throwable)e, (Object)query);
        }
        return null;
    }

    private String getReqID(Message inMessage) {
        String reqID = null;
        try {
            String msgType = inMessage.getHeader().getString(35);
            StringField reqIDField = FIXMessageUtil.getCorrelationField((FIXVersion)FIXVersion.FIX44, (String)msgType);
            reqID = inMessage.getField(reqIDField).getValue();
        }
        catch (FieldNotFound e) {
            CANNOT_FIND_REQID.error((Object)this, (Throwable)e, (Object)inMessage);
        }
        return reqID;
    }

    private String addReqID(Message query) throws FieldNotFound {
        String reqID = this.getReqID(query);
        String msgType = query.getHeader().getString(35);
        StringField reqIDField = FIXMessageUtil.getCorrelationField((FIXVersion)FIXVersion.FIX44, (String)msgType);
        try {
            query.getField(reqIDField).toString();
        }
        catch (FieldNotFound e1) {
            CANNOT_FIND_REQID.error((Object)this, (Throwable)e1, (Object)query);
        }
        if (reqIDField.getValue() == null || reqIDField.getValue().length() == 0) {
            block5: {
                try {
                    reqID = this.idFactory.getNext();
                }
                catch (NoMoreIDsException e) {
                    CANNOT_ACQUIRE_ID.error((Object)this, (Throwable)e);
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError();
                }
            }
            reqIDField.setValue(reqID);
            query.setField(reqIDField);
        }
        return reqID;
    }

    private void sendMessage(Message message) throws SessionNotFound {
        Session.sendToTarget((Message)message, (SessionID)this.sessionID);
    }

    public Equity symbolFromString(String symbolString) {
        if (MarketceteraOptionSymbol.matchesPattern(symbolString)) {
            return new MarketceteraOptionSymbol(symbolString);
        }
        return new Equity(symbolString);
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    private void setIsRunning(boolean inIsRunning) {
        this.isRunning = inIsRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectToServer() throws Exception {
        SLF4JLoggerProxy.debug((Object)this, (String)"Checking connection to Marketcetera Feed");
        if (this.isRunning()) {
            SLF4JLoggerProxy.debug((Object)this, (String)"Already connected to Marketcetera Feed");
            return;
        }
        if (this.credentials == null) {
            SLF4JLoggerProxy.debug((Object)this, (String)"No credentials to work with, cancelling connection request - try again later");
        }
        SLF4JLoggerProxy.debug((Object)this, (String)"Not connected yet, connecting with credentials [{}]...", (Object[])new Object[]{this.credentials});
        String url = this.credentials.getURL();
        URI feedURI = new URI(url);
        int serverPort = feedURI.getPort();
        if (serverPort < 0) {
            URI_MISSING_PORT.error((Object)"datafeed.status");
            throw new FeedException((I18NBoundMessage)URI_MISSING_PORT);
        }
        String server = feedURI.getHost();
        String senderCompID = this.credentials.getSenderCompID();
        if (senderCompID == null || senderCompID.trim().isEmpty()) {
            senderCompID = this.idFactory.getNext();
        }
        String targetCompID = this.credentials.getTargetCompID();
        String scheme = feedURI.getScheme();
        if (!"FIX.4.4".equals(scheme)) {
            UNSUPPORTED_FIX_VERSION.error((Object)"datafeed.status");
            throw new CoreException((I18NBoundMessage)UNSUPPORTED_FIX_VERSION);
        }
        this.sessionID = new SessionID(scheme, senderCompID, targetCompID);
        MarketceteraFeed marketceteraFeed = this;
        synchronized (marketceteraFeed) {
            try {
                this.setFeedStatus(FeedStatus.OFFLINE);
                CONNECTION_STARTED.info((Object)this, (Object)url);
                MemoryStoreFactory messageStoreFactory = new MemoryStoreFactory();
                SessionSettings sessionSettings = new SessionSettings(MarketceteraFeed.class.getClassLoader().getResourceAsStream("fixdatafeed.properties"));
                sessionSettings.setString(this.sessionID, "SocketConnectHost", server);
                sessionSettings.setLong(this.sessionID, "SocketConnectPort", (long)serverPort);
                File workspaceDir = new File(System.getProperty("java.io.tmpdir"));
                File quoteFeedLogDir = new File(workspaceDir, "marketdata");
                if (!quoteFeedLogDir.exists()) {
                    quoteFeedLogDir.mkdir();
                }
                sessionSettings.setString(this.sessionID, "FileLogPath", quoteFeedLogDir.getCanonicalPath());
                EventLogFactory logFactory = new EventLogFactory(sessionSettings);
                this.messageFactory = new quickfix.fix44.MessageFactory();
                this.socketInitiator = new SocketInitiator((Application)this, (MessageStoreFactory)messageStoreFactory, sessionSettings, (LogFactory)logFactory, (MessageFactory)this.messageFactory);
                this.socketInitiator.start();
                SLF4JLoggerProxy.debug((Object)this, (String)"Connected, waiting for confirmation");
                this.wait(30000L);
                if (!this.getFeedStatus().equals((Object)FeedStatus.AVAILABLE)) {
                    throw new FeedException((I18NBoundMessage)CANNOT_START_FEED);
                }
                this.setIsRunning(true);
                SLF4JLoggerProxy.debug((Object)this, (String)"Connection confirmed, ready to proceed");
            }
            catch (Exception e) {
                SLF4JLoggerProxy.debug((Object)this, (String)"Connection attempt failed!");
                CANNOT_START_FEED.error((Object)"datafeed.status", (Throwable)e);
                this.setFeedStatus(FeedStatus.ERROR);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        MarketceteraFeed marketceteraFeed = this;
        synchronized (marketceteraFeed) {
            if (this.isRunning()) {
                CONNECTION_STOPPED.info((Object)this, (Object)this.credentials.getURL());
                this.socketInitiator.stop(true);
                this.setIsRunning(false);
                super.stop();
            }
        }
    }

    public void fromAdmin(Message message, SessionID sessionID) throws FieldNotFound, IncorrectDataFormat, IncorrectTagValue, RejectLogon {
        Message.Header header = message.getHeader();
        String msgType = header.getString(35);
        if ("A".equals(msgType)) {
            this.setFeedStatus(FeedStatus.AVAILABLE);
            SLF4JLoggerProxy.debug((Object)this, (String)"Marketcetera feed received Logon");
        } else if ("5".equals(msgType)) {
            SLF4JLoggerProxy.debug((Object)this, (String)"Marketcetera feed received Logout");
        } else if (!"0".equals(msgType)) {
            SLF4JLoggerProxy.debug((Object)this, (String)"Admin message for Marketcetera feed: {}", (Object[])new Object[]{message});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromApp(Message message, SessionID sessionID) throws FieldNotFound, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType {
        String reqID = null;
        boolean handled = false;
        try {
            StringField correlationField = FIXMessageUtil.getCorrelationField((FIXVersion)FIXVersion.FIX44, (String)message.getHeader().getString(35));
            reqID = message.getString(correlationField.getTag());
        }
        catch (FieldNotFound fnf) {
            // empty catch block
        }
        if (reqID != null && reqID.length() > 0) {
            Map<String, Exchanger<Message>> map = this.pendingRequests;
            synchronized (map) {
                for (String requestID : this.pendingRequests.keySet()) {
                    if (!requestID.equals(reqID)) continue;
                    try {
                        this.pendingRequests.get(requestID).exchange(message, 1L, TimeUnit.NANOSECONDS);
                        handled = true;
                    }
                    catch (Exception e) {
                        EXCHANGE_ERROR.error((Object)this, (Throwable)e);
                    }
                    break;
                }
                this.pendingRequests.remove(reqID);
            }
        }
        if (!handled) {
            this.fireMarketDataMessage(message);
        }
    }

    public void onCreate(SessionID sessionID) {
        SLF4JLoggerProxy.debug((Object)this, (String)"Marketcetera feed session created {}", (Object[])new Object[]{sessionID});
    }

    public void onLogon(SessionID sessionID) {
        this.setFeedStatus(FeedStatus.AVAILABLE);
    }

    public void onLogout(SessionID sessionID) {
        this.setFeedStatus(FeedStatus.OFFLINE);
    }

    public void toAdmin(Message message, SessionID sessionID) {
    }

    public void toApp(Message message, SessionID sessionID) throws DoNotSend {
    }

    private void fireMarketDataMessage(Message refresh) {
        String symbol;
        try {
            symbol = refresh.getString(55);
        }
        catch (FieldNotFound e) {
            symbol = UNKNOWN_SYMBOL;
        }
        Set<String> handles = MarketceteraFeed.getHandlesForSymbol(symbol);
        SLF4JLoggerProxy.debug((Object)this, (String)"MarketceteraFeed received response for handle(s): {}", (Object[])new Object[]{handles});
        for (String handle : handles) {
            this.dataReceived(handle, refresh);
        }
    }

    private MarketceteraFeed(String inProviderName) throws URISyntaxException, CoreException {
        super(IFeedComponent.FeedType.UNKNOWN, inProviderName);
        try {
            this.idFactory = new InMemoryIDFactory(System.currentTimeMillis(), String.format("-%s-", InetAddress.getLocalHost().toString()));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static MarketceteraFeed getInstance(String inProviderName) throws URISyntaxException, CoreException {
        if (sInstance != null) {
            return sInstance;
        }
        sInstance = new MarketceteraFeed(inProviderName);
        return sInstance;
    }

    protected void doCancel(String inHandle) {
        SLF4JLoggerProxy.debug((Object)this, (String)"Marketcetera feed canceling subscriptions for handle {}", (Object[])new Object[]{inHandle});
        Request request = this.removeRequest(inHandle);
        FIXCorrelationFieldSubscription subscription = request.getSubscription();
        Message message = this.messageFactory.create("", subscription.getSubscribeMsgType());
        StringField correlationID = FIXMessageUtil.getCorrelationField((FIXVersion)FIXVersion.FIX44, (String)subscription.getSubscribeMsgType());
        correlationID.setValue(subscription.toString());
        SLF4JLoggerProxy.debug((Object)this, (String)"Marketcetera feed sending cancel request for {}", (Object[])new Object[]{correlationID});
        message.setField(correlationID);
        message.setField((CharField)new SubscriptionRequestType('2'));
        message.setField((IntField)new NoRelatedSym(0));
        message.setField((IntField)new NoMDEntryTypes(0));
        if (subscription.getMarketDepth() != null) {
            message.setField((IntField)new MarketDepth(subscription.getMarketDepth().intValue()));
        }
        try {
            this.sendMessage(message);
        }
        catch (SessionNotFound e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected boolean doLogin(MarketceteraFeedCredentials inCredentials) {
        this.credentials = inCredentials;
        try {
            this.connectToServer();
        }
        catch (Exception e) {
            SLF4JLoggerProxy.error((Object)this, (Throwable)e);
            return false;
        }
        return true;
    }

    protected void doLogout() {
        this.stop();
    }

    private static synchronized void addRequest(Request inRequest) {
        requestsByHandle.put(inRequest.getIdAsString(), inRequest);
        for (String symbol : inRequest.getRequest().getSymbols()) {
            handlesBySymbol.put((Object)symbol, (Object)inRequest.getIdAsString());
        }
    }

    private static synchronized Set<String> getHandlesForSymbol(String inSymbol) {
        Set handles = handlesBySymbol.get((Object)inSymbol);
        if (handles != null) {
            return handles;
        }
        return Collections.emptySet();
    }

    static synchronized Request getRequestByHandle(String inHandle) {
        return requestsByHandle.get(inHandle);
    }

    private synchronized Request removeRequest(String inHandle) {
        Request request = requestsByHandle.remove(inHandle);
        for (String symbol : request.getRequest().getSymbols()) {
            Set handles = handlesBySymbol.get((Object)symbol);
            handles.remove(inHandle);
        }
        return request;
    }

    protected MarketceteraFeedToken generateToken(MarketDataFeedTokenSpec inTokenSpec) throws FeedException {
        return MarketceteraFeedToken.getToken(inTokenSpec, this);
    }

    protected MarketceteraFeedEventTranslator getEventTranslator() {
        return MarketceteraFeedEventTranslator.getInstance();
    }

    protected MarketceteraFeedMessageTranslator getMessageTranslator() {
        return MarketceteraFeedMessageTranslator.getInstance();
    }

    protected boolean isLoggedIn() {
        return this.isRunning();
    }

    protected List<String> doMarketDataRequest(Request inData) throws FeedException {
        try {
            inData.setSubscription(this.doQuery(inData.getMessage()));
            MarketceteraFeed.addRequest(inData);
            SLF4JLoggerProxy.debug((Object)this, (String)"MarketceteraFeed posted query for {} and associated the request with handle {}", (Object[])new Object[]{inData.getRequest().getSymbols(), inData.getIdAsString()});
            return Arrays.asList(inData.getIdAsString());
        }
        catch (Exception e) {
            throw new FeedException((Throwable)e);
        }
    }

    static {
        requestsByHandle = new HashMap<String, Request>();
        handlesBySymbol = HashMultimap.create();
    }

    @ClassVersion(value="$Id: MarketceteraFeed.java 16893 2014-04-25 18:20:56Z colin $")
    static final class Request {
        private final Message message;
        private final MarketDataRequest request;
        private final long id;
        private FIXCorrelationFieldSubscription subscription;

        Request(long inId, Message inMessage, MarketDataRequest inRequest) {
            this.id = inId;
            this.message = inMessage;
            this.request = inRequest;
        }

        long getId() {
            return this.id;
        }

        String getIdAsString() {
            return Long.toHexString(this.getId());
        }

        Message getMessage() {
            return this.message;
        }

        MarketDataRequest getRequest() {
            return this.request;
        }

        FIXCorrelationFieldSubscription getSubscription() {
            return this.subscription;
        }

        private void setSubscription(FIXCorrelationFieldSubscription inSubscription) {
            this.subscription = inSubscription;
        }
    }
}

