/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.dataflow.server.rpc;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.marketcetera.core.PlatformServices;
import org.marketcetera.dataflow.client.DataBroadcaster;
import org.marketcetera.dataflow.client.DataReceiver;
import org.marketcetera.dataflow.rpc.DataFlowRpc;
import org.marketcetera.dataflow.rpc.DataFlowRpcServiceGrpc;
import org.marketcetera.dataflow.rpc.DataFlowRpcUtil;
import org.marketcetera.dataflow.service.DataFlowService;
import org.marketcetera.module.DataFlowID;
import org.marketcetera.module.DataFlowInfo;
import org.marketcetera.module.DataRequest;
import org.marketcetera.module.ModuleInfo;
import org.marketcetera.module.ModuleManager;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.persist.CollectionPageResponse;
import org.marketcetera.persist.PageRequest;
import org.marketcetera.persist.PageResponse;
import org.marketcetera.rpc.base.BaseRpc;
import org.marketcetera.rpc.base.BaseRpcUtil;
import org.marketcetera.rpc.paging.PagingRpc;
import org.marketcetera.rpc.paging.PagingRpcUtil;
import org.marketcetera.rpc.server.AbstractRpcService;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.ws.stateful.SessionHolder;
import org.springframework.beans.factory.annotation.Autowired;

public class DataFlowRpcService<SessionClazz>
extends AbstractRpcService<SessionClazz, DataFlowRpcServiceGrpc.DataFlowRpcServiceImplBase> {
    @Autowired(required=false)
    private Collection<DataBroadcaster> dataBroadcasters = Lists.newArrayList();
    @Autowired
    private DataFlowService dataFlowService;
    @Autowired
    private ModuleManager moduleManager;
    private Service service;
    private static final String description = "Data Flow RPC Service";
    private final Cache<String, BaseRpcUtil.AbstractServerListenerProxy<?>> receiverProxiesById = CacheBuilder.newBuilder().build();

    public void start() throws Exception {
        this.service = new Service();
        super.start();
    }

    protected String getServiceDescription() {
        return description;
    }

    protected DataFlowRpcServiceGrpc.DataFlowRpcServiceImplBase getService() {
        return this.service;
    }

    private static class DataReceiverListenerProxy
    extends BaseRpcUtil.AbstractServerListenerProxy<DataFlowRpc.DataReceiverResponse>
    implements DataReceiver {
        private final DataFlowRpc.DataReceiverResponse.Builder responseBuilder = DataFlowRpc.DataReceiverResponse.newBuilder();

        public void receiveData(Object inObject) {
            DataFlowRpcUtil.setData((Object)inObject, (DataFlowRpc.DataReceiverResponse.Builder)this.responseBuilder);
            DataFlowRpc.DataReceiverResponse response = this.responseBuilder.build();
            SLF4JLoggerProxy.trace(DataFlowRpcService.class, (String)"{} received data flow object {}, sending {}", (Object[])new Object[]{this.getId(), inObject, response});
            this.getObserver().onNext((Object)response);
            this.responseBuilder.clear();
        }

        private DataReceiverListenerProxy(String inId, StreamObserver<DataFlowRpc.DataReceiverResponse> inObserver) {
            super(inId, inObserver);
        }
    }

    private class Service
    extends DataFlowRpcServiceGrpc.DataFlowRpcServiceImplBase {
        private Service() {
        }

        public void login(BaseRpc.LoginRequest inRequest, StreamObserver<BaseRpc.LoginResponse> inResponseObserver) {
            DataFlowRpcService.this.doLogin(inRequest, inResponseObserver);
        }

        public void logout(BaseRpc.LogoutRequest inRequest, StreamObserver<BaseRpc.LogoutResponse> inResponseObserver) {
            DataFlowRpcService.this.doLogout(inRequest, inResponseObserver);
        }

        public void heartbeat(BaseRpc.HeartbeatRequest inRequest, StreamObserver<BaseRpc.HeartbeatResponse> inResponseObserver) {
            DataFlowRpcService.this.doHeartbeat(inRequest, inResponseObserver);
        }

        public void getProviders(DataFlowRpc.ProvidersRequest inRequest, StreamObserver<DataFlowRpc.ProvidersResponse> inResponseObserver) {
            try {
                DataFlowRpcService.this.validateAndReturnSession(inRequest.getSessionId());
                SLF4JLoggerProxy.trace((Object)((Object)DataFlowRpcService.this), (String)"{} received getProviders request", (Object[])new Object[]{DataFlowRpcService.this.getServiceDescription()});
                List providers = DataFlowRpcService.this.moduleManager.getProviders();
                DataFlowRpc.ProvidersResponse.Builder responseBuilder = DataFlowRpc.ProvidersResponse.newBuilder();
                if (providers != null) {
                    for (ModuleURN provider : providers) {
                        responseBuilder.addProvider(DataFlowRpc.ModuleURN.newBuilder().setValue(provider.getValue()).build());
                    }
                }
                DataFlowRpc.ProvidersResponse response = responseBuilder.build();
                SLF4JLoggerProxy.debug((Object)((Object)this), (String)"{} returning {}", (Object[])new Object[]{DataFlowRpcService.this.getServiceDescription(), providers});
                inResponseObserver.onNext((Object)response);
                inResponseObserver.onCompleted();
            }
            catch (Exception e) {
                if (e instanceof StatusRuntimeException) {
                    throw (StatusRuntimeException)e;
                }
                throw new StatusRuntimeException(Status.INVALID_ARGUMENT.withCause((Throwable)e).withDescription(ExceptionUtils.getRootCauseMessage((Throwable)e)));
            }
        }

        public void getInstances(DataFlowRpc.InstancesRequest inRequest, StreamObserver<DataFlowRpc.InstancesResponse> inResponseObserver) {
            try {
                DataFlowRpcService.this.validateAndReturnSession(inRequest.getSessionId());
                ModuleURN provider = null;
                if (inRequest.hasProvider()) {
                    provider = DataFlowRpcUtil.getModuleUrn((DataFlowRpc.ModuleURN)inRequest.getProvider());
                }
                SLF4JLoggerProxy.trace((Object)((Object)DataFlowRpcService.this), (String)"{} received get instances request {}", (Object[])new Object[]{DataFlowRpcService.this.getServiceDescription(), inRequest});
                List instances = DataFlowRpcService.this.moduleManager.getModuleInstances(provider);
                DataFlowRpc.InstancesResponse.Builder responseBuilder = DataFlowRpc.InstancesResponse.newBuilder();
                if (instances != null) {
                    for (ModuleURN instance : instances) {
                        responseBuilder.addInstance(DataFlowRpcUtil.getRpcModuleUrn((ModuleURN)instance));
                    }
                }
                DataFlowRpc.InstancesResponse response = responseBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)DataFlowRpcService.this), (String)"{} returning {}", (Object[])new Object[]{DataFlowRpcService.this.getServiceDescription(), response});
                inResponseObserver.onNext((Object)response);
                inResponseObserver.onCompleted();
            }
            catch (Exception e) {
                if (e instanceof StatusRuntimeException) {
                    throw (StatusRuntimeException)e;
                }
                throw new StatusRuntimeException(Status.INVALID_ARGUMENT.withCause((Throwable)e).withDescription(ExceptionUtils.getRootCauseMessage((Throwable)e)));
            }
        }

        public void getModuleInfo(DataFlowRpc.ModuleInfoRequest inRequest, StreamObserver<DataFlowRpc.ModuleInfoResponse> inResponseObserver) {
            try {
                DataFlowRpcService.this.validateAndReturnSession(inRequest.getSessionId());
                SLF4JLoggerProxy.trace((Object)((Object)DataFlowRpcService.this), (String)"{} received get module info request {}", (Object[])new Object[]{DataFlowRpcService.this.getServiceDescription(), inRequest});
                ModuleURN instance = DataFlowRpcUtil.getModuleUrn((DataFlowRpc.ModuleURN)inRequest.getInstance());
                ModuleInfo info = DataFlowRpcService.this.moduleManager.getModuleInfo(instance);
                DataFlowRpc.ModuleInfoResponse.Builder responseBuilder = DataFlowRpc.ModuleInfoResponse.newBuilder();
                if (info != null) {
                    responseBuilder.setInfo(DataFlowRpcUtil.getRpcModuleInfo((ModuleInfo)info));
                }
                DataFlowRpc.ModuleInfoResponse response = responseBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)DataFlowRpcService.this), (String)"{} returning {}", (Object[])new Object[]{DataFlowRpcService.this.getServiceDescription(), response});
                inResponseObserver.onNext((Object)response);
                inResponseObserver.onCompleted();
            }
            catch (Exception e) {
                if (e instanceof StatusRuntimeException) {
                    throw (StatusRuntimeException)e;
                }
                throw new StatusRuntimeException(Status.INVALID_ARGUMENT.withCause((Throwable)e).withDescription(ExceptionUtils.getRootCauseMessage((Throwable)e)));
            }
        }

        public void startModule(DataFlowRpc.StartModuleRequest inRequest, StreamObserver<DataFlowRpc.StartModuleResponse> inResponseObserver) {
            try {
                DataFlowRpcService.this.validateAndReturnSession(inRequest.getSessionId());
                ModuleURN instance = new ModuleURN(inRequest.getInstance().getValue());
                SLF4JLoggerProxy.trace((Object)((Object)DataFlowRpcService.this), (String)"{} received start module request  {}", (Object[])new Object[]{DataFlowRpcService.this.getServiceDescription(), inRequest});
                DataFlowRpc.StartModuleResponse.Builder responseBuilder = DataFlowRpc.StartModuleResponse.newBuilder();
                DataFlowRpcService.this.moduleManager.start(instance);
                DataFlowRpc.StartModuleResponse response = responseBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)DataFlowRpcService.this), (String)"{} returning {}", (Object[])new Object[]{DataFlowRpcService.this.getServiceDescription(), response});
                inResponseObserver.onNext((Object)response);
                inResponseObserver.onCompleted();
            }
            catch (Exception e) {
                SLF4JLoggerProxy.warn((Object)((Object)DataFlowRpcService.this), (Throwable)e);
                throw new StatusRuntimeException(Status.INVALID_ARGUMENT.withCause((Throwable)e).withDescription(ExceptionUtils.getRootCauseMessage((Throwable)e)));
            }
        }

        public void stopModule(DataFlowRpc.StopModuleRequest inRequest, StreamObserver<DataFlowRpc.StopModuleResponse> inResponseObserver) {
            try {
                DataFlowRpcService.this.validateAndReturnSession(inRequest.getSessionId());
                ModuleURN instance = new ModuleURN(inRequest.getInstance().getValue());
                SLF4JLoggerProxy.trace((Object)((Object)DataFlowRpcService.this), (String)"{} received stop module request {}", (Object[])new Object[]{DataFlowRpcService.this.getServiceDescription(), inRequest});
                DataFlowRpc.StopModuleResponse.Builder responseBuilder = DataFlowRpc.StopModuleResponse.newBuilder();
                DataFlowRpcService.this.moduleManager.stop(instance);
                DataFlowRpc.StopModuleResponse response = responseBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)DataFlowRpcService.this), (String)"{} returning {}", (Object[])new Object[]{DataFlowRpcService.this.getServiceDescription(), response});
                inResponseObserver.onNext((Object)response);
                inResponseObserver.onCompleted();
            }
            catch (Exception e) {
                if (e instanceof StatusRuntimeException) {
                    throw (StatusRuntimeException)e;
                }
                throw new StatusRuntimeException(Status.INVALID_ARGUMENT.withCause((Throwable)e).withDescription(ExceptionUtils.getRootCauseMessage((Throwable)e)));
            }
        }

        public void deleteModule(DataFlowRpc.DeleteModuleRequest inRequest, StreamObserver<DataFlowRpc.DeleteModuleResponse> inResponseObserver) {
            try {
                DataFlowRpcService.this.validateAndReturnSession(inRequest.getSessionId());
                ModuleURN instance = new ModuleURN(inRequest.getInstance().getValue());
                SLF4JLoggerProxy.trace((Object)((Object)DataFlowRpcService.this), (String)"{} received delete module request {}", (Object[])new Object[]{DataFlowRpcService.this.getServiceDescription(), inRequest});
                DataFlowRpc.DeleteModuleResponse.Builder responseBuilder = DataFlowRpc.DeleteModuleResponse.newBuilder();
                DataFlowRpcService.this.moduleManager.deleteModule(instance);
                DataFlowRpc.DeleteModuleResponse response = responseBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)DataFlowRpcService.this), (String)"{} returning {}", (Object[])new Object[]{DataFlowRpcService.this.getServiceDescription(), response});
                inResponseObserver.onNext((Object)response);
                inResponseObserver.onCompleted();
            }
            catch (Exception e) {
                if (e instanceof StatusRuntimeException) {
                    throw (StatusRuntimeException)e;
                }
                throw new StatusRuntimeException(Status.INVALID_ARGUMENT.withCause((Throwable)e).withDescription(ExceptionUtils.getRootCauseMessage((Throwable)e)));
            }
        }

        public void sendData(DataFlowRpc.SendDataRequest inRequest, StreamObserver<DataFlowRpc.SendDataResponse> inResponseObserver) {
            try {
                DataFlowRpcService.this.validateAndReturnSession(inRequest.getSessionId());
                SLF4JLoggerProxy.trace((Object)((Object)DataFlowRpcService.this), (String)"{} received send data request {}", (Object[])new Object[]{DataFlowRpcService.this.getServiceDescription(), inRequest});
                Object data = DataFlowRpcUtil.getParameter((String)inRequest.getPayload());
                SLF4JLoggerProxy.trace((Object)((Object)DataFlowRpcService.this), (String)"{} sending {}", (Object[])new Object[]{DataFlowRpcService.this.getServiceDescription(), data});
                DataFlowRpc.SendDataResponse.Builder responseBuilder = DataFlowRpc.SendDataResponse.newBuilder();
                for (DataBroadcaster dataBroadcaster : DataFlowRpcService.this.dataBroadcasters) {
                    try {
                        dataBroadcaster.receiveData(data);
                    }
                    catch (Exception e) {
                        PlatformServices.handleException((Object)((Object)DataFlowRpcService.this), (String)("Error broadcasting " + data), (Throwable)e);
                    }
                }
                DataFlowRpc.SendDataResponse response = responseBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)DataFlowRpcService.this), (String)"{} returning from sendData call", (Object[])new Object[]{DataFlowRpcService.this.getServiceDescription()});
                inResponseObserver.onNext((Object)response);
                inResponseObserver.onCompleted();
            }
            catch (Exception e) {
                if (e instanceof StatusRuntimeException) {
                    throw (StatusRuntimeException)e;
                }
                throw new StatusRuntimeException(Status.INVALID_ARGUMENT.withCause((Throwable)e).withDescription(ExceptionUtils.getRootCauseMessage((Throwable)e)));
            }
        }

        public void createModule(DataFlowRpc.CreateModuleRequest inRequest, StreamObserver<DataFlowRpc.CreateModuleResponse> inResponseObserver) {
            try {
                DataFlowRpcService.this.validateAndReturnSession(inRequest.getSessionId());
                SLF4JLoggerProxy.trace((Object)((Object)DataFlowRpcService.this), (String)"{} received create module request {}", (Object[])new Object[]{DataFlowRpcService.this.getServiceDescription(), inRequest});
                ModuleURN provider = DataFlowRpcUtil.getModuleUrn((DataFlowRpc.ModuleURN)inRequest.getProvider());
                ArrayList parameters = null;
                for (String param : inRequest.getParametersList()) {
                    if (parameters == null) {
                        parameters = Lists.newArrayList();
                    }
                    parameters.add(DataFlowRpcUtil.getParameter((String)param));
                }
                ModuleURN instance = parameters == null ? DataFlowRpcService.this.moduleManager.createModule(provider, new Object[0]) : DataFlowRpcService.this.moduleManager.createModule(provider, parameters.toArray(new Object[parameters.size()]));
                DataFlowRpc.CreateModuleResponse.Builder responseBuilder = DataFlowRpc.CreateModuleResponse.newBuilder();
                responseBuilder.setInstance(DataFlowRpcUtil.getRpcModuleUrn((ModuleURN)instance));
                DataFlowRpc.CreateModuleResponse response = responseBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)DataFlowRpcService.this), (String)"{} returning {}", (Object[])new Object[]{DataFlowRpcService.this.getServiceDescription(), response});
                inResponseObserver.onNext((Object)response);
                inResponseObserver.onCompleted();
            }
            catch (Exception e) {
                SLF4JLoggerProxy.warn((Object)((Object)DataFlowRpcService.this), (Throwable)e);
                inResponseObserver.onError((Throwable)e);
            }
        }

        public void createDataFlow(DataFlowRpc.CreateDataFlowRequest inRequest, StreamObserver<DataFlowRpc.CreateDataFlowResponse> inResponseObserver) {
            try {
                SessionHolder sessionHolder = DataFlowRpcService.this.validateAndReturnSession(inRequest.getSessionId());
                SLF4JLoggerProxy.trace((Object)((Object)DataFlowRpcService.this), (String)"{} received create data flow request {}", (Object[])new Object[]{sessionHolder, inRequest});
                ArrayList dataRequestBuilder = Lists.newArrayList();
                for (DataFlowRpc.DataRequest rpcDataRequest : inRequest.getDataRequestsList()) {
                    DataRequest dataRequest = DataFlowRpcUtil.getDataRequest((DataFlowRpc.DataRequest)rpcDataRequest);
                    SLF4JLoggerProxy.trace((Object)((Object)DataFlowRpcService.this), (String)"{} adding data request {}", (Object[])new Object[]{sessionHolder, dataRequest.getRequestURN()});
                    dataRequestBuilder.add(dataRequest);
                }
                boolean appendToSink = inRequest.getAppendDataSink();
                SLF4JLoggerProxy.trace((Object)((Object)DataFlowRpcService.this), (String)"{} issuing data request {}", (Object[])new Object[]{sessionHolder, dataRequestBuilder});
                DataFlowID dataFlowId = DataFlowRpcService.this.moduleManager.createDataFlow(dataRequestBuilder.toArray(new DataRequest[dataRequestBuilder.size()]), appendToSink);
                DataFlowRpc.CreateDataFlowResponse.Builder responseBuilder = DataFlowRpc.CreateDataFlowResponse.newBuilder();
                responseBuilder.setDataFlowId(DataFlowRpcUtil.getRpcDataFlowId((DataFlowID)dataFlowId));
                DataFlowRpc.CreateDataFlowResponse response = responseBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)DataFlowRpcService.this), (String)"{} returning {}", (Object[])new Object[]{sessionHolder, response});
                inResponseObserver.onNext((Object)response);
                inResponseObserver.onCompleted();
            }
            catch (Exception e) {
                SLF4JLoggerProxy.warn((Object)((Object)DataFlowRpcService.this), (Throwable)e);
                inResponseObserver.onError((Throwable)e);
            }
        }

        public void cancelDataFlow(DataFlowRpc.CancelDataFlowRequest inRequest, StreamObserver<DataFlowRpc.CancelDataFlowResponse> inResponseObserver) {
            try {
                DataFlowRpcService.this.validateAndReturnSession(inRequest.getSessionId());
                SLF4JLoggerProxy.trace((Object)((Object)DataFlowRpcService.this), (String)"{} received cancel data flow request {}", (Object[])new Object[]{DataFlowRpcService.this.getServiceDescription(), inRequest});
                DataFlowID dataFlowId = DataFlowRpcUtil.getDataFlowId((String)inRequest.getDataFlowId());
                DataFlowRpc.CancelDataFlowResponse.Builder responseBuilder = DataFlowRpc.CancelDataFlowResponse.newBuilder();
                DataFlowRpcService.this.moduleManager.cancel(dataFlowId);
                DataFlowRpc.CancelDataFlowResponse response = responseBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)DataFlowRpcService.this), (String)"{} returning {}", (Object[])new Object[]{DataFlowRpcService.this.getServiceDescription(), response});
                inResponseObserver.onNext((Object)response);
                inResponseObserver.onCompleted();
            }
            catch (Exception e) {
                if (e instanceof StatusRuntimeException) {
                    throw (StatusRuntimeException)e;
                }
                throw new StatusRuntimeException(Status.INVALID_ARGUMENT.withCause((Throwable)e).withDescription(ExceptionUtils.getRootCauseMessage((Throwable)e)));
            }
        }

        public void getDataFlowInfo(DataFlowRpc.GetDataFlowInfoRequest inRequest, StreamObserver<DataFlowRpc.GetDataFlowInfoResponse> inResponseObserver) {
            try {
                SessionHolder sessionHolder = DataFlowRpcService.this.validateAndReturnSession(inRequest.getSessionId());
                SLF4JLoggerProxy.trace((Object)((Object)DataFlowRpcService.this), (String)"{} received get data flow info request {}", (Object[])new Object[]{sessionHolder, inRequest});
                DataFlowID dataFlowId = DataFlowRpcUtil.getDataFlowId((String)inRequest.getDataFlowId());
                DataFlowInfo dataFlowInfo = DataFlowRpcService.this.moduleManager.getDataFlowInfo(dataFlowId);
                DataFlowRpc.GetDataFlowInfoResponse.Builder responseBuilder = DataFlowRpc.GetDataFlowInfoResponse.newBuilder();
                responseBuilder.setDataFlowInfo(DataFlowRpcUtil.getRpcDataFlowInfo((DataFlowInfo)dataFlowInfo));
                DataFlowRpc.GetDataFlowInfoResponse response = responseBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)DataFlowRpcService.this), (String)"{} returning {}", (Object[])new Object[]{sessionHolder, response});
                inResponseObserver.onNext((Object)response);
                inResponseObserver.onCompleted();
            }
            catch (Exception e) {
                SLF4JLoggerProxy.warn((Object)((Object)DataFlowRpcService.this), (Throwable)e);
                inResponseObserver.onError((Throwable)e);
            }
        }

        public void getDataFlows(DataFlowRpc.GetDataFlowsRequest inRequest, StreamObserver<DataFlowRpc.GetDataFlowsResponse> inResponseObserver) {
            try {
                SessionHolder sessionHolder = DataFlowRpcService.this.validateAndReturnSession(inRequest.getSessionId());
                SLF4JLoggerProxy.trace((Object)((Object)DataFlowRpcService.this), (String)"{} received get data flows request {}", (Object[])new Object[]{sessionHolder, inRequest});
                PageRequest pageRequest = inRequest.hasPageRequest() ? PagingRpcUtil.getPageRequest((PagingRpc.PageRequest)inRequest.getPageRequest()) : PageRequest.ALL;
                List dataFlows = DataFlowRpcService.this.moduleManager.getDataFlows(true);
                List dataFlowsPage = PageResponse.getPage((List)dataFlows, (int)(pageRequest.getPageNumber() + 1), (int)pageRequest.getPageSize());
                DataFlowRpc.GetDataFlowsResponse.Builder responseBuilder = DataFlowRpc.GetDataFlowsResponse.newBuilder();
                dataFlowsPage.forEach(value -> responseBuilder.addDataFlowIds(DataFlowRpcUtil.getRpcDataFlowId((DataFlowID)value)));
                CollectionPageResponse fauxPage = new CollectionPageResponse();
                fauxPage.setElements((Collection)dataFlowsPage);
                fauxPage.setHasContent(!dataFlowsPage.isEmpty());
                fauxPage.setPageMaxSize(pageRequest.getPageSize());
                fauxPage.setPageNumber(pageRequest.getPageNumber());
                fauxPage.setPageSize(Math.min(pageRequest.getPageSize(), dataFlowsPage.size()));
                fauxPage.setSortOrder(pageRequest.getSortOrder());
                int totalSize = dataFlows.size();
                fauxPage.setTotalPages(PageResponse.getNumberOfPages((PageRequest)pageRequest, (int)totalSize));
                fauxPage.setTotalSize((long)totalSize);
                responseBuilder.setPageResponse(PagingRpcUtil.getPageResponse((PageRequest)pageRequest, (PageResponse)fauxPage));
                DataFlowRpc.GetDataFlowsResponse response = responseBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)DataFlowRpcService.this), (String)"{} returning {}", (Object[])new Object[]{sessionHolder, response});
                inResponseObserver.onNext((Object)response);
                inResponseObserver.onCompleted();
            }
            catch (Exception e) {
                SLF4JLoggerProxy.warn((Object)((Object)DataFlowRpcService.this), (Throwable)e);
                inResponseObserver.onError((Throwable)e);
            }
        }

        public void getDataFlowHistory(DataFlowRpc.GetDataFlowHistoryRequest inRequest, StreamObserver<DataFlowRpc.GetDataFlowHistoryResponse> inResponseObserver) {
            try {
                SessionHolder sessionHolder = DataFlowRpcService.this.validateAndReturnSession(inRequest.getSessionId());
                SLF4JLoggerProxy.trace((Object)((Object)DataFlowRpcService.this), (String)"{} received get data flow history request {}", (Object[])new Object[]{sessionHolder, inRequest});
                PageRequest pageRequest = inRequest.hasPageRequest() ? PagingRpcUtil.getPageRequest((PagingRpc.PageRequest)inRequest.getPageRequest()) : PageRequest.ALL;
                List dataFlowHistory = DataFlowRpcService.this.moduleManager.getDataFlowHistory();
                List dataFlowHistoryPage = PageResponse.getPage((List)dataFlowHistory, (int)(pageRequest.getPageNumber() + 1), (int)pageRequest.getPageSize());
                DataFlowRpc.GetDataFlowHistoryResponse.Builder responseBuilder = DataFlowRpc.GetDataFlowHistoryResponse.newBuilder();
                dataFlowHistoryPage.forEach(value -> responseBuilder.addDataFlowInfos(DataFlowRpcUtil.getRpcDataFlowInfo((DataFlowInfo)value)));
                CollectionPageResponse fauxPage = new CollectionPageResponse();
                fauxPage.setElements((Collection)dataFlowHistoryPage);
                fauxPage.setHasContent(!dataFlowHistoryPage.isEmpty());
                fauxPage.setPageMaxSize(pageRequest.getPageSize());
                fauxPage.setPageNumber(pageRequest.getPageNumber());
                fauxPage.setPageSize(Math.min(pageRequest.getPageSize(), dataFlowHistoryPage.size()));
                fauxPage.setSortOrder(pageRequest.getSortOrder());
                int totalSize = dataFlowHistory.size();
                fauxPage.setTotalPages(PageResponse.getNumberOfPages((PageRequest)pageRequest, (int)totalSize));
                fauxPage.setTotalSize((long)totalSize);
                DataFlowRpc.GetDataFlowHistoryResponse response = responseBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)DataFlowRpcService.this), (String)"{} returning {}", (Object[])new Object[]{sessionHolder, response});
                inResponseObserver.onNext((Object)response);
                inResponseObserver.onCompleted();
            }
            catch (Exception e) {
                SLF4JLoggerProxy.warn((Object)((Object)DataFlowRpcService.this), (Throwable)e);
                inResponseObserver.onError((Throwable)e);
            }
        }

        public void addDataReceiver(DataFlowRpc.AddDataReceiverRequest inRequest, StreamObserver<DataFlowRpc.DataReceiverResponse> inResponseObserver) {
            try {
                DataFlowRpcService.this.validateAndReturnSession(inRequest.getSessionId());
                SLF4JLoggerProxy.trace((Object)((Object)DataFlowRpcService.this), (String)"Received add data receiver request {}", (Object[])new Object[]{inRequest});
                String listenerId = inRequest.getListenerId();
                BaseRpcUtil.AbstractServerListenerProxy dataReceiverProxy = (BaseRpcUtil.AbstractServerListenerProxy)DataFlowRpcService.this.receiverProxiesById.getIfPresent((Object)listenerId);
                if (dataReceiverProxy == null) {
                    dataReceiverProxy = new DataReceiverListenerProxy(listenerId, inResponseObserver);
                    DataFlowRpcService.this.receiverProxiesById.put((Object)dataReceiverProxy.getId(), (Object)dataReceiverProxy);
                    DataFlowRpcService.this.dataFlowService.addDataReceiver((DataReceiver)dataReceiverProxy);
                }
            }
            catch (Exception e) {
                if (e instanceof StatusRuntimeException) {
                    throw (StatusRuntimeException)e;
                }
                throw new StatusRuntimeException(Status.INVALID_ARGUMENT.withCause((Throwable)e).withDescription(ExceptionUtils.getRootCauseMessage((Throwable)e)));
            }
        }

        public void removeDataReceiver(DataFlowRpc.RemoveDataReceiverRequest inRequest, StreamObserver<DataFlowRpc.RemoveDataReceiverResponse> inResponseObserver) {
            try {
                DataFlowRpcService.this.validateAndReturnSession(inRequest.getSessionId());
                SLF4JLoggerProxy.trace((Object)((Object)DataFlowRpcService.this), (String)"Received remove data receiver request {}", (Object[])new Object[]{inRequest});
                String listenerId = inRequest.getListenerId();
                BaseRpcUtil.AbstractServerListenerProxy dataReceiverProxy = (BaseRpcUtil.AbstractServerListenerProxy)DataFlowRpcService.this.receiverProxiesById.getIfPresent((Object)listenerId);
                DataFlowRpcService.this.receiverProxiesById.invalidate((Object)listenerId);
                if (dataReceiverProxy != null) {
                    DataFlowRpcService.this.dataFlowService.removeDataReceiver((DataReceiver)dataReceiverProxy);
                    dataReceiverProxy.close();
                }
                DataFlowRpc.RemoveDataReceiverResponse.Builder responseBuilder = DataFlowRpc.RemoveDataReceiverResponse.newBuilder();
                DataFlowRpc.RemoveDataReceiverResponse response = responseBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)DataFlowRpcService.this), (String)"Returning {}", (Object[])new Object[]{response});
                inResponseObserver.onNext((Object)response);
                inResponseObserver.onCompleted();
            }
            catch (Exception e) {
                if (e instanceof StatusRuntimeException) {
                    throw (StatusRuntimeException)e;
                }
                throw new StatusRuntimeException(Status.INVALID_ARGUMENT.withCause((Throwable)e).withDescription(ExceptionUtils.getRootCauseMessage((Throwable)e)));
            }
        }
    }
}

