/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.geojson.utils;

import androidx.annotation.NonNull;
import com.mapbox.geojson.Point;
import java.util.ArrayList;
import java.util.List;

public final class PolylineUtils {
    private static final double SIMPLIFY_DEFAULT_TOLERANCE = 1.0;
    private static final boolean SIMPLIFY_DEFAULT_HIGHEST_QUALITY = false;

    private PolylineUtils() {
    }

    @NonNull
    public static List<Point> decode(@NonNull String encodedPath, int precision) {
        int len = encodedPath.length();
        double factor = Math.pow(10.0, precision);
        ArrayList<Point> path = new ArrayList<Point>();
        int index = 0;
        int lat = 0;
        int lng = 0;
        while (index < len) {
            int temp;
            int result = 1;
            int shift = 0;
            do {
                temp = encodedPath.charAt(index++) - 63 - 1;
                result += temp << shift;
                shift += 5;
            } while (temp >= 31);
            lat += (result & 1) != 0 ? ~(result >> 1) : result >> 1;
            result = 1;
            shift = 0;
            do {
                temp = encodedPath.charAt(index++) - 63 - 1;
                result += temp << shift;
                shift += 5;
            } while (temp >= 31);
            path.add(Point.fromLngLat((double)(lng += (result & 1) != 0 ? ~(result >> 1) : result >> 1) / factor, (double)lat / factor));
        }
        return path;
    }

    @NonNull
    public static String encode(@NonNull List<Point> path, int precision) {
        long lastLat = 0L;
        long lastLng = 0L;
        StringBuilder result = new StringBuilder();
        double factor = Math.pow(10.0, precision);
        for (Point point : path) {
            long lat = Math.round(point.latitude() * factor);
            long lng = Math.round(point.longitude() * factor);
            long varLat = lat - lastLat;
            long varLng = lng - lastLng;
            PolylineUtils.encode(varLat, result);
            PolylineUtils.encode(varLng, result);
            lastLat = lat;
            lastLng = lng;
        }
        return result.toString();
    }

    private static void encode(long variable, StringBuilder result) {
        long l = variable = variable < 0L ? variable << 1 ^ 0xFFFFFFFFFFFFFFFFL : variable << 1;
        while (variable >= 32L) {
            result.append(Character.toChars((int)((0x20L | variable & 0x1FL) + 63L)));
            variable >>= 5;
        }
        result.append(Character.toChars((int)(variable + 63L)));
    }

    @NonNull
    public static List<Point> simplify(@NonNull List<Point> points) {
        return PolylineUtils.simplify(points, 1.0, false);
    }

    @NonNull
    public static List<Point> simplify(@NonNull List<Point> points, double tolerance) {
        return PolylineUtils.simplify(points, tolerance, false);
    }

    @NonNull
    public static List<Point> simplify(@NonNull List<Point> points, boolean highestQuality) {
        return PolylineUtils.simplify(points, 1.0, highestQuality);
    }

    @NonNull
    public static List<Point> simplify(@NonNull List<Point> points, double tolerance, boolean highestQuality) {
        if (points.size() <= 2) {
            return points;
        }
        double sqTolerance = tolerance * tolerance;
        points = highestQuality ? points : PolylineUtils.simplifyRadialDist(points, sqTolerance);
        points = PolylineUtils.simplifyDouglasPeucker(points, sqTolerance);
        return points;
    }

    private static double getSqDist(Point p1, Point p2) {
        double dx = p1.longitude() - p2.longitude();
        double dy = p1.latitude() - p2.latitude();
        return dx * dx + dy * dy;
    }

    private static double getSqSegDist(Point point, Point p1, Point p2) {
        double horizontal = p1.longitude();
        double vertical = p1.latitude();
        double diffHorizontal = p2.longitude() - horizontal;
        double diffVertical = p2.latitude() - vertical;
        if (diffHorizontal != 0.0 || diffVertical != 0.0) {
            double total = ((point.longitude() - horizontal) * diffHorizontal + (point.latitude() - vertical) * diffVertical) / (diffHorizontal * diffHorizontal + diffVertical * diffVertical);
            if (total > 1.0) {
                horizontal = p2.longitude();
                vertical = p2.latitude();
            } else if (total > 0.0) {
                horizontal += diffHorizontal * total;
                vertical += diffVertical * total;
            }
        }
        diffHorizontal = point.longitude() - horizontal;
        diffVertical = point.latitude() - vertical;
        return diffHorizontal * diffHorizontal + diffVertical * diffVertical;
    }

    private static List<Point> simplifyRadialDist(List<Point> points, double sqTolerance) {
        Point prevPoint = points.get(0);
        ArrayList<Point> newPoints = new ArrayList<Point>();
        newPoints.add(prevPoint);
        Point point = null;
        int len = points.size();
        for (int i = 1; i < len; ++i) {
            point = points.get(i);
            if (!(PolylineUtils.getSqDist(point, prevPoint) > sqTolerance)) continue;
            newPoints.add(point);
            prevPoint = point;
        }
        if (!prevPoint.equals(point)) {
            newPoints.add(point);
        }
        return newPoints;
    }

    private static List<Point> simplifyDpStep(List<Point> points, int first, int last, double sqTolerance, List<Point> simplified) {
        double maxSqDist = sqTolerance;
        int index = 0;
        ArrayList<Point> stepList = new ArrayList<Point>();
        for (int i = first + 1; i < last; ++i) {
            double sqDist = PolylineUtils.getSqSegDist(points.get(i), points.get(first), points.get(last));
            if (!(sqDist > maxSqDist)) continue;
            index = i;
            maxSqDist = sqDist;
        }
        if (maxSqDist > sqTolerance) {
            if (index - first > 1) {
                stepList.addAll(PolylineUtils.simplifyDpStep(points, first, index, sqTolerance, simplified));
            }
            stepList.add(points.get(index));
            if (last - index > 1) {
                stepList.addAll(PolylineUtils.simplifyDpStep(points, index, last, sqTolerance, simplified));
            }
        }
        return stepList;
    }

    private static List<Point> simplifyDouglasPeucker(List<Point> points, double sqTolerance) {
        int last = points.size() - 1;
        ArrayList<Point> simplified = new ArrayList<Point>();
        simplified.add(points.get(0));
        simplified.addAll(PolylineUtils.simplifyDpStep(points, 0, last, sqTolerance, simplified));
        simplified.add(points.get(last));
        return simplified;
    }
}

