/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.geojson;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.mapbox.geojson.BoundingBox;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.GeoJson;
import com.mapbox.geojson.GeometryAdapterFactory;
import com.mapbox.geojson.gson.BoundingBoxTypeAdapter;
import com.mapbox.geojson.gson.GeoJsonAdapterFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;

@Keep
public final class FeatureCollection
implements GeoJson {
    private static final String TYPE = "FeatureCollection";
    private final String type;
    @JsonAdapter(value=BoundingBoxTypeAdapter.class)
    private final BoundingBox bbox;
    private final List<Feature> features;

    public static FeatureCollection fromJson(@NonNull String json) {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapterFactory(GeoJsonAdapterFactory.create());
        gson.registerTypeAdapterFactory(GeometryAdapterFactory.create());
        return (FeatureCollection)gson.create().fromJson(json, FeatureCollection.class);
    }

    public static FeatureCollection fromFeatures(@NonNull Feature[] features) {
        return new FeatureCollection(TYPE, null, Arrays.asList(features));
    }

    public static FeatureCollection fromFeatures(@NonNull List<Feature> features) {
        return new FeatureCollection(TYPE, null, features);
    }

    public static FeatureCollection fromFeatures(@NonNull Feature[] features, @Nullable BoundingBox bbox) {
        return new FeatureCollection(TYPE, bbox, Arrays.asList(features));
    }

    public static FeatureCollection fromFeatures(@NonNull List<Feature> features, @Nullable BoundingBox bbox) {
        return new FeatureCollection(TYPE, bbox, features);
    }

    public static FeatureCollection fromFeature(@NonNull Feature feature) {
        List<Feature> featureList = Arrays.asList(feature);
        return new FeatureCollection(TYPE, null, featureList);
    }

    public static FeatureCollection fromFeature(@NonNull Feature feature, @Nullable BoundingBox bbox) {
        List<Feature> featureList = Arrays.asList(feature);
        return new FeatureCollection(TYPE, bbox, featureList);
    }

    FeatureCollection(String type, @Nullable BoundingBox bbox, @Nullable List<Feature> features) {
        if (type == null) {
            throw new NullPointerException("Null type");
        }
        this.type = type;
        this.bbox = bbox;
        this.features = features;
    }

    @Override
    @NonNull
    public String type() {
        return this.type;
    }

    @Override
    @Nullable
    public BoundingBox bbox() {
        return this.bbox;
    }

    @Nullable
    public List<Feature> features() {
        return this.features;
    }

    @Override
    public String toJson() {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapterFactory(GeoJsonAdapterFactory.create());
        gson.registerTypeAdapterFactory(GeometryAdapterFactory.create());
        return gson.create().toJson((Object)this);
    }

    public static TypeAdapter<FeatureCollection> typeAdapter(Gson gson) {
        return new GsonTypeAdapter(gson);
    }

    public String toString() {
        return "FeatureCollection{type=" + this.type + ", bbox=" + this.bbox + ", features=" + this.features + "}";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FeatureCollection) {
            FeatureCollection that = (FeatureCollection)obj;
            return this.type.equals(that.type()) && (this.bbox == null ? that.bbox() == null : this.bbox.equals(that.bbox())) && (this.features == null ? that.features() == null : this.features.equals(that.features()));
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode *= 1000003;
        hashCode ^= this.type.hashCode();
        hashCode *= 1000003;
        hashCode ^= this.bbox == null ? 0 : this.bbox.hashCode();
        hashCode *= 1000003;
        return hashCode ^= this.features == null ? 0 : this.features.hashCode();
    }

    static final class GsonTypeAdapter
    extends TypeAdapter<FeatureCollection> {
        private volatile TypeAdapter<String> stringAdapter;
        private volatile TypeAdapter<BoundingBox> boundingBoxAdapter;
        private volatile TypeAdapter<List<Feature>> listFeatureAdapter;
        private final Gson gson;

        GsonTypeAdapter(Gson gson) {
            this.gson = gson;
        }

        public void write(JsonWriter jsonWriter, FeatureCollection object) throws IOException {
            if (object == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.beginObject();
            jsonWriter.name("type");
            if (object.type() == null) {
                jsonWriter.nullValue();
            } else {
                TypeAdapter stringAdapter = this.stringAdapter;
                if (stringAdapter == null) {
                    this.stringAdapter = stringAdapter = this.gson.getAdapter(String.class);
                }
                stringAdapter.write(jsonWriter, (Object)object.type());
            }
            jsonWriter.name("bbox");
            if (object.bbox() == null) {
                jsonWriter.nullValue();
            } else {
                TypeAdapter boundingBoxTypeAdapter = this.boundingBoxAdapter;
                if (boundingBoxTypeAdapter == null) {
                    this.boundingBoxAdapter = boundingBoxTypeAdapter = this.gson.getAdapter(BoundingBox.class);
                }
                boundingBoxTypeAdapter.write(jsonWriter, (Object)object.bbox());
            }
            jsonWriter.name("features");
            if (object.features() == null) {
                jsonWriter.nullValue();
            } else {
                TypeAdapter listFeatureAdapter = this.listFeatureAdapter;
                if (listFeatureAdapter == null) {
                    TypeToken typeToken = TypeToken.getParameterized(List.class, (Type[])new Type[]{Feature.class});
                    this.listFeatureAdapter = listFeatureAdapter = this.gson.getAdapter(typeToken);
                }
                listFeatureAdapter.write(jsonWriter, object.features());
            }
            jsonWriter.endObject();
        }

        public FeatureCollection read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            jsonReader.beginObject();
            String type = null;
            BoundingBox bbox = null;
            List features = null;
            block10: while (jsonReader.hasNext()) {
                String name = jsonReader.nextName();
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    continue;
                }
                switch (name) {
                    case "type": {
                        TypeAdapter stringAdapter = this.stringAdapter;
                        if (stringAdapter == null) {
                            this.stringAdapter = stringAdapter = this.gson.getAdapter(String.class);
                        }
                        type = (String)stringAdapter.read(jsonReader);
                        continue block10;
                    }
                    case "bbox": {
                        TypeAdapter boundingBoxAdapter = this.boundingBoxAdapter;
                        if (boundingBoxAdapter == null) {
                            this.boundingBoxAdapter = boundingBoxAdapter = this.gson.getAdapter(BoundingBox.class);
                        }
                        bbox = (BoundingBox)boundingBoxAdapter.read(jsonReader);
                        continue block10;
                    }
                    case "features": {
                        TypeAdapter listFeatureAdapter = this.listFeatureAdapter;
                        if (listFeatureAdapter == null) {
                            TypeToken typeToken = TypeToken.getParameterized(List.class, (Type[])new Type[]{Feature.class});
                            this.listFeatureAdapter = listFeatureAdapter = this.gson.getAdapter(typeToken);
                        }
                        features = (List)listFeatureAdapter.read(jsonReader);
                        continue block10;
                    }
                }
                jsonReader.skipValue();
            }
            jsonReader.endObject();
            return new FeatureCollection(type, bbox, features);
        }
    }
}

