/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.geojson;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mapbox.geojson.BaseGeometryTypeAdapter;
import com.mapbox.geojson.BoundingBox;
import com.mapbox.geojson.CoordinateContainer;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.ListOfListOfPointCoordinatesTypeAdapter;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.exception.GeoJsonException;
import com.mapbox.geojson.gson.GeoJsonAdapterFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@Keep
public final class Polygon
implements CoordinateContainer<List<List<Point>>> {
    private static final String TYPE = "Polygon";
    private final String type;
    private final BoundingBox bbox;
    private final List<List<Point>> coordinates;

    public static Polygon fromJson(@NonNull String json) {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapterFactory(GeoJsonAdapterFactory.create());
        return (Polygon)gson.create().fromJson(json, Polygon.class);
    }

    public static Polygon fromLngLats(@NonNull List<List<Point>> coordinates) {
        return new Polygon(TYPE, null, coordinates);
    }

    public static Polygon fromLngLats(@NonNull List<List<Point>> coordinates, @Nullable BoundingBox bbox) {
        return new Polygon(TYPE, bbox, coordinates);
    }

    static Polygon fromLngLats(@NonNull double[][][] coordinates) {
        ArrayList<List<Point>> converted = new ArrayList<List<Point>>(coordinates.length);
        for (double[][] coordinate : coordinates) {
            ArrayList<Point> innerList = new ArrayList<Point>(coordinate.length);
            for (double[] pointCoordinate : coordinate) {
                innerList.add(Point.fromLngLat(pointCoordinate));
            }
            converted.add(innerList);
        }
        return new Polygon(TYPE, null, converted);
    }

    public static Polygon fromOuterInner(@NonNull LineString outer, LineString ... inner) {
        Polygon.ensureIsLinearRing(outer);
        ArrayList<List<Point>> coordinates = new ArrayList<List<Point>>();
        coordinates.add((List<Point>)outer.coordinates());
        if (inner == null) {
            return new Polygon(TYPE, null, coordinates);
        }
        for (LineString lineString : inner) {
            Polygon.ensureIsLinearRing(lineString);
            coordinates.add((List<Point>)lineString.coordinates());
        }
        return new Polygon(TYPE, null, coordinates);
    }

    public static Polygon fromOuterInner(@NonNull LineString outer, @Nullable BoundingBox bbox, LineString ... inner) {
        Polygon.ensureIsLinearRing(outer);
        ArrayList<List<Point>> coordinates = new ArrayList<List<Point>>();
        coordinates.add((List<Point>)outer.coordinates());
        if (inner == null) {
            return new Polygon(TYPE, bbox, coordinates);
        }
        for (LineString lineString : inner) {
            Polygon.ensureIsLinearRing(lineString);
            coordinates.add((List<Point>)lineString.coordinates());
        }
        return new Polygon(TYPE, bbox, coordinates);
    }

    public static Polygon fromOuterInner(@NonNull LineString outer, @Nullable @Size(min=1L) List<LineString> inner) {
        Polygon.ensureIsLinearRing(outer);
        ArrayList<List<Point>> coordinates = new ArrayList<List<Point>>();
        coordinates.add((List<Point>)outer.coordinates());
        if (inner == null || inner.isEmpty()) {
            return new Polygon(TYPE, null, coordinates);
        }
        for (LineString lineString : inner) {
            Polygon.ensureIsLinearRing(lineString);
            coordinates.add((List<Point>)lineString.coordinates());
        }
        return new Polygon(TYPE, null, coordinates);
    }

    public static Polygon fromOuterInner(@NonNull LineString outer, @Nullable BoundingBox bbox, @Nullable @Size(min=1L) List<LineString> inner) {
        Polygon.ensureIsLinearRing(outer);
        ArrayList<List<Point>> coordinates = new ArrayList<List<Point>>();
        coordinates.add((List<Point>)outer.coordinates());
        if (inner == null) {
            return new Polygon(TYPE, bbox, coordinates);
        }
        for (LineString lineString : inner) {
            Polygon.ensureIsLinearRing(lineString);
            coordinates.add((List<Point>)lineString.coordinates());
        }
        return new Polygon(TYPE, bbox, coordinates);
    }

    Polygon(String type, @Nullable BoundingBox bbox, List<List<Point>> coordinates) {
        if (type == null) {
            throw new NullPointerException("Null type");
        }
        this.type = type;
        this.bbox = bbox;
        if (coordinates == null) {
            throw new NullPointerException("Null coordinates");
        }
        this.coordinates = coordinates;
    }

    @NonNull
    public LineString outer() {
        return LineString.fromLngLats((List)this.coordinates().get(0));
    }

    @NonNull
    public List<LineString> inner() {
        Object coordinates = this.coordinates();
        if (coordinates.size() <= 1) {
            return new ArrayList<LineString>(0);
        }
        ArrayList<LineString> inner = new ArrayList<LineString>(coordinates.size() - 1);
        for (List points : coordinates.subList(1, coordinates.size())) {
            inner.add(LineString.fromLngLats(points));
        }
        return inner;
    }

    @Override
    @NonNull
    public String type() {
        return this.type;
    }

    @Override
    @Nullable
    public BoundingBox bbox() {
        return this.bbox;
    }

    @Override
    @NonNull
    public List<List<Point>> coordinates() {
        return this.coordinates;
    }

    @Override
    public String toJson() {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapterFactory(GeoJsonAdapterFactory.create());
        return gson.create().toJson((Object)this);
    }

    public static TypeAdapter<Polygon> typeAdapter(Gson gson) {
        return new GsonTypeAdapter(gson);
    }

    private static void ensureIsLinearRing(LineString lineString) {
        if (lineString.coordinates().size() < 4) {
            throw new GeoJsonException("LinearRings need to be made up of 4 or more coordinates.");
        }
        if (!((Point)lineString.coordinates().get(0)).equals(lineString.coordinates().get(lineString.coordinates().size() - 1))) {
            throw new GeoJsonException("LinearRings require first and last coordinate to be identical.");
        }
    }

    public String toString() {
        return "Polygon{type=" + this.type + ", bbox=" + this.bbox + ", coordinates=" + this.coordinates + "}";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Polygon) {
            Polygon that = (Polygon)obj;
            return this.type.equals(that.type()) && (this.bbox == null ? that.bbox() == null : this.bbox.equals(that.bbox())) && this.coordinates.equals(that.coordinates());
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode *= 1000003;
        hashCode ^= this.type.hashCode();
        hashCode *= 1000003;
        hashCode ^= this.bbox == null ? 0 : this.bbox.hashCode();
        hashCode *= 1000003;
        return hashCode ^= this.coordinates.hashCode();
    }

    static final class GsonTypeAdapter
    extends BaseGeometryTypeAdapter<Polygon, List<List<Point>>> {
        GsonTypeAdapter(Gson gson) {
            super(gson, new ListOfListOfPointCoordinatesTypeAdapter());
        }

        public void write(JsonWriter jsonWriter, Polygon object) throws IOException {
            this.writeCoordinateContainer(jsonWriter, object);
        }

        public Polygon read(JsonReader jsonReader) throws IOException {
            return (Polygon)this.readCoordinateContainer(jsonReader);
        }

        @Override
        CoordinateContainer<List<List<Point>>> createCoordinateContainer(String type, BoundingBox bbox, List<List<Point>> coords) {
            return new Polygon(type == null ? Polygon.TYPE : type, bbox, coords);
        }
    }
}

