/*
 * Decompiled with CFR 0.152.
 */
package org.maplibre.compose.style;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.ImageBitmap;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maplibre.compose.layers.Layer;
import org.maplibre.compose.sources.Source;
import org.maplibre.compose.style.Style;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJ\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006H\u0016J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0018H\u0016J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0018H\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001aH\u0016J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u001fH\u0016J\u0018\u0010#\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u001fH\u0016J\u0018\u0010$\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u001fH\u0016J\u0018\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020'2\u0006\u0010\"\u001a\u00020\u001fH\u0016J\u0010\u0010(\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u001fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006)"}, d2={"Lorg/maplibre/compose/style/SafeStyle;", "Lorg/maplibre/compose/style/Style;", "delegate", "<init>", "(Lorg/maplibre/compose/style/Style;)V", "isUnloaded", "", "isUnloaded$maplibre_compose", "()Z", "setUnloaded$maplibre_compose", "(Z)V", "unload", "", "unload$maplibre_compose", "warnIfUnloaded", "methodName", "", "addImage", "id", "image", "Landroidx/compose/ui/graphics/ImageBitmap;", "sdf", "removeImage", "getSource", "Lorg/maplibre/compose/sources/Source;", "getSources", "", "addSource", "source", "removeSource", "getLayer", "Lorg/maplibre/compose/layers/Layer;", "getLayers", "addLayer", "layer", "addLayerAbove", "addLayerBelow", "addLayerAt", "index", "", "removeLayer", "maplibre-compose"})
@StabilityInferred(parameters=0)
public final class SafeStyle
implements Style {
    @NotNull
    private final Style delegate;
    private boolean isUnloaded;
    public static final int $stable = 8;

    public SafeStyle(@NotNull Style delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
    }

    public final boolean isUnloaded$maplibre_compose() {
        return this.isUnloaded;
    }

    public final void setUnloaded$maplibre_compose(boolean bl) {
        this.isUnloaded = bl;
    }

    public final void unload$maplibre_compose() {
        this.isUnloaded = true;
    }

    private final void warnIfUnloaded(String methodName) {
        if (this.isUnloaded) {
            System.out.println((Object)("Warning: Attempting to call " + methodName + " on an unloaded style"));
        }
    }

    @Override
    public void addImage(@NotNull String id, @NotNull ImageBitmap image, boolean sdf) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        this.warnIfUnloaded("addImage");
        if (!this.isUnloaded) {
            this.delegate.addImage(id, image, sdf);
        }
    }

    @Override
    public void removeImage(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.warnIfUnloaded("removeImage");
        if (!this.isUnloaded) {
            this.delegate.removeImage(id);
        }
    }

    @Override
    @Nullable
    public Source getSource(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.warnIfUnloaded("getSource");
        return !this.isUnloaded ? this.delegate.getSource(id) : null;
    }

    @Override
    @NotNull
    public List<Source> getSources() {
        this.warnIfUnloaded("getSources");
        return !this.isUnloaded ? this.delegate.getSources() : CollectionsKt.emptyList();
    }

    @Override
    public void addSource(@NotNull Source source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.warnIfUnloaded("addSource");
        if (!this.isUnloaded) {
            this.delegate.addSource(source);
        }
    }

    @Override
    public void removeSource(@NotNull Source source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.warnIfUnloaded("removeSource");
        if (!this.isUnloaded) {
            this.delegate.removeSource(source);
        }
    }

    @Override
    @Nullable
    public Layer getLayer(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.warnIfUnloaded("getLayer");
        return !this.isUnloaded ? this.delegate.getLayer(id) : null;
    }

    @Override
    @NotNull
    public List<Layer> getLayers() {
        this.warnIfUnloaded("getLayers");
        return !this.isUnloaded ? this.delegate.getLayers() : CollectionsKt.emptyList();
    }

    @Override
    public void addLayer(@NotNull Layer layer) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        this.warnIfUnloaded("addLayer");
        if (!this.isUnloaded) {
            this.delegate.addLayer(layer);
        }
    }

    @Override
    public void addLayerAbove(@NotNull String id, @NotNull Layer layer) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        this.warnIfUnloaded("addLayerAbove");
        if (!this.isUnloaded) {
            this.delegate.addLayerAbove(id, layer);
        }
    }

    @Override
    public void addLayerBelow(@NotNull String id, @NotNull Layer layer) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        this.warnIfUnloaded("addLayerBelow");
        if (!this.isUnloaded) {
            this.delegate.addLayerBelow(id, layer);
        }
    }

    @Override
    public void addLayerAt(int index, @NotNull Layer layer) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        this.warnIfUnloaded("addLayerAt");
        if (!this.isUnloaded) {
            this.delegate.addLayerAt(index, layer);
        }
    }

    @Override
    public void removeLayer(@NotNull Layer layer) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        this.warnIfUnloaded("removeLayer");
        if (!this.isUnloaded) {
            this.delegate.removeLayer(layer);
        }
    }
}

