/*
 * Decompiled with CFR 0.152.
 */
package org.maplibre.compose.style;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00002\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J!\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u00002\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\f\u00a2\u0006\u0002\u0010\rJ!\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u00002\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\f\u00a2\u0006\u0002\u0010\rR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/maplibre/compose/style/ReferenceCounter;", "T", "", "<init>", "()V", "map", "", "", "increment", "", "value", "onZeroToOne", "Lkotlin/Function0;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)V", "decrement", "onOneToZero", "maplibre-compose"})
@StabilityInferred(parameters=0)
public final class ReferenceCounter<T> {
    @NotNull
    private final Map<T, Integer> map = new LinkedHashMap();
    public static final int $stable = 8;

    public final void increment(T value, @NotNull Function0<Unit> onZeroToOne) {
        Intrinsics.checkNotNullParameter(onZeroToOne, (String)"onZeroToOne");
        Integer count = this.map.get(value);
        if (count == null) {
            this.map.put(value, 1);
            onZeroToOne.invoke();
        } else {
            this.map.put(value, count + 1);
        }
    }

    public final void decrement(T value, @NotNull Function0<Unit> onOneToZero) {
        Intrinsics.checkNotNullParameter(onOneToZero, (String)"onOneToZero");
        Integer n = this.map.get(value);
        if (n == null) {
            throw new IllegalStateException("decrementing below zero".toString());
        }
        int count = n;
        if (count == 1) {
            this.map.remove(value);
            onOneToZero.invoke();
        } else {
            this.map.put(value, count - 1);
        }
    }
}

