/*
 * Decompiled with CFR 0.152.
 */
package org.maplibre.compose.style;

import androidx.compose.runtime.internal.StabilityInferred;
import co.touchlab.kermit.BaseLogger;
import co.touchlab.kermit.Logger;
import co.touchlab.kermit.Severity;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maplibre.compose.sources.Source;
import org.maplibre.compose.style.IncrementingId;
import org.maplibre.compose.style.ReferenceCounter;
import org.maplibre.compose.style.StyleNode;
import org.maplibre.compose.style.StyleState;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0016J\r\u0010\u0017\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0018J\u0015\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u001cJ\u0015\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u001eJ\r\u0010\u001f\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Lorg/maplibre/compose/style/SourceManager;", "", "node", "Lorg/maplibre/compose/style/StyleNode;", "<init>", "(Lorg/maplibre/compose/style/StyleNode;)V", "baseSources", "", "", "Lorg/maplibre/compose/sources/Source;", "counter", "Lorg/maplibre/compose/style/ReferenceCounter;", "sourceIds", "Lorg/maplibre/compose/style/IncrementingId;", "state", "Lorg/maplibre/compose/style/StyleState;", "getState$maplibre_compose", "()Lorg/maplibre/compose/style/StyleState;", "setState$maplibre_compose", "(Lorg/maplibre/compose/style/StyleState;)V", "getBaseSource", "id", "getBaseSource$maplibre_compose", "nextId", "nextId$maplibre_compose", "addReference", "", "source", "addReference$maplibre_compose", "removeReference", "removeReference$maplibre_compose", "applyChanges", "applyChanges$maplibre_compose", "maplibre-compose"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSourceManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceManager.kt\norg/maplibre/compose/style/SourceManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Logger.kt\nco/touchlab/kermit/Logger\n+ 5 BaseLogger.kt\nco/touchlab/kermit/BaseLogger\n*L\n1#1,43:1\n1208#2,2:44\n1236#2,4:46\n1#3:50\n36#4,3:51\n39#4:63\n36#4,3:64\n39#4:76\n31#5,9:54\n31#5,9:67\n*S KotlinDebug\n*F\n+ 1 SourceManager.kt\norg/maplibre/compose/style/SourceManager\n*L\n7#1:44,2\n7#1:46,4\n23#1:51,3\n23#1:63\n33#1:64,3\n33#1:76\n23#1:54,9\n33#1:67,9\n*E\n"})
public final class SourceManager {
    @NotNull
    private final StyleNode node;
    @NotNull
    private final Map<String, Source> baseSources;
    @NotNull
    private final ReferenceCounter<Source> counter;
    @NotNull
    private final IncrementingId sourceIds;
    @Nullable
    private StyleState state;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public SourceManager(@NotNull StyleNode node) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.node = node;
        Iterable iterable = this.node.getStyle().getSources();
        SourceManager sourceManager = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var5_6 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Source source = (Source)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getId$maplibre_compose(), element$iv$iv);
        }
        sourceManager.baseSources = destination$iv$iv;
        this.counter = new ReferenceCounter();
        this.sourceIds = new IncrementingId("source");
    }

    @Nullable
    public final StyleState getState$maplibre_compose() {
        return this.state;
    }

    public final void setState$maplibre_compose(@Nullable StyleState styleState) {
        this.state = styleState;
    }

    @Nullable
    public final Source getBaseSource$maplibre_compose(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.baseSources.get(id);
    }

    @NotNull
    public final String nextId$maplibre_compose() {
        return this.sourceIds.next();
    }

    public final void addReference$maplibre_compose(@NotNull Source source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!(!this.baseSources.containsKey(source.getId$maplibre_compose()))) {
            boolean bl = false;
            String string2 = "Source ID '" + source.getId$maplibre_compose() + "' already exists in base style";
            throw new IllegalArgumentException(string2.toString());
        }
        this.counter.increment(source, (Function0<Unit>)((Function0)() -> SourceManager.addReference$lambda$3(this, source)));
    }

    public final void removeReference$maplibre_compose(@NotNull Source source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!(!this.baseSources.containsKey(source.getId$maplibre_compose()))) {
            boolean bl = false;
            String string2 = "Source ID '" + source.getId$maplibre_compose() + "' is part of the base style and can't be removed here";
            throw new IllegalArgumentException(string2.toString());
        }
        this.counter.decrement(source, (Function0<Unit>)((Function0)() -> SourceManager.removeReference$lambda$6(this, source)));
    }

    public final void applyChanges$maplibre_compose() {
        block0: {
            StyleState styleState = this.state;
            if (styleState == null) break block0;
            styleState.reloadSources$maplibre_compose();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit addReference$lambda$3(SourceManager this$0, Source $source) {
        Logger logger = this$0.node.getLogger$maplibre_compose();
        if (logger != null) {
            void this_$iv$iv;
            Logger $this$iv = logger;
            Throwable throwable$iv = null;
            String tag$iv = $this$iv.getTag();
            boolean $i$f$i = false;
            BaseLogger baseLogger = (BaseLogger)$this$iv;
            Severity severity$iv$iv = Severity.Info;
            boolean $i$f$logBlock = false;
            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                Throwable throwable = throwable$iv;
                String string2 = tag$iv;
                Severity severity = severity$iv$iv;
                void var10_12 = this_$iv$iv;
                boolean bl = false;
                String string3 = "Adding source " + $source.getId$maplibre_compose();
                var10_12.processLog(severity, string2, throwable, string3);
            }
        }
        this$0.node.getStyle().addSource($source);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit removeReference$lambda$6(SourceManager this$0, Source $source) {
        block2: {
            Logger logger = this$0.node.getLogger$maplibre_compose();
            if (logger != null) {
                void this_$iv$iv;
                Logger $this$iv = logger;
                Throwable throwable$iv = null;
                String tag$iv = $this$iv.getTag();
                boolean $i$f$i = false;
                BaseLogger baseLogger = (BaseLogger)$this$iv;
                Severity severity$iv$iv = Severity.Info;
                boolean $i$f$logBlock = false;
                if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                    Throwable throwable = throwable$iv;
                    String string2 = tag$iv;
                    Severity severity = severity$iv$iv;
                    void var10_12 = this_$iv$iv;
                    boolean bl = false;
                    String string3 = "Removing source " + $source.getId$maplibre_compose();
                    var10_12.processLog(severity, string2, throwable, string3);
                }
            }
            this$0.node.getStyle().removeSource($source);
            StyleState styleState = this$0.state;
            if (styleState == null) break block2;
            styleState.reloadSources$maplibre_compose();
        }
        return Unit.INSTANCE;
    }
}

