/*
 * Decompiled with CFR 0.152.
 */
package org.maplibre.compose.style;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.CanvasKt;
import androidx.compose.ui.graphics.ImageBitmap;
import androidx.compose.ui.graphics.ImageBitmapKt;
import androidx.compose.ui.graphics.drawscope.CanvasDrawScope;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.painter.Painter;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.Dp;
import androidx.compose.ui.unit.DpSize;
import androidx.compose.ui.unit.LayoutDirection;
import co.touchlab.kermit.BaseLogger;
import co.touchlab.kermit.Logger;
import co.touchlab.kermit.Severity;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maplibre.compose.style.ConvertToSdfKt;
import org.maplibre.compose.style.IncrementingIdMap;
import org.maplibre.compose.style.ReferenceCounter;
import org.maplibre.compose.style.StyleNode;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\b\b\u0001\u0018\u00002\u00020\u0001:\u0002!\"B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0014J\u0015\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0017J\f\u0010\u0018\u001a\u00020\u0010*\u00020\fH\u0002J \u0010\u0019\u001a\u00020\u0010*\u00020\u00102\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001bH\u0002J\u0015\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u001eJ\u0015\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/maplibre/compose/style/ImageManager;", "", "node", "Lorg/maplibre/compose/style/StyleNode;", "<init>", "(Lorg/maplibre/compose/style/StyleNode;)V", "bitmapIds", "Lorg/maplibre/compose/style/IncrementingIdMap;", "Lorg/maplibre/compose/style/ImageManager$BitmapKey;", "bitmapCounter", "Lorg/maplibre/compose/style/ReferenceCounter;", "painterIds", "Lorg/maplibre/compose/style/ImageManager$PainterKey;", "painterCounter", "painterBitmaps", "", "Landroidx/compose/ui/graphics/ImageBitmap;", "acquireBitmap", "", "key", "acquireBitmap$maplibre_compose", "releaseBitmap", "", "releaseBitmap$maplibre_compose", "drawToBitmap", "toSdf", "radius", "", "cutoff", "acquirePainter", "acquirePainter$maplibre_compose", "releasePainter", "releasePainter$maplibre_compose", "BitmapKey", "PainterKey", "maplibre-compose"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nImageManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageManager.kt\norg/maplibre/compose/style/ImageManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Size.kt\nandroidx/compose/ui/geometry/SizeKt\n+ 4 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 5 Dp.kt\nandroidx/compose/ui/unit/DpKt\n+ 6 Size.kt\nandroidx/compose/ui/geometry/Size\n+ 7 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 8 CanvasDrawScope.kt\nandroidx/compose/ui/graphics/drawscope/CanvasDrawScope\n+ 9 Logger.kt\nco/touchlab/kermit/Logger\n+ 10 BaseLogger.kt\nco/touchlab/kermit/BaseLogger\n*L\n1#1,95:1\n1#2:96\n33#3:97\n159#3:101\n148#3:102\n33#3:104\n53#4,3:98\n53#4,3:105\n60#4:109\n70#4:112\n113#5:103\n57#6:108\n61#6:111\n22#7:110\n536#8,17:113\n36#9,3:130\n39#9:142\n36#9,3:143\n39#9:155\n36#9,3:156\n39#9:168\n36#9,3:169\n39#9:181\n31#10,9:133\n31#10,9:146\n31#10,9:159\n31#10,9:172\n*S KotlinDebug\n*F\n+ 1 ImageManager.kt\norg/maplibre/compose/style/ImageManager\n*L\n44#1:97\n45#1:101\n45#1:102\n45#1:104\n44#1:98,3\n45#1:105,3\n47#1:109\n47#1:112\n45#1:103\n47#1:108\n47#1:111\n47#1:110\n48#1:113,17\n27#1:130,3\n27#1:142\n36#1:143,3\n36#1:155\n67#1:156,3\n67#1:168\n79#1:169,3\n79#1:181\n27#1:133,9\n36#1:146,9\n67#1:159,9\n79#1:172,9\n*E\n"})
public final class ImageManager {
    @NotNull
    private final StyleNode node;
    @NotNull
    private final IncrementingIdMap<BitmapKey> bitmapIds;
    @NotNull
    private final ReferenceCounter<BitmapKey> bitmapCounter;
    @NotNull
    private final IncrementingIdMap<PainterKey> painterIds;
    @NotNull
    private final ReferenceCounter<PainterKey> painterCounter;
    @NotNull
    private final Map<PainterKey, ImageBitmap> painterBitmaps;
    public static final int $stable = 8;

    public ImageManager(@NotNull StyleNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.node = node;
        this.bitmapIds = new IncrementingIdMap("bitmap");
        this.bitmapCounter = new ReferenceCounter();
        this.painterIds = new IncrementingIdMap("painter");
        this.painterCounter = new ReferenceCounter();
        this.painterBitmaps = new LinkedHashMap();
    }

    @NotNull
    public final String acquireBitmap$maplibre_compose(@NotNull BitmapKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.bitmapCounter.increment(key, (Function0<Unit>)((Function0)() -> ImageManager.acquireBitmap$lambda$1(this, key)));
        return this.bitmapIds.getId(key);
    }

    public final void releaseBitmap$maplibre_compose(@NotNull BitmapKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.bitmapCounter.decrement(key, (Function0<Unit>)((Function0)() -> ImageManager.releaseBitmap$lambda$3(this, key)));
    }

    /*
     * WARNING - void declaration
     */
    private final ImageBitmap drawToBitmap(PainterKey $this$drawToBitmap) {
        void canvas$iv;
        void layoutDirection$iv;
        void density$iv;
        void this_$iv;
        long size;
        long l;
        Density $this$drawToBitmap_u24lambda_u246 = $this$drawToBitmap.getDensity();
        boolean $i$a$-with-ImageManager$drawToBitmap$size$22 = false;
        DpSize dpSize = $this$drawToBitmap.getSize-rqqXlrw();
        if (dpSize != null) {
            void width$iv;
            long it = dpSize.unbox-impl();
            boolean bl = false;
            float f = $this$drawToBitmap_u24lambda_u246.toPx-0680j_4(DpSize.getWidth-D9Ej5fM((long)it));
            float height$iv = $this$drawToBitmap_u24lambda_u246.toPx-0680j_4(DpSize.getHeight-D9Ej5fM((long)it));
            boolean $i$f$Size = false;
            boolean $i$f$packFloats = false;
            long v1$iv$iv = Float.floatToRawIntBits((float)width$iv);
            long v2$iv$iv = Float.floatToRawIntBits(height$iv);
            l = Size.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
        } else {
            long $this$takeOrElse_u2dTmRCtEA$iv = $this$drawToBitmap.getPainter().getIntrinsicSize-NH-jbRc();
            boolean bl = false;
            long $this$isSpecified$iv$iv = $this$takeOrElse_u2dTmRCtEA$iv;
            boolean bl2 = false;
            if ($this$isSpecified$iv$iv != 9205357640488583168L) {
                l = $this$takeOrElse_u2dTmRCtEA$iv;
            } else {
                void width$iv;
                boolean bl3 = false;
                int $this$dp$iv22 = 16;
                boolean $i$f$getDp = false;
                float $this$dp$iv22 = $this$drawToBitmap_u24lambda_u246.toPx-0680j_4(Dp.constructor-impl((float)$this$dp$iv22));
                int $this$dp$iv = 16;
                boolean $i$f$getDp2 = false;
                float height$iv = $this$drawToBitmap_u24lambda_u246.toPx-0680j_4(Dp.constructor-impl((float)$this$dp$iv));
                boolean $i$f$Size = false;
                boolean $i$f$packFloats = false;
                long v1$iv$iv = Float.floatToRawIntBits((float)width$iv);
                long v2$iv$iv = Float.floatToRawIntBits(height$iv);
                l = Size.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
            }
        }
        long arg0$iv = size = l;
        boolean bl = false;
        long value$iv$iv = arg0$iv;
        boolean $i$f$unpackFloat1 = false;
        int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
        boolean $i$f$floatFromBits = false;
        int n = (int)Float.intBitsToFloat(bits$iv$iv$iv);
        arg0$iv = size;
        boolean $i$f$getHeight-impl22 = false;
        value$iv$iv = arg0$iv;
        boolean $i$f$unpackFloat2 = false;
        bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
        $i$f$floatFromBits = false;
        ImageBitmap bitmap = ImageBitmapKt.ImageBitmap-x__-hDU$default((int)n, (int)((int)Float.intBitsToFloat(bits$iv$iv$iv)), (int)0, (boolean)false, null, (int)28, null);
        CanvasDrawScope arg0$iv2 = new CanvasDrawScope();
        Density $i$a$-with-ImageManager$drawToBitmap$size$22 = $this$drawToBitmap.getDensity();
        LayoutDirection $i$f$getHeight-impl22 = $this$drawToBitmap.getLayoutDirection();
        Canvas value$iv$iv2 = CanvasKt.Canvas((ImageBitmap)bitmap);
        long size$iv = size;
        boolean bl4 = false;
        CanvasDrawScope.DrawParams drawParams = this_$iv.getDrawParams();
        Density prevDensity$iv = drawParams.component1();
        LayoutDirection prevLayoutDirection$iv = drawParams.component2();
        Canvas prevCanvas$iv = drawParams.component3();
        long prevSize$iv = drawParams.component4-NH-jbRc();
        CanvasDrawScope.DrawParams $this$draw_yzxVdVo_u24lambda_u240$iv = this_$iv.getDrawParams();
        boolean bl5 = false;
        $this$draw_yzxVdVo_u24lambda_u240$iv.setDensity((Density)density$iv);
        $this$draw_yzxVdVo_u24lambda_u240$iv.setLayoutDirection((LayoutDirection)layoutDirection$iv);
        $this$draw_yzxVdVo_u24lambda_u240$iv.setCanvas((Canvas)canvas$iv);
        $this$draw_yzxVdVo_u24lambda_u240$iv.setSize-uvyYCjk(size$iv);
        canvas$iv.save();
        DrawScope $this$drawToBitmap_u24lambda_u248 = (DrawScope)this_$iv;
        boolean bl6 = false;
        Painter $this$drawToBitmap_u24lambda_u248_u24lambda_u247 = $this$drawToBitmap.getPainter();
        boolean bl7 = false;
        Painter.draw-x_KDEd0$default((Painter)$this$drawToBitmap_u24lambda_u248_u24lambda_u247, (DrawScope)$this$drawToBitmap_u24lambda_u248, (long)size, (float)0.0f, null, (int)6, null);
        canvas$iv.restore();
        CanvasDrawScope.DrawParams $this$draw_yzxVdVo_u24lambda_u241$iv = this_$iv.getDrawParams();
        boolean bl8 = false;
        $this$draw_yzxVdVo_u24lambda_u241$iv.setDensity(prevDensity$iv);
        $this$draw_yzxVdVo_u24lambda_u241$iv.setLayoutDirection(prevLayoutDirection$iv);
        $this$draw_yzxVdVo_u24lambda_u241$iv.setCanvas(prevCanvas$iv);
        $this$draw_yzxVdVo_u24lambda_u241$iv.setSize-uvyYCjk(prevSize$iv);
        return bitmap;
    }

    private final ImageBitmap toSdf(ImageBitmap $this$toSdf, double radius, double cutoff) {
        int buffer = (int)Math.ceil(radius * (1.0 - cutoff));
        int w = $this$toSdf.getWidth() + 2 * buffer;
        int h = $this$toSdf.getHeight() + 2 * buffer;
        int[] pixels = new int[w * h];
        ImageBitmap.readPixels$default((ImageBitmap)$this$toSdf, (int[])pixels, (int)0, (int)0, (int)0, (int)0, (int)(w * buffer + buffer), (int)w, (int)30, null);
        ConvertToSdfKt.convertToSdf(pixels, w, radius, cutoff);
        return org.maplibre.compose.util.ImageBitmapKt.toImageBitmap(pixels, w, pixels.length / w);
    }

    static /* synthetic */ ImageBitmap toSdf$default(ImageManager imageManager, ImageBitmap imageBitmap, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = 8.0;
        }
        if ((n & 2) != 0) {
            d2 = 0.25;
        }
        return imageManager.toSdf(imageBitmap, d, d2);
    }

    @NotNull
    public final String acquirePainter$maplibre_compose(@NotNull PainterKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.painterCounter.increment(key, (Function0<Unit>)((Function0)() -> ImageManager.acquirePainter$lambda$11(this, key)));
        return this.painterIds.getId(key);
    }

    public final void releasePainter$maplibre_compose(@NotNull PainterKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.painterCounter.decrement(key, (Function0<Unit>)((Function0)() -> ImageManager.releasePainter$lambda$13(this, key)));
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit acquireBitmap$lambda$1(ImageManager this$0, BitmapKey $key) {
        String id = this$0.bitmapIds.addId($key);
        Logger logger = this$0.node.getLogger$maplibre_compose();
        if (logger != null) {
            void this_$iv$iv;
            Logger $this$iv = logger;
            Throwable throwable$iv = null;
            String tag$iv = $this$iv.getTag();
            boolean $i$f$i = false;
            BaseLogger baseLogger = (BaseLogger)$this$iv;
            Severity severity$iv$iv = Severity.Info;
            boolean $i$f$logBlock = false;
            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                Throwable throwable = throwable$iv;
                String string2 = tag$iv;
                Severity severity = severity$iv$iv;
                void var11_13 = this_$iv$iv;
                boolean bl = false;
                String string3 = "Adding bitmap " + id;
                var11_13.processLog(severity, string2, throwable, string3);
            }
        }
        this$0.node.getStyle().addImage(id, $key.getBitmap(), $key.isSdf());
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit releaseBitmap$lambda$3(ImageManager this$0, BitmapKey $key) {
        String id = this$0.bitmapIds.removeId($key);
        Logger logger = this$0.node.getLogger$maplibre_compose();
        if (logger != null) {
            void this_$iv$iv;
            Logger $this$iv = logger;
            Throwable throwable$iv = null;
            String tag$iv = $this$iv.getTag();
            boolean $i$f$i = false;
            BaseLogger baseLogger = (BaseLogger)$this$iv;
            Severity severity$iv$iv = Severity.Info;
            boolean $i$f$logBlock = false;
            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                Throwable throwable = throwable$iv;
                String string2 = tag$iv;
                Severity severity = severity$iv$iv;
                void var11_13 = this_$iv$iv;
                boolean bl = false;
                String string3 = "Removing bitmap " + id;
                var11_13.processLog(severity, string2, throwable, string3);
            }
        }
        this$0.node.getStyle().removeImage(id);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit acquirePainter$lambda$11(ImageManager this$0, PainterKey $key) {
        String id = this$0.painterIds.addId($key);
        Logger logger = this$0.node.getLogger$maplibre_compose();
        if (logger != null) {
            void this_$iv$iv;
            Logger $this$iv = logger;
            Throwable throwable$iv = null;
            String tag$iv = $this$iv.getTag();
            boolean $i$f$i = false;
            BaseLogger baseLogger = (BaseLogger)$this$iv;
            Severity severity$iv$iv = Severity.Info;
            boolean $i$f$logBlock = false;
            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                Throwable throwable = throwable$iv;
                String string2 = tag$iv;
                Severity severity = severity$iv$iv;
                void var11_14 = this_$iv$iv;
                boolean bl = false;
                String string3 = "Adding painter " + id;
                var11_14.processLog(severity, string2, throwable, string3);
            }
        }
        ImageBitmap bitmap = this$0.drawToBitmap($key);
        boolean bl = false;
        this$0.painterBitmaps.put($key, $key.getDrawAsSdf() ? ImageManager.toSdf$default(this$0, bitmap, 0.0, 0.0, 3, null) : bitmap);
        this$0.node.getStyle().addImage(id, bitmap, $key.getDrawAsSdf());
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit releasePainter$lambda$13(ImageManager this$0, PainterKey $key) {
        String id = this$0.painterIds.removeId($key);
        Logger logger = this$0.node.getLogger$maplibre_compose();
        if (logger != null) {
            void this_$iv$iv;
            Logger $this$iv = logger;
            Throwable throwable$iv = null;
            String tag$iv = $this$iv.getTag();
            boolean $i$f$i = false;
            BaseLogger baseLogger = (BaseLogger)$this$iv;
            Severity severity$iv$iv = Severity.Info;
            boolean $i$f$logBlock = false;
            if (this_$iv$iv.getConfig().getMinSeverity().compareTo((Enum)severity$iv$iv) <= 0) {
                Throwable throwable = throwable$iv;
                String string2 = tag$iv;
                Severity severity = severity$iv$iv;
                void var11_13 = this_$iv$iv;
                boolean bl = false;
                String string3 = "Removing painter " + id;
                var11_13.processLog(severity, string2, throwable, string3);
            }
        }
        this$0.painterBitmaps.remove($key);
        this$0.node.getStyle().removeImage(id);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0081\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/maplibre/compose/style/ImageManager$BitmapKey;", "", "bitmap", "Landroidx/compose/ui/graphics/ImageBitmap;", "isSdf", "", "<init>", "(Landroidx/compose/ui/graphics/ImageBitmap;Z)V", "getBitmap", "()Landroidx/compose/ui/graphics/ImageBitmap;", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "maplibre-compose"})
    @StabilityInferred(parameters=0)
    public static final class BitmapKey {
        @NotNull
        private final ImageBitmap bitmap;
        private final boolean isSdf;
        public static final int $stable = 8;

        public BitmapKey(@NotNull ImageBitmap bitmap, boolean isSdf) {
            Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
            this.bitmap = bitmap;
            this.isSdf = isSdf;
        }

        @NotNull
        public final ImageBitmap getBitmap() {
            return this.bitmap;
        }

        public final boolean isSdf() {
            return this.isSdf;
        }

        @NotNull
        public final ImageBitmap component1() {
            return this.bitmap;
        }

        public final boolean component2() {
            return this.isSdf;
        }

        @NotNull
        public final BitmapKey copy(@NotNull ImageBitmap bitmap, boolean isSdf) {
            Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
            return new BitmapKey(bitmap, isSdf);
        }

        public static /* synthetic */ BitmapKey copy$default(BitmapKey bitmapKey, ImageBitmap imageBitmap, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                imageBitmap = bitmapKey.bitmap;
            }
            if ((n & 2) != 0) {
                bl = bitmapKey.isSdf;
            }
            return bitmapKey.copy(imageBitmap, bl);
        }

        @NotNull
        public String toString() {
            return "BitmapKey(bitmap=" + this.bitmap + ", isSdf=" + this.isSdf + ")";
        }

        public int hashCode() {
            int result = this.bitmap.hashCode();
            result = result * 31 + Boolean.hashCode(this.isSdf);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BitmapKey)) {
                return false;
            }
            BitmapKey bitmapKey = (BitmapKey)other;
            if (!Intrinsics.areEqual((Object)this.bitmap, (Object)bitmapKey.bitmap)) {
                return false;
            }
            return this.isSdf == bitmapKey.isSdf;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0081\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\tH\u00c6\u0003\u00a2\u0006\u0002\b\u001cJ\t\u0010\u001d\u001a\u00020\u000bH\u00c6\u0003JB\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001\u00a2\u0006\u0002\b\u001fJ\u0013\u0010 \u001a\u00020\u000b2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020%H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006&"}, d2={"Lorg/maplibre/compose/style/ImageManager$PainterKey;", "", "painter", "Landroidx/compose/ui/graphics/painter/Painter;", "density", "Landroidx/compose/ui/unit/Density;", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "size", "Landroidx/compose/ui/unit/DpSize;", "drawAsSdf", "", "<init>", "(Landroidx/compose/ui/graphics/painter/Painter;Landroidx/compose/ui/unit/Density;Landroidx/compose/ui/unit/LayoutDirection;Landroidx/compose/ui/unit/DpSize;ZLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getPainter", "()Landroidx/compose/ui/graphics/painter/Painter;", "getDensity", "()Landroidx/compose/ui/unit/Density;", "getLayoutDirection", "()Landroidx/compose/ui/unit/LayoutDirection;", "getSize-rqqXlrw", "()Landroidx/compose/ui/unit/DpSize;", "getDrawAsSdf", "()Z", "component1", "component2", "component3", "component4", "component4-rqqXlrw", "component5", "copy", "copy-AlH6bDU", "equals", "other", "hashCode", "", "toString", "", "maplibre-compose"})
    @StabilityInferred(parameters=0)
    public static final class PainterKey {
        @NotNull
        private final Painter painter;
        @NotNull
        private final Density density;
        @NotNull
        private final LayoutDirection layoutDirection;
        @Nullable
        private final DpSize size;
        private final boolean drawAsSdf;
        public static final int $stable = 8;

        private PainterKey(Painter painter, Density density, LayoutDirection layoutDirection, DpSize size, boolean drawAsSdf) {
            Intrinsics.checkNotNullParameter((Object)painter, (String)"painter");
            Intrinsics.checkNotNullParameter((Object)density, (String)"density");
            Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
            this.painter = painter;
            this.density = density;
            this.layoutDirection = layoutDirection;
            this.size = size;
            this.drawAsSdf = drawAsSdf;
        }

        @NotNull
        public final Painter getPainter() {
            return this.painter;
        }

        @NotNull
        public final Density getDensity() {
            return this.density;
        }

        @NotNull
        public final LayoutDirection getLayoutDirection() {
            return this.layoutDirection;
        }

        @Nullable
        public final DpSize getSize-rqqXlrw() {
            return this.size;
        }

        public final boolean getDrawAsSdf() {
            return this.drawAsSdf;
        }

        @NotNull
        public final Painter component1() {
            return this.painter;
        }

        @NotNull
        public final Density component2() {
            return this.density;
        }

        @NotNull
        public final LayoutDirection component3() {
            return this.layoutDirection;
        }

        @Nullable
        public final DpSize component4-rqqXlrw() {
            return this.size;
        }

        public final boolean component5() {
            return this.drawAsSdf;
        }

        @NotNull
        public final PainterKey copy-AlH6bDU(@NotNull Painter painter, @NotNull Density density, @NotNull LayoutDirection layoutDirection, @Nullable DpSize size, boolean drawAsSdf) {
            Intrinsics.checkNotNullParameter((Object)painter, (String)"painter");
            Intrinsics.checkNotNullParameter((Object)density, (String)"density");
            Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
            return new PainterKey(painter, density, layoutDirection, size, drawAsSdf, null);
        }

        public static /* synthetic */ PainterKey copy-AlH6bDU$default(PainterKey painterKey, Painter painter, Density density, LayoutDirection layoutDirection, DpSize dpSize, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                painter = painterKey.painter;
            }
            if ((n & 2) != 0) {
                density = painterKey.density;
            }
            if ((n & 4) != 0) {
                layoutDirection = painterKey.layoutDirection;
            }
            if ((n & 8) != 0) {
                dpSize = painterKey.size;
            }
            if ((n & 0x10) != 0) {
                bl = painterKey.drawAsSdf;
            }
            return painterKey.copy-AlH6bDU(painter, density, layoutDirection, dpSize, bl);
        }

        @NotNull
        public String toString() {
            return "PainterKey(painter=" + this.painter + ", density=" + this.density + ", layoutDirection=" + this.layoutDirection + ", size=" + this.size + ", drawAsSdf=" + this.drawAsSdf + ")";
        }

        public int hashCode() {
            int result = this.painter.hashCode();
            result = result * 31 + this.density.hashCode();
            result = result * 31 + this.layoutDirection.hashCode();
            result = result * 31 + (this.size == null ? 0 : DpSize.hashCode-impl((long)this.size.unbox-impl()));
            result = result * 31 + Boolean.hashCode(this.drawAsSdf);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PainterKey)) {
                return false;
            }
            PainterKey painterKey = (PainterKey)other;
            if (!Intrinsics.areEqual((Object)this.painter, (Object)painterKey.painter)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.density, (Object)painterKey.density)) {
                return false;
            }
            if (this.layoutDirection != painterKey.layoutDirection) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.size, (Object)painterKey.size)) {
                return false;
            }
            return this.drawAsSdf == painterKey.drawAsSdf;
        }

        public /* synthetic */ PainterKey(Painter painter, Density density, LayoutDirection layoutDirection, DpSize size, boolean drawAsSdf, DefaultConstructorMarker $constructor_marker) {
            this(painter, density, layoutDirection, size, drawAsSdf);
        }
    }
}

