/*
 * Decompiled with CFR 0.152.
 */
package org.maplibre.compose.style;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0013\n\u0002\b\n\u001a,\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00012\b\b\u0002\u0010\t\u001a\u00020\u0001H\u0000\u001a8\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\fH\u0002\u001a@\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"INF", "", "convertToSdf", "", "bitmap", "", "width", "", "radius", "cutoff", "edt", "data", "", "height", "f", "v", "z", "edt1d", "grid", "offset", "stride", "length", "maplibre-compose"})
public final class ConvertToSdfKt {
    private static final double INF = 1.0E20;

    public static final void convertToSdf(@NotNull int[] bitmap, int width, double radius, double cutoff) {
        int a;
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        int height = bitmap.length / width;
        int n = bitmap.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            double d;
            int n2 = i;
            a = bitmap[n2] >>> 24;
            switch (a) {
                case 0: {
                    d = 1.0E20;
                    break;
                }
                case 255: {
                    d = 0.0;
                    break;
                }
                default: {
                    double d2 = (double)0.5f - (double)a / 255.0;
                    d = d2 > 0.0 ? d2 * d2 : 0.0;
                }
            }
            dArray[n2] = d;
        }
        double[] gridOuter = dArray;
        int n3 = bitmap.length;
        double[] dArray2 = new double[n3];
        for (n = 0; n < n3; ++n) {
            double d;
            a = n;
            int a2 = bitmap[a] >>> 24;
            switch (a2) {
                case 0: {
                    d = 0.0;
                    break;
                }
                case 255: {
                    d = 1.0E20;
                    break;
                }
                default: {
                    double d3 = (double)0.5f - (double)a2 / 255.0;
                    d = d3 < 0.0 ? d3 * d3 : 0.0;
                }
            }
            dArray2[a] = d;
        }
        double[] gridInner = dArray2;
        int size = Math.max(width, height);
        double[] f = new double[size];
        double[] z = new double[size + 1];
        int[] v = new int[size];
        ConvertToSdfKt.edt(gridOuter, width, height, f, v, z);
        ConvertToSdfKt.edt(gridInner, width, height, f, v, z);
        int n4 = bitmap.length;
        for (int i = 0; i < n4; ++i) {
            double dist = Math.sqrt(gridOuter[i]) - Math.sqrt(gridInner[i]);
            bitmap[i] = RangesKt.coerceIn((int)((int)Math.rint((double)255 - (double)255 * (dist / radius + cutoff))), (int)0, (int)255) << 24;
        }
    }

    public static /* synthetic */ void convertToSdf$default(int[] nArray, int n, double d, double d2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            d = 8.0;
        }
        if ((n2 & 8) != 0) {
            d2 = 0.25;
        }
        ConvertToSdfKt.convertToSdf(nArray, n, d, d2);
    }

    private static final void edt(double[] data, int width, int height, double[] f, int[] v, double[] z) {
        for (int x = 0; x < width; ++x) {
            ConvertToSdfKt.edt1d(data, x, width, height, f, v, z);
        }
        for (int y = 0; y < height; ++y) {
            ConvertToSdfKt.edt1d(data, y * width, 1, width, f, v, z);
        }
    }

    private static final void edt1d(double[] grid, int offset, int stride, int length, double[] f, int[] v, double[] z) {
        v[0] = 0;
        z[0] = -1.0E20;
        z[1] = 1.0E20;
        f[0] = grid[offset];
        int k = 0;
        int q = 1;
        while (q < length) {
            int r;
            f[q] = grid[offset + q * stride];
            int q2 = q * q;
            double s = 0.0;
            while ((s = (f[q] - f[r = v[k]] + (double)q2 - (double)(r * r)) / (double)(q - r) / 2.0) <= z[k] && --k > -1) {
            }
            v[++k] = q++;
            z[k] = s;
            z[k + 1] = 1.0E20;
        }
        k = 0;
        for (q = 0; q < length; ++q) {
            while (z[k + 1] < (double)q) {
                ++k;
            }
            int r = v[k];
            int qr = q - r;
            grid[offset + q * stride] = f[r] + (double)(qr * qr);
        }
    }
}

