/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.dynamic.segment;

import io.lettuce.core.dynamic.parameter.MethodParametersAccessor;
import io.lettuce.core.dynamic.parameter.Parameter;
import io.lettuce.core.internal.LettuceAssert;

public abstract class CommandSegment {
    public static CommandSegment constant(String content) {
        return new Constant(content);
    }

    public static CommandSegment namedParameter(String name) {
        return new NamedParameter(name);
    }

    public static CommandSegment indexedParameter(int index) {
        return new IndexedParameter(index);
    }

    public abstract String asString();

    public abstract boolean canConsume(Parameter var1);

    public abstract ArgumentContribution contribute(MethodParametersAccessor var1);

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" ").append(this.asString());
        return sb.toString();
    }

    private static class Constant
    extends CommandSegment {
        private final String content;

        public Constant(String content) {
            LettuceAssert.notEmpty((CharSequence)content, "Constant must not be empty");
            this.content = content;
        }

        @Override
        public String asString() {
            return this.content;
        }

        @Override
        public boolean canConsume(Parameter parameter) {
            return false;
        }

        @Override
        public ArgumentContribution contribute(MethodParametersAccessor parametersAccessor) {
            return new ArgumentContribution(-1, this.asString());
        }
    }

    private static class NamedParameter
    extends CommandSegment {
        private final String name;

        public NamedParameter(String name) {
            LettuceAssert.notEmpty((CharSequence)name, "Parameter name must not be empty");
            this.name = name;
        }

        @Override
        public String asString() {
            return this.name;
        }

        @Override
        public boolean canConsume(Parameter parameter) {
            return parameter.getName() != null && parameter.getName().equals(this.name);
        }

        @Override
        public ArgumentContribution contribute(MethodParametersAccessor parametersAccessor) {
            int index = parametersAccessor.resolveParameterIndex(this.name);
            return new ArgumentContribution(index, parametersAccessor.getBindableValue(index));
        }
    }

    private static class IndexedParameter
    extends CommandSegment {
        private final int index;

        public IndexedParameter(int index) {
            LettuceAssert.isTrue(index >= 0, "Parameter index must be non-negative starting at 0");
            this.index = index;
        }

        @Override
        public String asString() {
            return Integer.toString(this.index);
        }

        @Override
        public boolean canConsume(Parameter parameter) {
            return parameter.getParameterIndex() == this.index;
        }

        @Override
        public ArgumentContribution contribute(MethodParametersAccessor parametersAccessor) {
            return new ArgumentContribution(this.index, parametersAccessor.getBindableValue(this.index));
        }
    }

    public static class ArgumentContribution {
        private final int parameterIndex;
        private final Object value;

        ArgumentContribution(int parameterIndex, Object value) {
            this.parameterIndex = parameterIndex;
            this.value = value;
        }

        public int getParameterIndex() {
            return this.parameterIndex;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

